/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotation.ui.internal.cmp.wizards;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.ejb.annotation.internal.messages.IEJBAnnotationConstants;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.CMPAttributeDelegate;
import org.eclipse.jst.j2ee.ejb.annotation.ui.internal.EjbAnnotationsUiPlugin;
import org.eclipse.jst.j2ee.ejb.annotation.ui.internal.cmp.wizards.AddContainerManagedEntityEjbWizard;
import org.eclipse.jst.j2ee.ejb.annotation.ui.internal.cmp.wizards.CMPUtils;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class ChooseTableWizardPage
extends DataModelWizardPage {
    protected final Image fChecked = EjbAnnotationsUiPlugin.getDefault().getImageDescriptor("icons/checked.gif").createImage();
    protected final Image fUnchecked = EjbAnnotationsUiPlugin.getDefault().getImageDescriptor("icons/unchecked.gif").createImage();
    private String[] sqlTypes = CMPUtils.sqlTypes;
    private Combo catalogButton;
    private Table attributeTable;
    private TableViewer attributeTableViewer;
    private Button add;
    private Button remove;
    private ArrayList tableList = new ArrayList();
    protected static String[] columnNames = new String[]{IEJBAnnotationConstants.ATTRIBUTE_NAME, IEJBAnnotationConstants.ATTRIBUTE_COLUMN, IEJBAnnotationConstants.ATTRIBUTE_TYPE, IEJBAnnotationConstants.ATTRIBUTE_SQLTYPE, IEJBAnnotationConstants.ATTRIBUTE_JDBCTYPE, IEJBAnnotationConstants.ATTRIBUTE_COLUMNSIZE, IEJBAnnotationConstants.ATTRIBUTE_DECIMALDIGITS, IEJBAnnotationConstants.ATTRIBUTE_READONLY, IEJBAnnotationConstants.ATTRIBUTE_ISKEY};

    public void dispose() {
        super.dispose();
        this.fUnchecked.dispose();
        this.fChecked.dispose();
    }

    public ChooseTableWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setDescription(IEJBAnnotationConstants.ADD_CMP_TABLE_WIZARD_PAGE_DESC);
        this.setTitle(IEJBAnnotationConstants.ADD_CMP_TABLE_WIZARD_PAGE_TITLE);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"EntityBeanDataModel.ATTRIBUTES", "EntityBeanDataModel.TABLE"};
    }

    protected List getAttributes() {
        List attr = (List)this.getDataModel().getProperty("EntityBeanDataModel.ATTRIBUTES");
        if (!this.getDataModel().isPropertySet("EntityBeanDataModel.ATTRIBUTES")) {
            this.getDataModel().setProperty("EntityBeanDataModel.ATTRIBUTES", (Object)attr);
        }
        return attr;
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        Composite group = new Composite(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(1808));
        this.createCatalogGroup(group);
        this.attributeTable = this.createTable(composite);
        this.attributeTableViewer = this.createTableViewer(this.attributeTable);
        return composite;
    }

    protected void createCatalogGroup(Composite composite) {
        Label catalogLabel = new Label(composite, 16384);
        catalogLabel.setText(IEJBAnnotationConstants.CMP_TABLE_CHOOSE_TABLE);
        catalogLabel.setLayoutData((Object)new GridData(32));
        this.catalogButton = ((AddContainerManagedEntityEjbWizard)this.getWizard()).isJavaBean() ? new Combo(composite, 4) : new Combo(composite, 4);
        this.synchHelper.synchCombo(this.catalogButton, "EntityBeanDataModel.TABLE", null);
        this.catalogButton.setLayoutData((Object)new GridData(1792));
        this.catalogButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (ChooseTableWizardPage.this.tableList.size() >= 1 && ChooseTableWizardPage.this.catalogButton.getSelectionIndex() != -1) {
                    ChooseTableWizardPage.this.fillTableWith((String)ChooseTableWizardPage.this.tableList.get(ChooseTableWizardPage.this.catalogButton.getSelectionIndex()));
                    ChooseTableWizardPage.this.attributeTable.removeAll();
                    ChooseTableWizardPage.this.attributeTable.setData((Object)ChooseTableWizardPage.this.getAttributes());
                    ChooseTableWizardPage.this.attributeTableViewer.setInput((Object)ChooseTableWizardPage.this.getAttributes());
                    ChooseTableWizardPage.this.attributeTableViewer.refresh();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.updateTables();
    }

    private void fillTableWith(String tableName) {
        Connection connection = null;
        ArrayList<CMPAttributeDelegate> attributes = new ArrayList<CMPAttributeDelegate>();
        if (!((AddContainerManagedEntityEjbWizard)this.getWizard()).isJavaBean()) {
            try {
                IConnectionProfile connectionInfo = this.getConnectionInfo();
                if (connectionInfo == null) {
                    return;
                }
                IStatus connectionStatus = connectionInfo.connect();
                if (!connectionStatus.isOK()) {
                    return;
                }
                IConnection dbConnection = connectionInfo.getManagedConnection("java.sql.Connection").getConnection();
                connection = (Connection)dbConnection.getRawConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                String schema = null;
                int scIndex = tableName.indexOf(".");
                if (scIndex >= 0) {
                    schema = tableName.substring(0, scIndex);
                    tableName = tableName.substring(scIndex + 1);
                }
                ResultSet columns = metaData.getColumns(null, schema, tableName, "%");
                while (columns.next()) {
                    int datasize = columns.getInt("COLUMN_SIZE");
                    int digits = columns.getInt("DECIMAL_DIGITS");
                    CMPAttributeDelegate atr = new CMPAttributeDelegate();
                    atr.setName(columns.getString("COLUMN_NAME").toLowerCase());
                    atr.setAttributeType(CMPUtils.getAttributeType(columns.getInt("DATA_TYPE")));
                    atr.setJdbcType(CMPUtils.getSqlType(columns.getInt("DATA_TYPE")));
                    atr.setSqlType(columns.getString("TYPE_NAME"));
                    atr.setColumnName(columns.getString("COLUMN_NAME"));
                    atr.setDecimalDigits(digits);
                    atr.setColumnSize(datasize);
                    attributes.add(atr);
                }
                ResultSet primaryKeys = metaData.getPrimaryKeys(null, schema, tableName);
                while (primaryKeys.next()) {
                    String key = primaryKeys.getString("COLUMN_NAME");
                    Iterator iterator = attributes.iterator();
                    while (iterator.hasNext()) {
                        CMPAttributeDelegate attr = (CMPAttributeDelegate)iterator.next();
                        if (!key.equals(attr.getColumnName())) continue;
                        attr.setKey(true);
                    }
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                MessageDialog.openError((Shell)this.getShell(), (String)IEJBAnnotationConstants.CANNOT_CONNECT, (String)IEJBAnnotationConstants.CHECK_PROPERTIES);
            }
        }
        this.getDataModel().setProperty("EntityBeanDataModel.ATTRIBUTES", attributes);
    }

    public void updateTables() {
        if (this.catalogButton == null) {
            return;
        }
        if (((AddContainerManagedEntityEjbWizard)this.getWizard()).isJavaBean()) {
            this.catalogButton.removeAll();
            return;
        }
        Connection connection = null;
        this.tableList = new ArrayList();
        try {
            IConnectionProfile connectionInfo = this.getConnectionInfo();
            if (connectionInfo == null) {
                return;
            }
            IStatus connectionStatus = connectionInfo.connect();
            if (!connectionStatus.isOK()) {
                return;
            }
            IConnection dbConnection = connectionInfo.getManagedConnection("java.sql.Connection").getConnection();
            connection = (Connection)dbConnection.getRawConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            String[] names = new String[]{"TABLE"};
            ResultSet rs = metaData.getSchemas();
            ResultSet tableNames = null;
            while (rs.next()) {
                tableNames = metaData.getTables(null, rs.getString(1), "%", names);
                while (tableNames.next()) {
                    this.tableList.add(String.valueOf(rs.getString(1)) + "." + tableNames.getString("TABLE_NAME"));
                }
            }
            ResultSet sqlTypeNames = metaData.getTypeInfo();
            ArrayList<String> types = new ArrayList<String>();
            while (sqlTypeNames.next()) {
                types.add(sqlTypeNames.getString("TYPE_NAME"));
            }
            sqlTypeNames = metaData.getUDTs(null, "%", "%", null);
            while (sqlTypeNames.next()) {
                types.remove(sqlTypeNames.getString("TYPE_NAME"));
            }
            this.sqlTypes = types.toArray(new String[types.size()]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)IEJBAnnotationConstants.CANNOT_CONNECT, (String)IEJBAnnotationConstants.CHECK_PROPERTIES);
        }
        this.catalogButton.setItems(this.tableList.toArray(new String[this.tableList.size()]));
        this.catalogButton.select(0);
        if (this.tableList.size() > 0) {
            this.fillTableWith((String)this.tableList.get(0));
            this.catalogButton.setEnabled(true);
            if (this.attributeTableViewer != null) {
                this.attributeTableViewer.refresh();
            }
        }
        if (this.remove != null) {
            this.remove.setEnabled(false);
        }
    }

    public IConnectionProfile getConnectionInfo() {
        return ((AddContainerManagedEntityEjbWizard)this.getWizard()).getConnectionInfo();
    }

    private Table createTable(Composite parent) {
        int style = 101124;
        Group libraryPanel = new Group(parent, 0);
        libraryPanel.setText(IEJBAnnotationConstants.CMP_MANAGED_FIELDS);
        GridLayout layout = new GridLayout(2, false);
        libraryPanel.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 300;
        libraryPanel.setLayoutData((Object)gridData);
        this.attributeTable = new Table((Composite)libraryPanel, style);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.attributeTable.setLayoutData((Object)gridData);
        this.attributeTable.setLinesVisible(true);
        this.attributeTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.attributeTable, 16384, 0);
        column.setText(IEJBAnnotationConstants.ATTRIBUTE_NAME);
        column.setWidth(60);
        column = new TableColumn(this.attributeTable, 16384, 1);
        column.setText(IEJBAnnotationConstants.ATTRIBUTE_COLUMN);
        column.setWidth(60);
        column = new TableColumn(this.attributeTable, 16384, 2);
        column.setText(IEJBAnnotationConstants.ATTRIBUTE_TYPE);
        column.setWidth(120);
        column = new TableColumn(this.attributeTable, 16384, 3);
        column.setText(IEJBAnnotationConstants.ATTRIBUTE_JDBCTYPE);
        column.setWidth(80);
        column = new TableColumn(this.attributeTable, 16384, 4);
        column.setText(IEJBAnnotationConstants.ATTRIBUTE_SQLTYPE);
        column.setWidth(80);
        column = new TableColumn(this.attributeTable, 16384, 5);
        column.setText(IEJBAnnotationConstants.ATTRIBUTE_COLUMNSIZE);
        column.setWidth(60);
        column = new TableColumn(this.attributeTable, 16384, 6);
        column.setText(IEJBAnnotationConstants.ATTRIBUTE_DECIMALDIGITS);
        column.setWidth(60);
        column = new TableColumn(this.attributeTable, 0x1000000, 7);
        column.setText(IEJBAnnotationConstants.ATTRIBUTE_READONLY);
        column.setWidth(80);
        column = new TableColumn(this.attributeTable, 0x1000000, 8);
        column.setText(IEJBAnnotationConstants.ATTRIBUTE_ISKEY);
        column.setWidth(80);
        this.addAttributeButtons((Composite)libraryPanel);
        this.attributeTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChooseTableWizardPage.this.attributeTable.getSelectionCount();
                ChooseTableWizardPage.this.remove.setEnabled(ChooseTableWizardPage.this.attributeTable.getSelectionCount() > 0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return this.attributeTable;
    }

    private void addAttributeButtons(Composite parent) {
        this.add = new Button(parent, 8);
        this.add.setText(IEJBAnnotationConstants.ATTRIBUTE_ADD);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 1;
        this.add.setLayoutData((Object)data);
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                CMPAttributeDelegate atr = new CMPAttributeDelegate();
                ChooseTableWizardPage.this.getAttributes().add(atr);
                ChooseTableWizardPage.this.validatePage();
                ChooseTableWizardPage.this.attributeTableViewer.refresh();
            }
        });
        this.remove = new Button(parent, 8);
        this.remove.setText(IEJBAnnotationConstants.ATTRIBUTE_REMOVE);
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 1;
        this.remove.setLayoutData((Object)data);
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem ti = ChooseTableWizardPage.this.attributeTable.getSelection()[0];
                CMPAttributeDelegate attributeDelegate = (CMPAttributeDelegate)ti.getData();
                ChooseTableWizardPage.this.getAttributes().remove(attributeDelegate);
                ChooseTableWizardPage.this.validatePage();
                ChooseTableWizardPage.this.attributeTableViewer.refresh();
                ChooseTableWizardPage.this.remove.setEnabled(false);
            }
        });
        this.remove.setEnabled(false);
    }

    private TableViewer createTableViewer(Table table) {
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setUseHashlookup(true);
        tableViewer.setColumnProperties(columnNames);
        tableViewer.setLabelProvider((IBaseLabelProvider)new FieldLabelProvider());
        tableViewer.setContentProvider((IContentProvider)new FieldContentProvider());
        CellEditor[] editors = new CellEditor[columnNames.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)table);
        ((Text)textEditor.getControl()).setTextLimit(200);
        editors[0] = textEditor;
        TextCellEditor textEditor2 = new TextCellEditor((Composite)table);
        ((Text)textEditor2.getControl()).setTextLimit(200);
        editors[1] = textEditor2;
        TextCellEditor textEditor3 = new TextCellEditor((Composite)table);
        ((Text)textEditor3.getControl()).setTextLimit(200);
        IProject project = ((AddContainerManagedEntityEjbWizard)this.getWizard()).getDefaultEjbProject();
        IPackageFragmentRoot[] sources = J2EEProjectUtilities.getSourceContainers((IProject)project);
        if (sources != null && sources.length >= 1) {
            JavaTypeCompletionProcessor fFieldTypeCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
            fFieldTypeCompletionProcessor.setPackageFragment(sources[0].getPackageFragment(""));
            ControlContentAssistHelper.createTextContentAssistant((Text)((Text)textEditor3.getControl()), (IContentAssistProcessor)fFieldTypeCompletionProcessor);
        }
        editors[2] = textEditor3;
        editors[3] = new ComboBoxCellEditor((Composite)table, CMPUtils.jdbcTypes, 8);
        editors[4] = new ComboBoxCellEditor((Composite)table, this.sqlTypes, 8);
        TextCellEditor textEditor5 = new TextCellEditor((Composite)table);
        ((Text)textEditor5.getControl()).setTextLimit(200);
        editors[5] = textEditor5;
        TextCellEditor textEditor6 = new TextCellEditor((Composite)table);
        ((Text)textEditor6.getControl()).setTextLimit(200);
        editors[6] = textEditor6;
        editors[7] = new CheckboxCellEditor((Composite)table, 0x1000000);
        editors[8] = new CheckboxCellEditor((Composite)table, 0x1000000);
        tableViewer.setCellEditors(editors);
        tableViewer.setCellModifier((ICellModifier)new FieldCellModifier());
        tableViewer.setInput((Object)this.getAttributes());
        return tableViewer;
    }

    protected int getColumnIndex(String columName) {
        if (columName == null) {
            return -1;
        }
        int i = 0;
        while (i < columnNames.length) {
            String col = columnNames[i];
            if (columName.equals(col)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public class FieldCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            CMPAttributeDelegate attribute = (CMPAttributeDelegate)element;
            if (IEJBAnnotationConstants.ATTRIBUTE_DECIMALDIGITS.equals(property)) {
                return attribute.isDecimal();
            }
            if (IEJBAnnotationConstants.ATTRIBUTE_COLUMNSIZE.equals(property)) {
                return attribute.isVariableSizedType();
            }
            return true;
        }

        public Object getValue(Object element, String property) {
            int columnIndex = ChooseTableWizardPage.this.getColumnIndex(property);
            CMPAttributeDelegate fieldMapping = (CMPAttributeDelegate)element;
            String result = "";
            switch (columnIndex) {
                case 0: {
                    return fieldMapping.getName();
                }
                case 1: {
                    return fieldMapping.getColumnName();
                }
                case 2: {
                    return fieldMapping.getAttributeType();
                }
                case 3: {
                    String val = fieldMapping.getJdbcType();
                    int i = 0;
                    while (i < CMPUtils.jdbcTypes.length) {
                        String t = CMPUtils.jdbcTypes[i];
                        if (t.equals(val)) {
                            return new Integer(i);
                        }
                        ++i;
                    }
                    return new Integer(0);
                }
                case 4: {
                    String val = fieldMapping.getSqlType();
                    int i = 0;
                    while (i < ChooseTableWizardPage.this.sqlTypes.length) {
                        String t = ChooseTableWizardPage.this.sqlTypes[i];
                        if (t.equals(val)) {
                            return new Integer(i);
                        }
                        ++i;
                    }
                    return new Integer(0);
                }
                case 5: {
                    if (fieldMapping.isVariableSizedType()) {
                        return "" + fieldMapping.getColumnSize();
                    }
                    return "";
                }
                case 6: {
                    if (fieldMapping.isDecimal()) {
                        return "" + fieldMapping.getDecimalDigits();
                    }
                    return "";
                }
                case 7: {
                    return fieldMapping.isReadOnly();
                }
                case 8: {
                    return fieldMapping.isKey();
                }
                case 9: {
                    return fieldMapping.isTransient();
                }
            }
            result = "";
            return result;
        }

        public void modify(Object element, String property, Object value) {
            int columnIndex = ChooseTableWizardPage.this.getColumnIndex(property);
            TableItem tItem = (TableItem)element;
            CMPAttributeDelegate fieldMapping = (CMPAttributeDelegate)tItem.getData();
            switch (columnIndex) {
                case 0: {
                    fieldMapping.setName((String)value);
                    break;
                }
                case 1: {
                    fieldMapping.setColumnName((String)value);
                    break;
                }
                case 2: {
                    fieldMapping.setAttributeType((String)value);
                    break;
                }
                case 3: {
                    fieldMapping.setJdbcType(CMPUtils.jdbcTypes[(Integer)value]);
                    int sqli = CMPUtils.getSqlTypeFromJDBC((Integer)value);
                    if (sqli < 0) break;
                    fieldMapping.setSqlType(ChooseTableWizardPage.this.sqlTypes[sqli]);
                    tItem.getParent().redraw();
                    break;
                }
                case 4: {
                    String sqlType = ChooseTableWizardPage.this.sqlTypes[(Integer)value];
                    fieldMapping.setSqlType(sqlType);
                    break;
                }
                case 5: {
                    if (!fieldMapping.isVariableSizedType()) break;
                    int colSize = Integer.parseInt((String)value);
                    fieldMapping.setColumnSize(colSize);
                    break;
                }
                case 6: {
                    if (!fieldMapping.isDecimal()) break;
                    int decDigits = Integer.parseInt((String)value);
                    fieldMapping.setDecimalDigits(decDigits);
                    break;
                }
                case 7: {
                    boolean readValue = (Boolean)value;
                    fieldMapping.setReadOnly(readValue);
                    break;
                }
                case 8: {
                    boolean newValue = (Boolean)value;
                    fieldMapping.setKey(newValue);
                    break;
                }
                case 9: {
                    fieldMapping.setTransient(((Boolean)value).booleanValue());
                }
            }
            ChooseTableWizardPage.this.validatePage();
            ChooseTableWizardPage.this.attributeTableViewer.refresh();
        }
    }

    public class FieldContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object parent) {
            return ChooseTableWizardPage.this.getAttributes().toArray();
        }
    }

    public class FieldLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            CMPAttributeDelegate fieldMapping = (CMPAttributeDelegate)obj;
            switch (index) {
                case 0: {
                    return fieldMapping.getName();
                }
                case 1: {
                    return fieldMapping.getColumnName();
                }
                case 2: {
                    return fieldMapping.getAttributeType();
                }
                case 3: {
                    return fieldMapping.getJdbcType();
                }
                case 4: {
                    return fieldMapping.getSqlType();
                }
                case 5: {
                    if (fieldMapping.isVariableSizedType()) {
                        return "" + fieldMapping.getColumnSize();
                    }
                    return "";
                }
                case 6: {
                    if (fieldMapping.isDecimal()) {
                        return "" + fieldMapping.getDecimalDigits();
                    }
                    return "";
                }
                case 7: {
                    return "";
                }
                case 8: {
                    return "";
                }
            }
            return "";
        }

        public String getColumnText(Viewer v, Object obj, int index) {
            return this.getColumnText(obj, index);
        }

        public Image getColumnImage(Object obj, int index) {
            CMPAttributeDelegate fieldMapping = (CMPAttributeDelegate)obj;
            switch (index) {
                case 7: {
                    if (fieldMapping.isReadOnly()) {
                        return ChooseTableWizardPage.this.fChecked;
                    }
                    return ChooseTableWizardPage.this.fUnchecked;
                }
                case 8: {
                    if (fieldMapping.isKey()) {
                        return ChooseTableWizardPage.this.fChecked;
                    }
                    return ChooseTableWizardPage.this.fUnchecked;
                }
                case 9: {
                    if (fieldMapping.isTransient()) {
                        return ChooseTableWizardPage.this.fChecked;
                    }
                    return ChooseTableWizardPage.this.fUnchecked;
                }
            }
            return null;
        }

        public Image getColumnImage(Viewer v, Object obj, int index) {
            return this.getColumnImage(obj, index);
        }
    }
}

