/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.events;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiEventDispatcher {
    private static final int MS_TO_MIN_MULTIPLICATOR = 60000;
    private static final Logger LOG = LoggerFactory.getLogger(GuiEventDispatcher.class);
    private static GuiEventDispatcher instance = null;
    private Set<IEditorDirtyStateListener> m_editorDirtyStateListeners = new HashSet<IEditorDirtyStateListener>();
    private Set<IEditorDirtyStateListener> m_editorDirtyStateListenersPost = new HashSet<IEditorDirtyStateListener>();
    private ScheduledExecutorService m_dirtyScheduler = Executors.newSingleThreadScheduledExecutor();
    private volatile long m_dirtyTimestamp = System.currentTimeMillis();
    private volatile boolean m_dirtyTimer = false;

    private GuiEventDispatcher() {
        this.m_dirtyScheduler = Executors.newSingleThreadScheduledExecutor();
        this.m_dirtyScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long timer = GuiEventDispatcher.this.m_dirtyTimestamp + (long)(Plugin.getDefault().getPreferenceStore().getInt("SAVE_REMINDER_INTERVAL_KEY") * 60000);
                boolean enabled = Plugin.getDefault().getPreferenceStore().getBoolean("SAVE_REMINDER_ENABLE_KEY");
                if (System.currentTimeMillis() > timer && enabled && GuiEventDispatcher.this.m_dirtyTimer) {
                    GuiEventDispatcher.this.showSaveReminder();
                    GuiEventDispatcher.this.updateDirtyTimer(false);
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    private void showSaveReminder() {
        final String message = NLS.bind((String)Messages.EditorSaveReminder, (Object)Plugin.getDefault().getPreferenceStore().getInt("SAVE_REMINDER_INTERVAL_KEY"));
        Plugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Warning", (String)message);
            }
        });
    }

    public static synchronized GuiEventDispatcher getInstance() {
        if (instance == null) {
            instance = new GuiEventDispatcher();
        }
        return instance;
    }

    public void addEditorDirtyStateListener(IEditorDirtyStateListener l, boolean guiMode) {
        if (guiMode) {
            this.m_editorDirtyStateListenersPost.add(l);
        } else {
            this.m_editorDirtyStateListeners.add(l);
        }
    }

    public void removeEditorDirtyStateListener(IEditorDirtyStateListener l) {
        this.m_editorDirtyStateListeners.remove(l);
        this.m_editorDirtyStateListenersPost.remove(l);
        this.updateDirtyTimer(false);
    }

    public void fireEditorDirtyStateListener(IJBEditor editor, boolean isDirty) {
        HashSet<IEditorDirtyStateListener> stableListeners = new HashSet<IEditorDirtyStateListener>(this.m_editorDirtyStateListeners);
        for (IEditorDirtyStateListener l : stableListeners) {
            try {
                l.handleEditorDirtyStateChanged(editor, isDirty);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionCallingListeners, t);
            }
        }
        HashSet<IEditorDirtyStateListener> stableListenersPost = new HashSet<IEditorDirtyStateListener>(this.m_editorDirtyStateListenersPost);
        for (IEditorDirtyStateListener l : stableListenersPost) {
            try {
                l.handleEditorDirtyStateChanged(editor, isDirty);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionCallingListeners, t);
            }
        }
        this.updateDirtyTimer(isDirty);
    }

    private synchronized void updateDirtyTimer(boolean dirty) {
        if (dirty && !this.m_dirtyTimer) {
            this.m_dirtyTimestamp = System.currentTimeMillis();
        }
        this.m_dirtyTimer = dirty;
    }

    public static interface IEditorDirtyStateListener {
        public void handleEditorDirtyStateChanged(IJBEditor var1, boolean var2);
    }
}

