/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.pages;

import java.awt.Desktop;
import java.net.URI;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ProjectVersion;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.UIComponentHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class UpdateReusedProjectsDialog
extends TitleAreaDialog
implements ISelectionChangedListener {
    private static final String PROJECT_NAME_COLUMN = "Project Name";
    private static final String CURRENT_VERSION = "Current version";
    private static final String NEW_VERSION = "New version";
    private static final int MARGIN = 20;
    private Map<IReusedProjectPO, ProjectVersion> m_oldReusedProjects;
    private Button m_dontAskAgain;
    private ColumnLabelProvider m_nameProvider = new ColumnLabelProvider(){

        public String getText(Object element) {
            Map.Entry project;
            if (element instanceof Map.Entry && (project = (Map.Entry)element).getKey() instanceof IReusedProjectPO) {
                return ((IReusedProjectPO)project.getKey()).getName();
            }
            return "";
        }
    };
    private ColumnLabelProvider m_currentVersionProvider = new ColumnLabelProvider(){

        public String getText(Object element) {
            Map.Entry project;
            if (element instanceof Map.Entry && (project = (Map.Entry)element).getKey() instanceof IReusedProjectPO) {
                return ((IReusedProjectPO)project.getKey()).getVersionString();
            }
            return "";
        }
    };
    private ColumnLabelProvider m_newVersionProvider = new ColumnLabelProvider(){

        public String getText(Object element) {
            Map.Entry project;
            if (element instanceof Map.Entry && (project = (Map.Entry)element).getValue() instanceof ProjectVersion) {
                return ((ProjectVersion)project.getValue()).toString();
            }
            return "";
        }
    };

    public UpdateReusedProjectsDialog(Shell shell, Map<IReusedProjectPO, ProjectVersion> oldReusedProjects) {
        super(shell);
        this.m_oldReusedProjects = oldReusedProjects;
    }

    public Control createDialogArea(Composite parent) {
        this.setTitle(Messages.UpdateReusedProjectsTitle);
        this.setTitleImage(IconConstants.getImage((String)"bigProject.gif"));
        this.setMessage(Messages.UpdateReusedProjectsMessage);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)layout);
        LayoutUtil.createSeparator((Composite)this.createComposite(parent, 0, 20));
        TableViewer viewer = new TableViewer(this.createComposite(parent), 0);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)new GeneralContentProvider());
        this.createColumns(viewer);
        viewer.setInput(this.m_oldReusedProjects);
        Table table = viewer.getTable();
        table.setData("TEST_COMP_NAME", (Object)Messages.UpdateReusedProjectsWidgetName);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData tableGridData = new GridData(1808);
        tableGridData.grabExcessVerticalSpace = true;
        tableGridData.horizontalSpan = 3;
        table.setLayoutData((Object)tableGridData);
        this.createComposite(parent, 20, 20);
        this.createDontAskCheckBox(this.createComposite(parent));
        this.createOkLabel(this.createComposite(parent));
        LayoutUtil.createSeparator((Composite)this.createComposite(parent, 20, 0));
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.projectUsedPropertyPageContextId");
        return parent;
    }

    private Composite createComposite(Composite parent) {
        return this.createComposite(parent, 0, 0);
    }

    private Composite createComposite(Composite parent, int top, int bottom) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginTop = top;
        layout.marginBottom = bottom;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void createOkLabel(Composite parent) {
        String text = Messages.UpdateReusedProjectsMessage;
        Label nextLabel = UIComponentHelper.createLabelWithText((Composite)parent, (String)text);
        Link link = new Link(parent, 0);
        link.setText(Messages.DatabaseMigrationWebsiteLinkLabel);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UpdateReusedProjectsDialog.this.openUri(Messages.DatabaseMigrationWebsiteLink);
            }
        });
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 3;
        nextLabel.setLayoutData((Object)gridData);
    }

    private void openUri(String uriString) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                URI uri = new URI(uriString);
                desktop.browse(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createColumns(TableViewer tableViewer) {
        this.createTableViewerColumn(tableViewer, PROJECT_NAME_COLUMN, 200).setLabelProvider((CellLabelProvider)this.m_nameProvider);
        this.createTableViewerColumn(tableViewer, CURRENT_VERSION, 150).setLabelProvider((CellLabelProvider)this.m_currentVersionProvider);
        this.createTableViewerColumn(tableViewer, NEW_VERSION, 150).setLabelProvider((CellLabelProvider)this.m_newVersionProvider);
    }

    private TableViewerColumn createTableViewerColumn(TableViewer tableViewer, String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private void createDontAskCheckBox(Composite parent) {
        this.m_dontAskAgain = new Button(parent, 32);
        this.m_dontAskAgain.setText(Messages.InfoNaggerDialogToggleMsg);
        this.m_dontAskAgain.setSelection(Plugin.getDefault().getPreferenceStore().getBoolean("UPDATE_REUSED_PROJECT_KEY"));
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 3;
        this.m_dontAskAgain.setLayoutData((Object)data);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!event.getSelection().isEmpty() && event.getSource() instanceof TableViewer) {
            ((TableViewer)event.getSource()).setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    protected void okPressed() {
        Plugin.getDefault().getPreferenceStore().setValue("UPDATE_REUSED_PROJECT_KEY", this.m_dontAskAgain.getSelection());
        super.okPressed();
    }

    private static class GeneralContentProvider
    implements IStructuredContentProvider {
        private GeneralContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof Map) {
                return ((Map)inputElement).entrySet().toArray();
            }
            return null;
        }
    }
}

