/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.communication.internal.connection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import org.eclipse.jubula.communication.internal.connection.ConnectionState;
import org.eclipse.jubula.communication.internal.connection.DefaultSocket;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientSocket
extends DefaultSocket {
    private static Logger log = LoggerFactory.getLogger(DefaultClientSocket.class);
    private boolean m_connectionEstablished = false;
    private int m_state = -1;
    private BufferedReader m_inputStreamReader;

    public DefaultClientSocket(InetAddress address, int port, long waitForServer) throws IOException, JBVersionException {
        super(address, port);
        this.respondToTypeRequest(waitForServer);
        this.waitForServerState(waitForServer);
    }

    private void respondToTypeRequest(long waitForServer) throws JBVersionException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("waiting for server's 'client type request' with timeout: " + String.valueOf(waitForServer));
            }
            InputStream inputStream = this.getInputStream();
            PrintStream outputStream = new PrintStream(this.getOutputStream());
            ConnectionState.respondToTypeRequest(waitForServer, this.getInputStreamReader(), inputStream, outputStream, "ClientType.Exclusive");
        }
        catch (JBVersionException gdve) {
            this.handleState(false);
            throw gdve;
        }
        catch (IOException ioe) {
            log.error(ioe.getLocalizedMessage(), (Throwable)ioe);
            this.handleState(false);
        }
    }

    public synchronized boolean isConnectionEstablished() {
        return this.m_connectionEstablished;
    }

    public synchronized int getState() {
        return this.m_state;
    }

    private void waitForServerState(long waitForServer) throws JBVersionException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("waiting for server ok:" + String.valueOf(waitForServer));
            }
            long waitTime = 0L;
            boolean success = false;
            InputStream inputStream = this.getInputStream();
            BufferedReader inputReader = this.getInputStreamReader();
            while (!success && waitTime <= waitForServer) {
                if (inputStream.available() > 0) {
                    String line = inputReader.readLine();
                    int state = ConnectionState.parseState(line);
                    success = true;
                    this.setState(state);
                    switch (state) {
                        case 0: {
                            this.handleState(true);
                            break;
                        }
                        case 1: {
                            this.handleState(false);
                            break;
                        }
                        case 2: {
                            this.handleState(false);
                            throw new JBVersionException("Version error between Client and AUT Agent!", MessageIDs.E_VERSION_ERROR);
                        }
                        default: {
                            log.error("unknown state received from server: " + line);
                            this.handleState(false);
                            break;
                        }
                    }
                    continue;
                }
                waitTime += TimeUtil.delay((long)500L);
            }
            if (!success) {
                log.debug("no response from server");
                this.setConnectionEstablished(false);
            }
        }
        catch (IOException ioe) {
            log.error(ioe.getLocalizedMessage(), (Throwable)ioe);
            this.handleState(false);
        }
    }

    private void handleState(boolean state) {
        block3: {
            this.setConnectionEstablished(state);
            if (!state) {
                try {
                    this.close();
                }
                catch (IOException ioe) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("IOException raised during closing an unconnected socket", (Throwable)ioe);
                }
            }
        }
    }

    private synchronized void setConnectionEstablished(boolean connected) {
        this.m_connectionEstablished = connected;
    }

    private synchronized void setState(int state) {
        this.m_state = state;
    }

    public BufferedReader getInputStreamReader() throws UnsupportedEncodingException, IOException {
        if (this.m_inputStreamReader == null) {
            this.m_inputStreamReader = new BufferedReader(new InputStreamReader(this.getInputStream(), "UTF8"));
        }
        return this.m_inputStreamReader;
    }
}

