/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the ReflectionComponent component from the concrete toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2019-09-03T07:24:07.224Z")
public interface ReflectionComponent {
    
    
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeMethodStoreReturnValue(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeMethodStoreReturnValue(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeMethod(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeMethod(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator
        ) throws IllegalArgumentException;
        
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeExternalMethodStoreReturnValue(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeExternalMethodStoreReturnValue(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeExternalMethod(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeExternalMethod(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator
        ) throws IllegalArgumentException;
        
} 