/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.finalizer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.inspections.ReferenceQuery;
import org.eclipse.mat.inspections.finalizer.FinalizerThreadQuery;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.model.ThreadToLocalReference;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="finalizer_in_processing")
@Category(value="__hidden__")
@Icon(value="/META-INF/icons/finalizer.gif")
public class FinalizerInProcessingQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;

    public IResult execute(IProgressListener listener) throws Exception {
        int[] finalizerThreadObjects = FinalizerThreadQuery.getFinalizerThreads(this.snapshot);
        SetInt result = new SetInt();
        int[] nArray = finalizerThreadObjects;
        int n = finalizerThreadObjects.length;
        int n2 = 0;
        while (n2 < n) {
            IObject object;
            int i = nArray[n2];
            IObject finalizerThreadObject = this.snapshot.getObject(i);
            IObject[] localVars = FinalizerInProcessingQuery.getLocalVarsForThread(finalizerThreadObject);
            boolean foundFinalizer = false;
            IObject[] iObjectArray = localVars;
            int n3 = localVars.length;
            int n4 = 0;
            while (n4 < n3) {
                object = iObjectArray[n4];
                if ("java.lang.ref.Finalizer".equals(object.getClazz().getName())) {
                    foundFinalizer = true;
                    ObjectReference ref = ReferenceQuery.getReferent((IInstance)object);
                    if (ref != null) {
                        result.add(ref.getObjectId());
                    }
                }
                ++n4;
            }
            if (!foundFinalizer) {
                iObjectArray = localVars;
                n3 = localVars.length;
                n4 = 0;
                while (n4 < n3) {
                    object = iObjectArray[n4];
                    if (object.getObjectId() != i && !object.getClazz().getName().equals("java.lang.ref.ReferenceQueue") && !object.getClazz().getName().equals("java.lang.ref.ReferenceQueue$Lock")) {
                        result.add(object.getObjectId());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return new ObjectListResult.Outbound(this.snapshot, result.toArray());
    }

    private static IObject[] getLocalVarsForThread(IObject thread) throws SnapshotException {
        List<NamedReference> refs = thread.getOutboundReferences();
        ArrayList<IObject> result = new ArrayList<IObject>();
        for (NamedReference ref : refs) {
            if (!(ref instanceof ThreadToLocalReference)) continue;
            result.add(ref.getObject());
        }
        return result.toArray(new IObject[result.size()]);
    }
}

