/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.formatter.core.profiles.CodeFormatterPreferences;
import org.eclipse.php.formatter.ui.FormatterMessages;
import org.eclipse.php.formatter.ui.FormatterUIPlugin;
import org.eclipse.php.formatter.ui.preferences.CodeFormatterPreview;
import org.eclipse.php.formatter.ui.preferences.ModifyDialog;
import org.eclipse.php.formatter.ui.preferences.ModifyDialogTabPage;
import org.eclipse.php.formatter.ui.preferences.PHPPreview;
import org.eclipse.php.internal.ui.util.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class LineWrappingTabPage
extends ModifyDialogTabPage {
    private static final String PREF_CATEGORY_INDEX = "org.eclipse.php.formatter.uiformatter_page.line_wrapping_tab_page.last_category_index";
    private static final String[] INDENT_NAMES = new String[]{FormatterMessages.LineWrappingTabPage_indentation_default, FormatterMessages.LineWrappingTabPage_indentation_on_column, FormatterMessages.LineWrappingTabPage_indentation_by_one};
    private static final String[] WRAPPING_NAMES = new String[]{FormatterMessages.LineWrappingTabPage_splitting_do_not_split, FormatterMessages.LineWrappingTabPage_splitting_wrap_when_necessary, FormatterMessages.LineWrappingTabPage_splitting_always_wrap_first_others_when_necessary, FormatterMessages.LineWrappingTabPage_splitting_wrap_always, FormatterMessages.LineWrappingTabPage_splitting_wrap_always_indent_all_but_first, FormatterMessages.LineWrappingTabPage_splitting_wrap_always_except_first_only_if_necessary};
    private final Category fTypeDeclarationSuperinterfacesCategory = new Category("org.eclipse.php.formatter.core.formatter.alignment_for_superinterfaces_in_type_declaration", "class Example implements I1, I2, I3 {}", FormatterMessages.LineWrappingTabPage_implements_clause);
    private final Category fMethodDeclarationsParametersCategory = new Category("org.eclipse.php.formatter.core.formatter.alignment_for_parameters_in_method_declaration", "class Example {function foo( $a1, $a2, $a3, $a4, $a5, $a6) {}}", FormatterMessages.LineWrappingTabPage_parameters);
    private final Category fMessageSendArgumentsCategory = new Category("org.eclipse.php.formatter.core.formatter.alignment_for_arguments_in_method_invocation", "class Example {function foo() { Other::bar( 100, 200, 300, 400, 500, 600, 700, 800, 900, );}}", FormatterMessages.LineWrappingTabPage_arguments);
    private final Category fAllocationExpressionArgumentsCategory = new Category("org.eclipse.php.formatter.core.formatter.alignment_for_arguments_in_allocation_expression", "class Example {function foo() {return new SomeClass(100, 200, 300, 400, 500, 600, 700, 800, 900, );}}", FormatterMessages.LineWrappingTabPage_object_allocation);
    private final Category fArrayInitializerExpressionsCategory = new Category("org.eclipse.php.formatter.core.formatter.alignment_for_expressions_in_array_initializer", "class Example {var $a = array(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, );}", FormatterMessages.LineWrappingTabPage_array_init);
    private final Category fBinaryExpressionCategory = new Category("org.eclipse.php.formatter.core.formatter.alignment_for_binary_expression", "class Example extends AnotherClass {function foo() {  $txt= 'abc' . 'def' . 'ghi' . 'jkl' . 'mno' . 'pqr' . 'stu' . 'vwx' . 'yz';  $sum= 100 + 200 + 300 + 400 + 500 + 600 + 700 + 800;  $product= 1 * 2 * 3 * 4 * 5 * 6 * 7 * 8 * 9 * 10;  $val = true && false && true && false && true;  return product / sum;}}", FormatterMessages.LineWrappingTabPage_binary_exprs);
    private static final int DEFAULT_PREVIEW_WINDOW_LINE_WIDTH = 40;
    private static final String PREF_PREVIEW_LINE_WIDTH = "org.eclipse.php.formatter.uiformatter_page.line_wrapping_tab_page.preview_line_width";
    private final IDialogSettings fDialogSettings = FormatterUIPlugin.getDefault().getDialogSettings();
    private TreeViewer fCategoriesViewer;
    private Label fWrappingStylePolicy;
    private Combo fWrappingStyleCombo;
    private Label fIndentStylePolicy;
    private Combo fIndentStyleCombo;
    private Button fForceSplit;
    private CodeFormatterPreview fPreview;
    private ModifyDialogTabPage.NumberPreference fMaxLineWidthPref;
    private ModifyDialogTabPage.NumberPreference fDefaultIndentWrapLines;
    private ModifyDialogTabPage.CheckboxPreference fTrailingComma;
    private Group fOptionsGroup;
    private final List<Category> fCategories;
    private final CategoryListener fCategoryListener;
    private IStructuredSelection fSelection;
    private SelectionState fSelectionState;
    private final Map<String, String> fPreviewPreferences;
    private static final String LINE_SPLIT = "org.eclipse.php.formatter.core.formatter.lineSplit";
    private boolean isInitialized;

    public LineWrappingTabPage(ModifyDialog modifyDialog, CodeFormatterPreferences codeFormatterPreferences) {
        super(modifyDialog, codeFormatterPreferences);
        String previewLineWidth = this.fDialogSettings.get(PREF_PREVIEW_LINE_WIDTH);
        this.fPreviewPreferences = new HashMap<String, String>();
        this.fPreviewPreferences.put(LINE_SPLIT, previewLineWidth != null ? previewLineWidth : Integer.toString(40));
        this.fCategories = this.createCategories();
        this.fCategoryListener = new CategoryListener(this.fCategories);
    }

    protected List<Category> createCategories() {
        Category classDeclarations = new Category(FormatterMessages.LineWrappingTabPage_class_decls);
        classDeclarations.children.add(this.fTypeDeclarationSuperinterfacesCategory);
        Category methodDeclarations = new Category(null, null, FormatterMessages.LineWrappingTabPage_method_decls);
        methodDeclarations.children.add(this.fMethodDeclarationsParametersCategory);
        Category functionCalls = new Category(FormatterMessages.LineWrappingTabPage_function_calls);
        functionCalls.children.add(this.fMessageSendArgumentsCategory);
        functionCalls.children.add(this.fAllocationExpressionArgumentsCategory);
        Category expressions = new Category(FormatterMessages.LineWrappingTabPage_expressions);
        expressions.children.add(this.fBinaryExpressionCategory);
        expressions.children.add(this.fArrayInitializerExpressionsCategory);
        ArrayList<Category> root = new ArrayList<Category>();
        root.add(classDeclarations);
        root.add(methodDeclarations);
        root.add(functionCalls);
        root.add(expressions);
        return root;
    }

    @Override
    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group lineWidthGroup = this.createGroup(numColumns, composite, FormatterMessages.LineWrappingTabPage_width_indent);
        this.fMaxLineWidthPref = this.createNumberPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_width_indent_option_max_line_width, 0, 9999);
        this.fMaxLineWidthPref.setValue(this.codeFormatterPreferences.line_wrap_line_split);
        this.fDefaultIndentWrapLines = this.createNumberPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_width_indent_option_default_indent_wrapped, 0, 9999);
        this.fDefaultIndentWrapLines.setValue(this.codeFormatterPreferences.line_wrap_wrapped_lines_indentation);
        this.fTrailingComma = this.createCheckboxPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_keep_trailing_comma_in_list);
        this.fTrailingComma.setIsChecked(this.codeFormatterPreferences.line_keep_trailing_comma_in_list);
        this.fCategoriesViewer = new TreeViewer(composite, 2570);
        this.fCategoriesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((Collection)inputElement).toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return ((Category)parentElement).children.toArray();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return !((Category)element).children.isEmpty();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.fCategoriesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fCategoriesViewer.setInput(this.fCategories);
        this.fCategoriesViewer.setExpandedElements(this.fCategories.toArray());
        GridData gd = LineWrappingTabPage.createGridData(numColumns, 1808, -1);
        this.fCategoriesViewer.getControl().setLayoutData((Object)gd);
        this.fOptionsGroup = this.createGroup(numColumns, composite, "");
        this.fWrappingStylePolicy = LineWrappingTabPage.createLabel(numColumns, (Composite)this.fOptionsGroup, FormatterMessages.LineWrappingTabPage_wrapping_policy_label_text);
        this.fWrappingStyleCombo = new Combo((Composite)this.fOptionsGroup, 12);
        this.fWrappingStyleCombo.setItems(WRAPPING_NAMES);
        this.fWrappingStyleCombo.setLayoutData((Object)LineWrappingTabPage.createGridData(numColumns, 256, 0));
        this.fIndentStylePolicy = LineWrappingTabPage.createLabel(numColumns, (Composite)this.fOptionsGroup, FormatterMessages.LineWrappingTabPage_indentation_policy_label_text);
        this.fIndentStyleCombo = new Combo((Composite)this.fOptionsGroup, 12);
        this.fIndentStyleCombo.setItems(INDENT_NAMES);
        this.fIndentStyleCombo.setLayoutData((Object)LineWrappingTabPage.createGridData(numColumns, 256, 0));
        this.fForceSplit = new Button((Composite)this.fOptionsGroup, 32);
        this.fForceSplit.setLayoutData((Object)LineWrappingTabPage.createGridData(numColumns, 256, 0));
        this.fForceSplit.setText(FormatterMessages.LineWrappingTabPage_force_split_checkbox_text);
        this.fSelectionState = new SelectionState();
        this.isInitialized = true;
    }

    protected void setPreviewText(String text) {
        this.fPreview.setPreviewText(text);
    }

    protected void updateControlEnablement() {
        boolean isLineWrapEnabled = this.fWrappingStyleCombo.getSelectionIndex() != 0;
        this.fIndentStyleCombo.setEnabled(isLineWrapEnabled);
        this.fForceSplit.setEnabled(isLineWrapEnabled);
    }

    @Override
    protected void updatePreferences() {
        if (this.isInitialized) {
            this.codeFormatterPreferences.line_wrap_line_split = this.fMaxLineWidthPref.getValue();
            this.codeFormatterPreferences.line_wrap_wrapped_lines_indentation = this.fDefaultIndentWrapLines.getValue();
            this.codeFormatterPreferences.line_keep_trailing_comma_in_list = this.fTrailingComma.isChecked();
        }
    }

    @Override
    protected PHPPreview doCreatePHPPreview(Composite parent) {
        this.fPreview = new CodeFormatterPreview(this.codeFormatterPreferences, parent);
        return this.fPreview;
    }

    @Override
    protected void doUpdatePreview() {
    }

    @Override
    protected void initializePage() {
        this.fCategoriesViewer.addSelectionChangedListener((ISelectionChangedListener)this.fCategoryListener);
        this.fCategoriesViewer.addDoubleClickListener((IDoubleClickListener)this.fCategoryListener);
        this.fForceSplit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = LineWrappingTabPage.this.fForceSplit.getSelection();
                Iterator iter = LineWrappingTabPage.this.fSelectionState.fElements.iterator();
                Map map = LineWrappingTabPage.this.codeFormatterPreferences.getMap();
                while (iter.hasNext()) {
                    map.put(((Category)iter.next()).getForceSplitKey(), Boolean.toString(isSelected));
                }
                LineWrappingTabPage.this.codeFormatterPreferences.setPreferencesValues(map);
                LineWrappingTabPage.this.notifyValuesModified();
            }
        });
        this.fIndentStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int comboSelection = LineWrappingTabPage.this.fIndentStyleCombo.getSelectionIndex();
                Iterator iter = LineWrappingTabPage.this.fSelectionState.fElements.iterator();
                Map map = LineWrappingTabPage.this.codeFormatterPreferences.getMap();
                while (iter.hasNext()) {
                    map.put(((Category)iter.next()).getIndentPolicyKey(), Integer.toString(comboSelection));
                }
                LineWrappingTabPage.this.codeFormatterPreferences.setPreferencesValues(map);
                LineWrappingTabPage.this.notifyValuesModified();
            }
        });
        this.fWrappingStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineWrappingTabPage.this.updateControlEnablement();
                int comboSelection = LineWrappingTabPage.this.fWrappingStyleCombo.getSelectionIndex();
                Iterator iter = LineWrappingTabPage.this.fSelectionState.fElements.iterator();
                Map map = LineWrappingTabPage.this.codeFormatterPreferences.getMap();
                while (iter.hasNext()) {
                    map.put(((Category)iter.next()).getLineWrappingPolicyKey(), Integer.toString(comboSelection));
                }
                LineWrappingTabPage.this.codeFormatterPreferences.setPreferencesValues(map);
                LineWrappingTabPage.this.notifyValuesModified();
            }
        });
        this.fCategoryListener.restoreSelection();
        this.fDefaultFocusManager.add(this.fCategoriesViewer.getControl());
        this.fDefaultFocusManager.add((Control)this.fWrappingStyleCombo);
        this.fDefaultFocusManager.add((Control)this.fIndentStyleCombo);
        this.fDefaultFocusManager.add((Control)this.fForceSplit);
    }

    @Override
    protected void notifyValuesModified() {
        super.notifyValuesModified();
        if (this.fPreview != null) {
            this.fPreview.update();
        }
    }

    private static final class Category {
        private static final String LINE_WRAP_POLICY_KEY = "_line_wrap_policy";
        private static final String INDENT_POLICY_KEY = "_indent_policy";
        public final String key;
        public final String name;
        public final String previewText;
        public final List<Category> children;
        public int index;

        public Category(String _key, String _previewText, String _name) {
            this.key = _key;
            this.name = _name;
            this.previewText = _previewText != null ? String.valueOf(LineWrappingTabPage.createPreviewHeader(_name)) + _previewText : null;
            this.children = new ArrayList<Category>();
        }

        public Category(String _name) {
            this(null, null, _name);
        }

        public String toString() {
            return this.name;
        }

        public String getLineWrappingPolicyKey() {
            return String.valueOf(this.key) + LINE_WRAP_POLICY_KEY;
        }

        public String getIndentPolicyKey() {
            return String.valueOf(this.key) + INDENT_POLICY_KEY;
        }

        public String getForceSplitKey() {
            return String.valueOf(this.key) + "_force_split";
        }
    }

    private final class CategoryListener
    implements ISelectionChangedListener,
    IDoubleClickListener {
        private final List<Category> fCategoriesList = new ArrayList<Category>();
        private int fIndex = 0;

        public CategoryListener(List<Category> categoriesTree) {
            this.flatten(this.fCategoriesList, categoriesTree);
        }

        private void flatten(List<Category> categoriesList, List<Category> categoriesTree) {
            for (Category category : categoriesTree) {
                ++this.fIndex;
                category.index = category.index;
                categoriesList.add(category);
                this.flatten(categoriesList, category.children);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event != null) {
                LineWrappingTabPage.this.fSelection = (IStructuredSelection)event.getSelection();
            }
            if (LineWrappingTabPage.this.fSelection.size() == 0) {
                this.disableAll();
                return;
            }
            if (!LineWrappingTabPage.this.fOptionsGroup.isEnabled()) {
                this.enableDefaultComponents(true);
            }
            LineWrappingTabPage.this.fSelectionState.refreshState(LineWrappingTabPage.this.fSelection);
            Category category = (Category)LineWrappingTabPage.this.fSelection.getFirstElement();
            LineWrappingTabPage.this.fDialogSettings.put(LineWrappingTabPage.PREF_CATEGORY_INDEX, category.index);
            LineWrappingTabPage.this.fOptionsGroup.setText(this.getGroupLabel(category));
        }

        private String getGroupLabel(Category category) {
            if (LineWrappingTabPage.this.fSelection.size() == 1) {
                if (LineWrappingTabPage.this.fSelectionState.getElements().size() == 1) {
                    return Messages.format((String)FormatterMessages.LineWrappingTabPage_group, (Object)category.name.toLowerCase());
                }
                return Messages.format((String)FormatterMessages.LineWrappingTabPage_multi_group, (Object[])new String[]{category.name.toLowerCase(), Integer.toString(LineWrappingTabPage.this.fSelectionState.getElements().size())});
            }
            return Messages.format((String)FormatterMessages.LineWrappingTabPage_multiple_selections, (Object[])new String[]{Integer.toString(LineWrappingTabPage.this.fSelectionState.getElements().size())});
        }

        private void disableAll() {
            this.enableDefaultComponents(false);
            LineWrappingTabPage.this.fIndentStyleCombo.setEnabled(false);
            LineWrappingTabPage.this.fForceSplit.setEnabled(false);
        }

        private void enableDefaultComponents(boolean enabled) {
            LineWrappingTabPage.this.fOptionsGroup.setEnabled(enabled);
            LineWrappingTabPage.this.fWrappingStyleCombo.setEnabled(enabled);
            LineWrappingTabPage.this.fWrappingStylePolicy.setEnabled(enabled);
        }

        public void restoreSelection() {
            int index;
            try {
                index = LineWrappingTabPage.this.fDialogSettings.getInt(LineWrappingTabPage.PREF_CATEGORY_INDEX);
            }
            catch (NumberFormatException ex) {
                index = -1;
            }
            if (index < 0 || index > this.fCategoriesList.size() - 1) {
                index = 1;
            }
            Category category = this.fCategoriesList.get(index);
            LineWrappingTabPage.this.fCategoriesViewer.setSelection((ISelection)new StructuredSelection((Object[])new Category[]{category}));
        }

        public void doubleClick(DoubleClickEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                Category node = (Category)((IStructuredSelection)selection).getFirstElement();
                LineWrappingTabPage.this.fCategoriesViewer.setExpandedState((Object)node, !LineWrappingTabPage.this.fCategoriesViewer.getExpandedState((Object)node));
            }
        }
    }

    private class SelectionState {
        private List<Category> fElements = new ArrayList<Category>();

        private SelectionState() {
        }

        public void refreshState(IStructuredSelection selection) {
            this.fElements.clear();
            Iterator iterator = selection.iterator();
            this.evaluateElements(iterator);
            LineWrappingTabPage.this.setPreviewText(this.getPreviewText());
            this.refreshControls(this.fElements.get(0));
            LineWrappingTabPage.this.updateControlEnablement();
        }

        public List<Category> getElements() {
            return this.fElements;
        }

        private void evaluateElements(Iterator<Category> iterator) {
            while (iterator.hasNext()) {
                Category category = iterator.next();
                if (category.children.isEmpty()) {
                    if (this.fElements.contains(category)) continue;
                    this.fElements.add(category);
                    continue;
                }
                this.evaluateElements(category.children.iterator());
            }
        }

        private String getPreviewText() {
            Iterator<Category> iterator = this.fElements.iterator();
            String previewText = "<?php\n";
            while (iterator.hasNext()) {
                Category category = iterator.next();
                previewText = String.valueOf(previewText) + category.previewText + "\n\n";
            }
            return String.valueOf(previewText) + "?>";
        }

        private void refreshControls(Category category) {
            this.updateCombos(category);
            this.updateButton(category);
            LineWrappingTabPage.this.doUpdatePreview();
        }

        private void updateButton(Category category) {
            boolean isSelected = Boolean.parseBoolean(LineWrappingTabPage.this.codeFormatterPreferences.getMap().get(category.getForceSplitKey()).toString());
            LineWrappingTabPage.this.fForceSplit.setSelection(isSelected);
        }

        private void updateCombos(Category category) {
            LineWrappingTabPage.this.fWrappingStyleCombo.select(Integer.parseInt((String)LineWrappingTabPage.this.codeFormatterPreferences.getMap().get(category.getLineWrappingPolicyKey())));
            LineWrappingTabPage.this.fIndentStyleCombo.select(Integer.parseInt((String)LineWrappingTabPage.this.codeFormatterPreferences.getMap().get(category.getIndentPolicyKey())));
        }
    }
}

