/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ptp.internal.debug.ui.IPTPDebugUIConstants;
import org.eclipse.ptp.internal.debug.ui.actions.AbstractBreakpointRulerAction;
import org.eclipse.ptp.internal.debug.ui.messages.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class EnableDisableBreakpointRulerAction
extends AbstractBreakpointRulerAction {
    public EnableDisableBreakpointRulerAction(IWorkbenchPart part, IVerticalRulerInfo info) {
        this.setInfo(info);
        this.setTargetPart(part);
        this.setText(Messages.EnableDisableBreakpointRulerAction_Enable_Breakpoint_1);
        this.setId(IPTPDebugUIConstants.ACTION_ENABLE_DISABLE_BREAKPOINT);
    }

    public void run() {
        if (this.getBreakpoint() != null) {
            try {
                this.getBreakpoint().setEnabled(!this.getBreakpoint().isEnabled());
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getTargetPart().getSite().getShell(), (String)Messages.EnableDisableBreakpointRulerAction_Enabling_disabling_breakpoints_1, (String)Messages.EnableDisableBreakpointRulerAction_Exceptions_occurred_enabling_or_disabling_breakpoint_1, (IStatus)e.getStatus());
            }
        }
    }

    public void update() {
        this.setBreakpoint(this.determineBreakpoint());
        if (this.getBreakpoint() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        try {
            boolean enabled = this.getBreakpoint().isEnabled();
            this.setText(enabled ? Messages.EnableDisableBreakpointRulerAction_Disable_Breakpoint_1 : Messages.EnableDisableBreakpointRulerAction_Enable_Breakpoint_1);
        }
        catch (CoreException e) {
            DebugPlugin.log((Throwable)e);
        }
    }
}

