/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class CTableCellRenderer {
    public static CTableCellRenderer defaultRenderer = new CTableCellRenderer();
    protected Display m_Display = null;
    protected Map<String, Point> stringExtentCache = new HashMap<String, Point>();

    public CTableCellRenderer() {
        this.m_Display = Display.getCurrent();
    }

    public void dispose() {
        this.stringExtentCache.clear();
    }

    private Point getStringExtentCache(GC gc, String text) {
        Point pt = this.stringExtentCache.get(text);
        if (pt == null) {
            pt = gc.stringExtent(text);
            this.stringExtentCache.put(text, pt);
        }
        return pt;
    }

    public int getOptimalWidth(GC gc, int col, int row, Object content, boolean fixed) {
        return gc.stringExtent((String)content.toString()).x + 8;
    }

    public void drawCell(GC gc, Rectangle rect, int col, int row, Object content, boolean focus, boolean fixed, boolean clicked) {
        String text = content.toString();
        if (fixed) {
            if (col == 0 && row == 0) {
                text = "";
            }
            ++rect.height;
            ++rect.width;
            gc.setForeground(this.m_Display.getSystemColor(24));
            if (clicked) {
                this.drawText(gc, text, rect.x, rect.y, rect.width, rect.height, 1, 1, this.m_Display.getSystemColor(22), this.m_Display.getSystemColor(20));
            } else {
                this.drawText(gc, text, rect.x, rect.y, rect.width, rect.height, 1, 1, this.m_Display.getSystemColor(22), this.m_Display.getSystemColor(18));
            }
        } else {
            Color hBorderColor;
            Color vBorderColor;
            Color backColor;
            Color textColor;
            if (focus) {
                textColor = this.m_Display.getSystemColor(27);
                backColor = this.m_Display.getSystemColor(26);
                vBorderColor = this.m_Display.getSystemColor(26);
                hBorderColor = this.m_Display.getSystemColor(26);
            } else {
                textColor = this.m_Display.getSystemColor(24);
                backColor = this.m_Display.getSystemColor(25);
                vBorderColor = this.m_Display.getSystemColor(22);
                hBorderColor = this.m_Display.getSystemColor(22);
            }
            gc.setForeground(hBorderColor);
            gc.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
            gc.setForeground(vBorderColor);
            gc.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
            gc.setBackground(backColor);
            gc.setForeground(textColor);
            gc.fillRectangle(rect);
            this.drawText(gc, text, rect.x + 3, rect.y, rect.width - 3, rect.height, 0, 0);
        }
    }

    private void drawText(GC gc, String text, int x, int y, int w, int h, int leftMargin, int topMargin, Color face, Color shadow) {
        Color prevForeground = gc.getForeground();
        Color prevBackground = gc.getBackground();
        try {
            gc.setBackground(face);
            gc.setForeground(shadow);
            gc.drawRectangle(x - 1, y - 1, w, h);
            gc.setForeground(prevForeground);
            this.drawText(gc, text, x, y, w, h, leftMargin, topMargin);
        }
        finally {
            gc.setForeground(prevForeground);
            gc.setBackground(prevBackground);
        }
    }

    private void drawText(GC gc, String text, int x, int y, int w, int h, int leftMargin, int topMargin) {
        Point pt = this.getStringExtentCache(gc, text);
        if (pt.x > w - leftMargin) {
            text = "...";
            pt = this.getStringExtentCache(gc, text);
        }
        gc.drawText(text, x + (w - pt.x) / 2 + leftMargin, y + (h - pt.y) / 2 + topMargin);
    }
}

