/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.scanner;

import org.eclipse.rcptt.core.ecl.scanner.EclCharClasses;
import org.eclipse.rcptt.core.ecl.scanner.EclToken;

public class EclScanner {
    private final String source;
    private int p = 0;
    private final char EOF = (char)65535;
    private boolean allowEmptyVar = false;
    private boolean allowEmptyOption = false;
    private char c0;
    private StringBuilder valueBuilder = new StringBuilder();
    private EclToken.Type type;
    private Object value;
    private String message;

    public EclScanner(String source) {
        this(source, false, false);
    }

    public EclScanner(String source, boolean allowEmptyVar, boolean allowEmptyOption) {
        this.source = source;
        this.allowEmptyVar = allowEmptyVar;
        this.allowEmptyOption = allowEmptyOption;
    }

    public EclToken next() {
        this.type = EclToken.Type.Invalid;
        this.value = null;
        this.message = null;
        this.valueBuilder.setLength(0);
        int start = this.p;
        this.peek();
        switch (this.c0) {
            case '\uffff': {
                this.eof();
                break;
            }
            case '\t': 
            case ' ': {
                this.spacing();
                break;
            }
            case '\n': 
            case '\r': {
                this.linebreak();
                break;
            }
            case '/': {
                this.comment();
                break;
            }
            case '|': {
                this.single(EclToken.Type.Pipe);
                break;
            }
            case ';': {
                this.single(EclToken.Type.Semicolon);
                break;
            }
            case '+': {
                this.single(EclToken.Type.Plus);
                break;
            }
            case '[': {
                this.single(EclToken.Type.SquareOpen);
                break;
            }
            case ']': {
                this.single(EclToken.Type.SquareClose);
                break;
            }
            case '{': {
                this.single(EclToken.Type.CurlyOpen);
                break;
            }
            case '}': {
                this.single(EclToken.Type.CurlyClose);
                break;
            }
            case '\"': {
                this.string();
                break;
            }
            case '-': {
                this.option();
                break;
            }
            case '$': {
                this.variable();
                break;
            }
            default: {
                if (EclCharClasses.isDigit(this.c0)) {
                    this.number();
                    break;
                }
                if (EclCharClasses.isIdentifierStart(this.c0)) {
                    this.identifier();
                    break;
                }
                this.eat();
            }
        }
        EclToken token = new EclToken();
        token.type = this.message == null ? this.type : EclToken.Type.Invalid;
        token.begin = start;
        token.end = this.p;
        token.text = this.type != EclToken.Type.Eof ? this.source.substring(start, this.p) : null;
        token.value = this.value;
        token.message = this.message;
        return token;
    }

    private void eof() {
        this.type = EclToken.Type.Eof;
        this.eat();
    }

    private void single(EclToken.Type type) {
        this.type = type;
        this.eat();
    }

    private void spacing() {
        this.type = EclToken.Type.Spacing;
        do {
            this.eat();
        } while (this.c0 == ' ' || this.c0 == '\t');
    }

    private void linebreak() {
        this.type = EclToken.Type.Linebreak;
        if (this.c0 == '\n') {
            this.eat();
            if (this.c0 == '\r') {
                this.eat();
            }
        } else if (this.c0 == '\r') {
            this.eat();
            if (this.c0 == '\n') {
                this.eat();
            }
        }
    }

    private void comment() {
        this.eat();
        if (this.c0 == '/') {
            this.slComment();
        } else if (this.c0 == '*') {
            this.mlComment();
        }
    }

    private void slComment() {
        this.type = EclToken.Type.SlComment;
        this.eat();
        while (this.c0 != '\n' && this.c0 != '\r' && this.c0 != '\uffff') {
            this.valueBuilder.append(this.eat());
        }
        this.value = this.valueBuilder.toString();
    }

    private void mlComment() {
        this.type = EclToken.Type.MlComment;
        this.eat();
        boolean skipNextAsterisk = true;
        while (true) {
            if (this.c0 == '\uffff') {
                this.message = "Unterminated multiline comment.";
                return;
            }
            if (this.c0 == '*') {
                this.eat();
                if (this.c0 == '/') break;
                if (skipNextAsterisk) {
                    skipNextAsterisk = false;
                    continue;
                }
                this.valueBuilder.append('*');
                continue;
            }
            if (this.c0 == '\n' || this.c0 == '\r') {
                skipNextAsterisk = true;
            } else if (this.c0 != ' ' && this.c0 != '\t' && skipNextAsterisk) {
                skipNextAsterisk = false;
            }
            this.valueBuilder.append(this.eat());
        }
        this.eat();
        this.value = this.valueBuilder.toString();
    }

    private void number() {
        this.type = EclToken.Type.Number;
        do {
            this.valueBuilder.append(this.eat());
        } while (EclCharClasses.isDigit(this.c0));
        String v = this.valueBuilder.toString();
        try {
            long l = Long.parseLong(v);
            this.value = l;
        }
        catch (NumberFormatException numberFormatException) {
            this.value = v;
        }
    }

    private void string() {
        this.type = EclToken.Type.String;
        char openQuote = this.eat();
        while (true) {
            if (this.c0 == '\uffff') {
                this.message = "Unterminated string literal.";
                return;
            }
            if (this.c0 == '\\') {
                this.eat();
                if (this.c0 == '\uffff') {
                    this.message = "Unterminated string literal.";
                    return;
                }
                switch (this.c0) {
                    case 'b': {
                        this.valueBuilder.append('\b');
                        break;
                    }
                    case 't': {
                        this.valueBuilder.append('\t');
                        break;
                    }
                    case 'n': {
                        this.valueBuilder.append('\n');
                        break;
                    }
                    case 'f': {
                        this.valueBuilder.append('\f');
                        break;
                    }
                    case 'r': {
                        this.valueBuilder.append('\r');
                        break;
                    }
                    case '\"': {
                        this.valueBuilder.append('\"');
                        break;
                    }
                    case '\'': {
                        this.valueBuilder.append('\'');
                        break;
                    }
                    case '\\': {
                        this.valueBuilder.append('\\');
                        break;
                    }
                    default: {
                        this.message = "Unknown string literal escape sequence.";
                    }
                }
                this.eat();
                continue;
            }
            if (this.c0 == openQuote) break;
            this.valueBuilder.append(this.eat());
        }
        this.eat();
        this.value = this.valueBuilder.toString();
    }

    private void identifier() {
        this.type = EclToken.Type.Identifier;
        this.scanIdentifier();
        this.value = this.valueBuilder.toString();
    }

    private void option() {
        this.type = EclToken.Type.Option;
        this.eat();
        if (this.c0 == '-') {
            this.eat();
        }
        if (this.scanIdentifier()) {
            this.value = this.valueBuilder.toString();
        } else if (this.allowEmptyOption) {
            this.value = "";
        } else {
            this.message = "Invalid option name.";
        }
    }

    private void variable() {
        this.type = EclToken.Type.Variable;
        this.eat();
        if (this.scanIdentifier()) {
            this.value = this.valueBuilder.toString();
        } else if (this.allowEmptyVar) {
            this.value = "";
        } else {
            this.message = "Invalid variable name.";
        }
    }

    private boolean scanIdentifier() {
        if (!EclCharClasses.isIdentifierStart(this.c0)) {
            return false;
        }
        do {
            this.valueBuilder.append(this.eat());
        } while (EclCharClasses.isIdentifier(this.c0));
        return true;
    }

    private void peek() {
        this.c0 = (char)(this.p < this.source.length() ? (int)this.source.charAt(this.p) : 65535);
    }

    private char eat() {
        char c1 = this.c0;
        ++this.p;
        this.peek();
        return c1;
    }
}

