/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow;

import java.util.Collections;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.ui.views.FormatTimeUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ControlFlowEntry
extends TimeGraphEntry {
    private long fSchedulingPosition = Long.MAX_VALUE;

    public ControlFlowEntry(int quark, @NonNull String execName, int threadId, int parentThreadId, long startTime, long endTime) {
        this(new ThreadEntryModel((long)quark, -1L, Collections.singletonList(execName), startTime, endTime, threadId, parentThreadId));
    }

    public ControlFlowEntry(@NonNull ThreadEntryModel model) {
        super((TimeGraphEntryModel)model);
    }

    public int getThreadId() {
        return ((ThreadEntryModel)this.getEntryModel()).getThreadId();
    }

    public int getParentThreadId() {
        return ((ThreadEntryModel)this.getEntryModel()).getParentThreadId();
    }

    public boolean matches(@NonNull Pattern pattern) {
        if (pattern.matcher(this.getName()).find()) {
            return true;
        }
        if (pattern.matcher(Integer.toString(this.getThreadId())).find()) {
            return true;
        }
        if (pattern.matcher(Integer.toString(this.getParentThreadId())).find()) {
            return true;
        }
        return pattern.matcher(FormatTimeUtils.formatTime((long)this.getStartTime(), (FormatTimeUtils.TimeFormat)FormatTimeUtils.TimeFormat.CALENDAR, (FormatTimeUtils.Resolution)FormatTimeUtils.Resolution.NANOSEC)).find();
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + '(' + this.getName() + '[' + this.getThreadId() + "])";
    }

    public long getSchedulingPosition() {
        return this.fSchedulingPosition;
    }

    public void setSchedulingPosition(long schedulingPosition) {
        this.fSchedulingPosition = schedulingPosition;
    }
}

