/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlPatternCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternSegmentStoreModule;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternStateSystemModule;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.segment.TmfXmlPatternSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class XmlPatternAnalysis
extends TmfAbstractAnalysisModule
implements ITmfAnalysisModuleWithStateSystems,
ISegmentStoreProvider {
    public static final @NonNull String SEGMENT_STORE_EXTENSION = ".dat";
    private static final @NonNull String STATE_SYSTEM_EXTENSION = ".ht";
    private static final String SEGMENT_STORE_SUFFIX = " segment store";
    private static final String STATE_SYSTEM_SUFFIX = " state system";
    private final CountDownLatch fInitialized = new CountDownLatch(1);
    private final XmlPatternStateSystemModule fStateSystemModule;
    private final XmlPatternSegmentStoreModule fSegmentStoreModule = new XmlPatternSegmentStoreModule(this);
    private boolean fInitializationSucceeded;
    private String fViewLabelPrefix;

    public XmlPatternAnalysis(@NonNull String analysisid, TmfXmlPatternCu patternCu) {
        this.fStateSystemModule = new XmlPatternStateSystemModule(this.fSegmentStoreModule, patternCu);
        this.setId(analysisid);
    }

    public Map<@NonNull String, @NonNull Integer> getProviderVersions() {
        return this.fStateSystemModule.getProviderVersions();
    }

    public @Nullable ISegmentStore<@NonNull ISegment> getSegmentStore() {
        return this.fSegmentStoreModule.getSegmentStore();
    }

    public @Nullable ITmfStateSystem getStateSystem(@NonNull String id) {
        return this.fStateSystemModule.getStateSystem(id);
    }

    public @NonNull Iterable<@NonNull ITmfStateSystem> getStateSystems() {
        return this.fStateSystemModule.getStateSystems();
    }

    public void setViewLabelPrefix(String viewLabelPrefix) {
        this.fViewLabelPrefix = viewLabelPrefix;
    }

    public String getViewLabelPrefix() {
        return this.fViewLabelPrefix;
    }

    public boolean waitForInitialization() {
        try {
            this.fInitialized.await();
        }
        catch (InterruptedException e) {
            return false;
        }
        return this.fInitializationSucceeded;
    }

    protected boolean executeAnalysis(@NonNull IProgressMonitor monitor) throws TmfAnalysisException {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            this.analysisReady(false);
            return false;
        }
        File segmentStoreFile = this.getSupplementaryFile(this.getSegmentStoreFileName());
        File stateSystemFile = this.getSupplementaryFile(this.getStateSystemFileName());
        if (segmentStoreFile == null || stateSystemFile == null) {
            this.analysisReady(false);
            return false;
        }
        if (!segmentStoreFile.exists()) {
            this.fStateSystemModule.cancel();
            stateSystemFile.delete();
        }
        IStatus segmentStoreStatus = this.fSegmentStoreModule.schedule();
        IStatus stateSystemStatus = this.fStateSystemModule.schedule();
        if (!segmentStoreStatus.isOK() || !stateSystemStatus.isOK()) {
            this.cancelSubAnalyses();
            this.analysisReady(false);
            return false;
        }
        if (!this.fStateSystemModule.waitForInitialization()) {
            this.analysisReady(false);
            this.cancelSubAnalyses();
            return false;
        }
        ITmfStateSystem stateSystem = this.fStateSystemModule.getStateSystem();
        if (stateSystem == null) {
            this.analysisReady(false);
            throw new IllegalStateException("Initialization of the state system module succeeded but the statesystem is null");
        }
        this.analysisReady(true);
        return this.fStateSystemModule.waitForCompletion(monitor) && this.fSegmentStoreModule.waitForCompletion(monitor);
    }

    protected void canceling() {
        this.cancelSubAnalyses();
    }

    private void cancelSubAnalyses() {
        this.fStateSystemModule.cancel();
        this.fSegmentStoreModule.cancel();
    }

    public void dispose() {
        super.dispose();
        this.fStateSystemModule.dispose();
        this.fSegmentStoreModule.dispose();
    }

    public void setId(@NonNull String id) {
        super.setId(id);
        this.fStateSystemModule.setId(id);
        this.fSegmentStoreModule.setId(id);
    }

    public void setName(@NonNull String name) {
        super.setName(name);
        this.fStateSystemModule.setName(String.valueOf(name) + STATE_SYSTEM_SUFFIX);
        this.fSegmentStoreModule.setName(String.valueOf(name) + SEGMENT_STORE_SUFFIX);
    }

    public boolean setTrace(ITmfTrace trace) throws TmfAnalysisException {
        if (!super.setTrace(trace)) {
            return false;
        }
        return this.fSegmentStoreModule.setTrace(trace) && this.fStateSystemModule.setTrace(trace);
    }

    private void analysisReady(boolean succeeded) {
        this.fInitializationSucceeded = succeeded;
        this.fInitialized.countDown();
    }

    private @Nullable File getSupplementaryFile(String filename) {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return null;
        }
        String directory = TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace);
        File file = new File(String.valueOf(directory) + filename);
        return file;
    }

    private String getStateSystemFileName() {
        return String.valueOf(this.fStateSystemModule.getId()) + STATE_SYSTEM_EXTENSION;
    }

    private String getSegmentStoreFileName() {
        return String.valueOf(this.fSegmentStoreModule.getId()) + SEGMENT_STORE_EXTENSION;
    }

    public void addListener(@NonNull IAnalysisProgressListener listener) {
        this.fSegmentStoreModule.addListener(listener);
    }

    public void removeListener(@NonNull IAnalysisProgressListener listener) {
        this.fSegmentStoreModule.removeListener(listener);
    }

    public Iterable<ISegmentAspect> getSegmentAspects() {
        return ImmutableList.of((Object)PatternSegmentNameAspect.INSTANCE, (Object)PatternSegmentContentAspect.INSTANCE);
    }

    public boolean waitForCompletion() {
        return super.waitForCompletion() && this.fStateSystemModule.waitForCompletion() && this.fSegmentStoreModule.waitForCompletion();
    }

    public boolean waitForCompletion(@NonNull IProgressMonitor monitor) {
        return super.waitForCompletion(monitor) && this.fStateSystemModule.waitForCompletion(monitor) && this.fSegmentStoreModule.waitForCompletion(monitor);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Map<@NonNull String, @NonNull String> getProperties() {
        @NonNull @NonNull Map properties = super.getProperties();
        Object module = this.fStateSystemModule;
        if (module != null) {
            for (Map.Entry entry : module.getProperties().entrySet()) {
                properties.put(Objects.requireNonNull(String.valueOf(Messages.PatternAnalysis_StateSystemPrefix) + ' ' + (String)entry.getKey()), (String)entry.getValue());
            }
        }
        if ((module = this.fSegmentStoreModule) != null) {
            for (Map.Entry entry : module.getProperties().entrySet()) {
                properties.put(Objects.requireNonNull(String.valueOf(Messages.PatternAnalysis_SegmentStorePrefix) + ' ' + (String)entry.getKey()), (String)entry.getValue());
            }
        }
        return properties;
    }

    private static class PatternSegmentContentAspect
    implements ISegmentAspect {
        public static final @NonNull ISegmentAspect INSTANCE = new PatternSegmentContentAspect();

        private PatternSegmentContentAspect() {
        }

        public String getHelpText() {
            return (String)NonNullUtils.checkNotNull((Object)Messages.PatternSegmentContentAspect_HelpText);
        }

        public String getName() {
            return (String)NonNullUtils.checkNotNull((Object)Messages.PatternSegmentContentAspect_Content);
        }

        public @Nullable Comparator<?> getComparator() {
            return null;
        }

        public @Nullable String resolve(ISegment segment) {
            if (segment instanceof TmfXmlPatternSegment) {
                return ((TmfXmlPatternSegment)segment).getContent().entrySet().stream().map(c -> String.valueOf((String)c.getKey()) + '=' + c.getValue()).collect(Collectors.joining(", "));
            }
            return "";
        }
    }

    private static class PatternSegmentNameAspect
    implements ISegmentAspect {
        public static final @NonNull ISegmentAspect INSTANCE = new PatternSegmentNameAspect();

        private PatternSegmentNameAspect() {
        }

        public String getHelpText() {
            return (String)NonNullUtils.checkNotNull((Object)Messages.PatternSegmentNameAspect_HelpText);
        }

        public String getName() {
            return (String)NonNullUtils.checkNotNull((Object)Messages.PatternSegmentNameAspect_Name);
        }

        public @Nullable Comparator<?> getComparator() {
            return null;
        }

        public @Nullable String resolve(ISegment segment) {
            if (segment instanceof TmfXmlPatternSegment) {
                return ((TmfXmlPatternSegment)segment).getName();
            }
            return "";
        }
    }
}

