/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.facets;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarVersionChangeListener
implements IFacetedProjectListener {
    private static final Logger LOG = LoggerFactory.getLogger(EarVersionChangeListener.class);

    public void handleEvent(IFacetedProjectEvent event) {
        if (event.getType().equals((Object)IFacetedProjectEvent.Type.POST_VERSION_CHANGE)) {
            IProject project = ((IProjectFacetActionEvent)event).getProject().getProject();
            try {
                if (project.hasNature("org.eclipse.m2e.core.maven2Nature") && ((IProjectFacetActionEvent)event).getProjectFacet().getId().equals("jst.ear")) {
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    Object cfg = ((IProjectFacetActionEvent)event).getActionConfig();
                    if (cfg == null) {
                        return;
                    }
                    IDataModel model = (IDataModel)cfg;
                    if (model.isProperty("IEarFacetInstallDataModelProperties.CONTENT_DIR")) {
                        Path earContent = new Path("/" + model.getStringProperty("IEarFacetInstallDataModelProperties.CONTENT_DIR"));
                        IVirtualComponent c = ComponentCore.createComponent((IProject)project, (boolean)true);
                        if (c != null) {
                            IVirtualFolder earroot = c.getRootFolder();
                            if (!WTPProjectsUtil.hasLink(project, (IPath)new Path("/"), (IPath)earContent, (IProgressMonitor)monitor)) {
                                earroot.createLink((IPath)earContent, 0, null);
                            }
                            WTPProjectsUtil.setDefaultDeploymentDescriptorFolder(earroot, (IPath)earContent, (IProgressMonitor)monitor);
                        }
                        try {
                            ((IDataModelOperation)model.getProperty("FacetDataModelProvider.NOTIFICATION_OPERATION")).execute((IProgressMonitor)monitor, null);
                        }
                        catch (ExecutionException e) {
                            LOG.error(Messages.EarVersionChangeListener_Error_Notifying_EAR_Version_Change, (Throwable)e);
                        }
                    }
                }
            }
            catch (CoreException e) {
                LOG.error(Messages.VersionChangeListener_Unreadeable_Project_Nature, (Throwable)e);
            }
        }
    }
}

