/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.sourceform;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.sourceform.ISourceForm;
import org.eclipse.photran.internal.core.sourceform.SourceFormProperties;

public final class SourceForm {
    private static final String SOURCE_FORM_EXTENSION_POINT_ID = "org.eclipse.photran.core.sourceForms";
    private static ISourceForm fallbackNullSourceForm = new ISourceForm(){

        @Override
        public boolean isFixedForm() {
            return false;
        }

        @Override
        public boolean isCPreprocessed() {
            return false;
        }

        @Override
        public <T> T createLexer(Reader in, IFile file, String filename, boolean accumulateWhitetext) throws IOException {
            return null;
        }

        @Override
        public ISourceForm configuredWith(Object data) {
            return this;
        }
    };

    private SourceForm() {
    }

    public static ISourceForm of(IFile file, String filename) {
        if (file != null) {
            return SourceForm.of(file);
        }
        return SourceForm.of(filename, null);
    }

    public static ISourceForm of(IFile file) {
        return SourceForm.of(SourceForm.determineFilename(file), SourceForm.propertiesFor(file));
    }

    public static ISourceForm of(String filename) {
        return SourceForm.of(filename, null);
    }

    public static String descriptionFor(IFile file) {
        return SourceForm.descriptionFor(SourceForm.determineFilename(file), SourceForm.propertiesFor(file));
    }

    private static SourceFormProperties propertiesFor(IFile file) {
        if (file == null || file.getProject() == null) {
            return null;
        }
        return new SourceFormProperties(file.getProject());
    }

    public static String determineFilename(IFile file) {
        if (file == null) {
            return null;
        }
        IPath location = file.getLocation();
        if (location != null) {
            return location.toOSString();
        }
        return file.getFullPath().toOSString();
    }

    public static String descriptionForContentType(String spec) {
        return SourceForm.descriptionFor(spec, null);
    }

    private static ISourceForm of(String filename, SourceFormProperties properties) {
        if (filename == null) {
            return SourceForm.defaultSourceForm();
        }
        try {
            IConfigurationElement config = SourceForm.findExtensionHandling(filename, properties);
            if (config != null) {
                return (ISourceForm)config.createExecutableExtension("class");
            }
            return SourceForm.defaultSourceForm();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ISourceForm defaultSourceForm() {
        try {
            IConfigurationElement config = SourceForm.findDefaultSourceFormExtension();
            if (config != null) {
                return (ISourceForm)config.createExecutableExtension("class");
            }
            return fallbackNullSourceForm;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return fallbackNullSourceForm;
        }
    }

    private static IConfigurationElement findDefaultSourceFormExtension() {
        IConfigurationElement[] iConfigurationElementArray = SourceForm.allSourceFormConfigs();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            if (SourceForm.isDefaultHandler(config)) {
                return config;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isDefaultHandler(IConfigurationElement config) {
        return config.getAttribute("priority").equals("default");
    }

    public static String descriptionFor(String filename) {
        return SourceForm.descriptionFor(filename, null);
    }

    private static String descriptionFor(String filename, SourceFormProperties properties) {
        IConfigurationElement config = SourceForm.findExtensionHandling(filename, properties);
        if (config != null) {
            return SourceForm.nameOf(config);
        }
        return SourceForm.nameOf(SourceForm.findDefaultSourceFormExtension());
    }

    private static IConfigurationElement findExtensionHandling(String filename, SourceFormProperties properties) {
        IConfigurationElement config;
        if (filename == null) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = SourceForm.allSourceFormConfigs();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            config = iConfigurationElementArray[n2];
            if (SourceForm.isHighPriorityHandler(config, filename, properties)) {
                return config;
            }
            ++n2;
        }
        iConfigurationElementArray = SourceForm.allSourceFormConfigs();
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            config = iConfigurationElementArray[n2];
            if (SourceForm.isMediumPriorityHandler(config, filename, properties)) {
                return config;
            }
            ++n2;
        }
        iConfigurationElementArray = SourceForm.allSourceFormConfigs();
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            config = iConfigurationElementArray[n2];
            if (SourceForm.canHandle(config, filename, properties)) {
                return config;
            }
            ++n2;
        }
        return null;
    }

    private static IConfigurationElement[] allSourceFormConfigs() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(SOURCE_FORM_EXTENSION_POINT_ID);
    }

    private static String nameOf(IConfigurationElement config) {
        if (config != null) {
            return config.getAttribute("name");
        }
        return null;
    }

    public static Set<String> allSourceForms() {
        TreeSet<String> result = new TreeSet<String>();
        IConfigurationElement[] iConfigurationElementArray = SourceForm.allSourceFormConfigs();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            result.add(SourceForm.nameOf(config));
            ++n2;
        }
        return result;
    }

    public static List<String> allConfiguredContentTypeAssociations() {
        String spec;
        ArrayList<String> result = new ArrayList<String>(32);
        String[] stringArray = FortranCorePlugin.fortranContentType().getFileSpecs(8);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            spec = stringArray[n2];
            result.add("*." + spec.toLowerCase());
            ++n2;
        }
        stringArray = FortranCorePlugin.fortranContentType().getFileSpecs(8);
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            spec = stringArray[n2];
            result.add("*." + spec.toUpperCase());
            ++n2;
        }
        stringArray = FortranCorePlugin.fortranContentType().getFileSpecs(4);
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            spec = stringArray[n2];
            result.add(spec);
            ++n2;
        }
        return result;
    }

    private static boolean isHighPriorityHandler(IConfigurationElement config, String filename, SourceFormProperties properties) {
        return SourceForm.isHighPriorityHandler(config) && SourceForm.canHandle(config, filename, properties);
    }

    private static boolean isHighPriorityHandler(IConfigurationElement config) {
        return config.getAttribute("priority").equals("high");
    }

    private static boolean isMediumPriorityHandler(IConfigurationElement config, String filename, SourceFormProperties properties) {
        return SourceForm.isMediumPriorityHandler(config) && SourceForm.canHandle(config, filename, properties);
    }

    private static boolean isMediumPriorityHandler(IConfigurationElement config) {
        return config.getAttribute("priority").equals("medium");
    }

    private static boolean canHandle(IConfigurationElement config, String filename, SourceFormProperties properties) {
        if (properties != null) {
            String extension = SourceForm.filenameExtensionOf(filename);
            String filenameWithoutPath = SourceForm.filenameWithoutPath(filename);
            return properties.sourceFormForExtension(extension).equals(SourceForm.nameOf(config)) || properties.sourceFormForFilename(filenameWithoutPath).equals(SourceForm.nameOf(config));
        }
        String exts = config.getAttribute("defaultForFilenameExtensions");
        if (exts == null) {
            return false;
        }
        return Arrays.asList(exts.split(",[ \t]*")).contains(SourceForm.filenameExtensionOf(filename));
    }

    private static String filenameExtensionOf(String filename) {
        return filename.substring(filename.lastIndexOf(46) + 1);
    }

    private static String filenameWithoutPath(String filename) {
        return filename.substring(filename.lastIndexOf(File.separatorChar) + 1);
    }

    public static boolean isFixedForm(IFile file) {
        return SourceForm.of(file).isFixedForm();
    }

    public static boolean isFixedForm(String filename) {
        return SourceForm.of(filename).isFixedForm();
    }

    public static boolean isCPreprocessed(IFile file) {
        return SourceForm.of(file).isCPreprocessed();
    }

    public static boolean isCPreprocessed(String filename) {
        return SourceForm.of(filename).isCPreprocessed();
    }
}

