/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.ui.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.internal.ui.messages.Messages;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIFileService;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RemoteFileWidget
extends Composite {
    public static int GROUP_FLAG = 1;
    public static int RESTORE_BUTTON_FLAG = 2;
    private final Label fLabel;
    private final Text fText;
    private final Button fBrowseButton;
    private Button fDefaultButton;
    private String fDefaultPath;
    private String fBrowseMessage = Messages.RemoteFileWidget_Select_File;
    private IRemoteConnection fRemoteConnection;
    private final ListenerList fModifyListeners = new ListenerList();
    private final Map<String, String> fPreviousSelections = new HashMap<String, String>();

    public RemoteFileWidget(Composite parent, int style, int flags, String title, String defaultPath) {
        super(parent, style);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        RemoteFileWidget body = this;
        if ((flags & GROUP_FLAG) != 0) {
            Group group = new Group((Composite)this, 0);
            group.setText(title);
            group.setLayout((Layout)new GridLayout(1, false));
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            body = group;
        }
        this.fLabel = new Label((Composite)body, 0);
        this.fLabel.setText(Messages.RemoteFileWidget_File);
        this.fLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fText = new Text((Composite)body, 2048);
        this.fText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String path = RemoteFileWidget.this.fText.getText();
                RemoteFileWidget.this.setSavedPath(path);
                RemoteFileWidget.this.notifyListeners(e);
            }
        });
        this.fBrowseButton = new Button((Composite)body, 0);
        this.fBrowseButton.setText(Messages.RemoteFileWidget_Browse);
        GridData browseButtonData = new GridData(16384, 0x1000000, false, false);
        browseButtonData.widthHint = 110;
        this.fBrowseButton.setLayoutData((Object)browseButtonData);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteFileWidget.this.browse();
            }
        });
        if ((flags & RESTORE_BUTTON_FLAG) != 0) {
            this.fDefaultButton = new Button((Composite)body, 0);
            this.fDefaultButton.setText(Messages.RemoteFileWidget_Restore_Default);
            GridData defaultButtonData = new GridData(16384, 0x1000000, false, false);
            defaultButtonData.widthHint = 110;
            this.fDefaultButton.setLayoutData((Object)defaultButtonData);
            this.fDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RemoteFileWidget.this.restoreDefault(RemoteFileWidget.this.fDefaultPath);
                }
            });
        }
        if (defaultPath != null) {
            this.fDefaultPath = defaultPath;
            this.fText.setText(defaultPath);
        }
        this.updateBrowseButton();
    }

    public void addModifyListener(ModifyListener listener) {
        this.fModifyListeners.add((Object)listener);
    }

    private void browse() {
        IRemoteUIFileService fileMgr;
        IRemoteUIConnectionService connMgr = this.getUIConnectionManager();
        if (connMgr != null) {
            connMgr.openConnectionWithProgress(this.getShell(), null, this.fRemoteConnection);
        }
        if (this.fRemoteConnection.isOpen() && (fileMgr = this.getUIFileManager()) != null) {
            fileMgr.setConnection(this.fRemoteConnection);
            String path = fileMgr.browseFile(this.getShell(), this.fBrowseMessage, "", 0);
            if (path != null) {
                this.setLocationPath(path);
            }
        }
    }

    public String getLocationPath() {
        return this.fText.getText();
    }

    private String getSavedPath() {
        if (this.fRemoteConnection != null) {
            return this.fPreviousSelections.get(String.valueOf(this.fRemoteConnection.getConnectionType().getId()) + "." + this.fRemoteConnection.getName());
        }
        return null;
    }

    private IRemoteUIConnectionService getUIConnectionManager() {
        if (this.fRemoteConnection != null) {
            return (IRemoteUIConnectionService)this.fRemoteConnection.getConnectionType().getService(IRemoteUIConnectionService.class);
        }
        return null;
    }

    private IRemoteUIFileService getUIFileManager() {
        if (this.fRemoteConnection != null) {
            return (IRemoteUIFileService)this.fRemoteConnection.getConnectionType().getService(IRemoteUIFileService.class);
        }
        return null;
    }

    private void notifyListeners(ModifyEvent e) {
        Object[] objectArray = this.fModifyListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ModifyListener)listener).modifyText(e);
            ++n2;
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.fModifyListeners.remove((Object)listener);
    }

    private void restoreDefault(String path) {
        IRemoteProcessService processService;
        if (path == null && this.fRemoteConnection != null && (processService = (IRemoteProcessService)this.fRemoteConnection.getService(IRemoteProcessService.class)) != null) {
            path = processService.getWorkingDirectory().toString();
        }
        if (path == null) {
            path = "";
        }
        this.setLocationPath(path);
    }

    public void setBrowseMessage(String message) {
        this.fBrowseMessage = message;
    }

    public void setConnection(IRemoteConnection conn) {
        if (conn == null) {
            throw new NullPointerException();
        }
        if (conn.hasService(IRemoteFileService.class) && conn.getConnectionType().hasService(IRemoteUIConnectionService.class) && conn.getConnectionType().hasService(IRemoteUIFileService.class) && !conn.equals(this.fRemoteConnection)) {
            this.fRemoteConnection = conn;
            String path = this.getSavedPath();
            this.restoreDefault(path);
            this.updateBrowseButton();
        }
    }

    public void setEnabled(boolean enabled) {
        if (!this.fText.isDisposed()) {
            this.fText.setEnabled(enabled);
        }
        if (!this.fBrowseButton.isDisposed()) {
            this.fBrowseButton.setEnabled(enabled);
        }
    }

    public void setLabel(String label) {
        if (this.fLabel != null && !this.fLabel.isDisposed()) {
            this.fLabel.setText(label);
        }
    }

    public void setLocationPath(String path) {
        if (path != null && !path.equals(this.getLocationPath())) {
            this.fText.setText(path);
        }
    }

    private void setSavedPath(String path) {
        if (this.fRemoteConnection != null) {
            this.fPreviousSelections.put(String.valueOf(this.fRemoteConnection.getConnectionType().getId()) + "." + this.fRemoteConnection.getName(), path);
        }
    }

    private void updateBrowseButton() {
        this.fBrowseButton.setEnabled(this.getUIFileManager() != null);
    }
}

