/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.editor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buildship.core.internal.util.preference.EclipsePreferencesUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public final class GradlePresentationReconciler
extends PresentationReconciler {
    private TokenUpdatingPreferenceChangeListener listener;

    public void install(ITextViewer viewer) {
        super.install(viewer);
        BuildScriptTokens tokens = new BuildScriptTokens();
        tokens.update();
        this.listener = new TokenUpdatingPreferenceChangeListener(viewer, tokens);
        EclipsePreferencesUtils.getInstanceScope().getNode("org.eclipse.jdt.ui").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.listener);
        SimpleScanner scanner = new SimpleScanner();
        scanner.setRules(tokens.toRules());
        this.setDamagerRepairer((ITokenScanner)scanner, "__dftl_partition_content_type");
        MultilineCommentScanner multilineCommentScanner = new MultilineCommentScanner(tokens.getToken(BuildScriptTokenType.MULTI_LINE_COMMENT));
        this.setDamagerRepairer((ITokenScanner)multilineCommentScanner, "org.eclipse.buildship.ui.buildscript.multilinecomment");
        this.setDamagerRepairer((ITokenScanner)multilineCommentScanner, "org.eclipse.buildship.ui.buildscript.javadoccomment");
    }

    public void uninstall() {
        if (this.listener != null) {
            EclipsePreferencesUtils.getInstanceScope().getNode("org.eclipse.jdt.ui").removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.listener);
        }
        super.uninstall();
    }

    private void setDamagerRepairer(ITokenScanner scanner, String tokenType) {
        DefaultDamagerRepairer damagerRepairer = new DefaultDamagerRepairer(scanner);
        this.setDamager((IPresentationDamager)damagerRepairer, tokenType);
        this.setRepairer((IPresentationRepairer)damagerRepairer, tokenType);
    }

    private static enum BuildScriptTokenType {
        KEYWORD("java_keyword"),
        SINGLE_LINE_COMMENT("java_single_line_comment"),
        MULTI_LINE_COMMENT("java_multi_line_comment"),
        STRING("java_string"),
        DEFAULT("java_default");

        private final String colorKey;

        private BuildScriptTokenType(String colorKey) {
            this.colorKey = colorKey;
        }

        public String getColorKey() {
            return this.colorKey;
        }

        private static List<String> getAllColorKeys() {
            ArrayList result = Lists.newArrayListWithCapacity((int)BuildScriptTokenType.values().length);
            for (BuildScriptTokenType tokenType : BuildScriptTokenType.values()) {
                result.add(tokenType.getColorKey());
            }
            return result;
        }
    }

    private static class BuildScriptTokens {
        private final ImmutableMap<BuildScriptTokenType, Token> tokens;

        public BuildScriptTokens() {
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (BuildScriptTokenType tokenType : BuildScriptTokenType.values()) {
                result.put((Object)tokenType, (Object)new Token(null));
            }
            this.tokens = result.build();
        }

        public Token getToken(BuildScriptTokenType tokenType) {
            return (Token)this.tokens.get((Object)tokenType);
        }

        public void update() {
            for (BuildScriptTokenType tokenType : BuildScriptTokenType.values()) {
                ((Token)this.tokens.get((Object)tokenType)).setData((Object)new TextAttribute(JavaUI.getColorManager().getColor(tokenType.getColorKey())));
            }
        }

        public IRule[] toRules() {
            return new IRule[]{new EndOfLineRule("//", (IToken)this.tokens.get((Object)BuildScriptTokenType.SINGLE_LINE_COMMENT)), new MultiLineRule("/*", "*/", (IToken)this.tokens.get((Object)BuildScriptTokenType.MULTI_LINE_COMMENT), '\u0000', true), new SingleLineRule("\"", "\"", (IToken)this.tokens.get((Object)BuildScriptTokenType.STRING)), new SingleLineRule("'", "'", (IToken)this.tokens.get((Object)BuildScriptTokenType.STRING)), new KeywordRule((IToken)this.tokens.get((Object)BuildScriptTokenType.KEYWORD)), new WordRule((IWordDetector)new WordDetector(), (IToken)this.tokens.get((Object)BuildScriptTokenType.DEFAULT)), new NumberRule((IToken)this.tokens.get((Object)BuildScriptTokenType.DEFAULT))};
        }
    }

    private static class KeywordRule
    extends WordRule {
        private static final List<String> KEYWORDS = ImmutableList.of((Object)"assert", (Object)"if", (Object)"else", (Object)"void", (Object)"null", (Object)"new", (Object)"return", (Object)"try", (Object)"catch", (Object)"def", (Object)"allprojects", (Object)"artifacts", (Object[])new String[]{"buildscript", "configurations", "dependencies", "repositories", "sourceSets", "subprojects", "publishing", "task", "apply", "sourceCompatibility", "targetCompatibility", "test", "project", "ext", "plugins", "jar", "shadowJar", "for", "while"});

        public KeywordRule(IToken token) {
            super((IWordDetector)new WordDetector());
            for (String word : KEYWORDS) {
                this.addWord(word, token);
            }
        }
    }

    private static class MultilineCommentScanner
    extends BufferedRuleBasedScanner {
        public MultilineCommentScanner(Token token) {
            this.setDefaultReturnToken((IToken)token);
        }
    }

    private static class SimpleScanner
    extends BufferedRuleBasedScanner {
        private SimpleScanner() {
        }
    }

    private static class TokenUpdatingPreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final ITextViewer viewer;
        private final BuildScriptTokens tokens;

        public TokenUpdatingPreferenceChangeListener(ITextViewer viewer, BuildScriptTokens tokens) {
            this.viewer = viewer;
            this.tokens = tokens;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (BuildScriptTokenType.getAllColorKeys().contains(event.getKey())) {
                this.viewer.invalidateTextPresentation();
                this.tokens.update();
            }
        }
    }

    private static class WordDetector
    implements IWordDetector {
        private WordDetector() {
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }
    }
}

