/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.snapshot.ISnapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplePathsFromGCRootsRecord {
    final ISnapshot snapshot;
    final int objectId;
    final int level;
    List<int[]> paths;
    long referencedSize = -1L;
    long referencedRetainedSize;

    public long getReferencedRetainedSize() {
        return this.referencedRetainedSize;
    }

    public void setReferencedRetainedSize(long referencedRetainedSize) {
        this.referencedRetainedSize = referencedRetainedSize;
    }

    public MultiplePathsFromGCRootsRecord(int objectId, int level, ISnapshot snapshot) {
        this.level = level;
        this.objectId = objectId;
        this.paths = new ArrayList<int[]>();
        this.snapshot = snapshot;
    }

    public MultiplePathsFromGCRootsRecord[] nextLevel() {
        int new_level = this.level + 1;
        HashMapIntObject nextLevelRecords = new HashMapIntObject();
        for (int[] path : this.paths) {
            if (path == null || path.length - new_level - 1 < 0) continue;
            MultiplePathsFromGCRootsRecord record = (MultiplePathsFromGCRootsRecord)nextLevelRecords.get(path[path.length - new_level - 1]);
            if (record == null) {
                record = new MultiplePathsFromGCRootsRecord(path[path.length - new_level - 1], new_level, this.snapshot);
                nextLevelRecords.put(path[path.length - new_level - 1], (Object)record);
            }
            record.addPath(path);
        }
        return (MultiplePathsFromGCRootsRecord[])nextLevelRecords.getAllValues((Object[])new MultiplePathsFromGCRootsRecord[0]);
    }

    public void addPath(int[] path) {
        this.paths.add(path);
    }

    public List<int[]> getPaths() {
        return this.paths;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public int getCount() {
        return this.paths.size();
    }

    public int getLevel() {
        return this.level;
    }

    public int[] getReferencedObjects() {
        int[] result = new int[this.paths.size()];
        int i = 0;
        for (int[] path : this.paths) {
            result[i++] = path[0];
        }
        return result;
    }

    public long getReferencedHeapSize() throws SnapshotException {
        if (this.referencedSize == -1L) {
            this.referencedSize = this.snapshot.getHeapSize(this.getReferencedObjects());
        }
        return this.referencedSize;
    }

    public static Comparator<MultiplePathsFromGCRootsRecord> getComparatorByNumberOfReferencedObjects() {
        return new Comparator<MultiplePathsFromGCRootsRecord>(){

            @Override
            public int compare(MultiplePathsFromGCRootsRecord o1, MultiplePathsFromGCRootsRecord o2) {
                if (o1.paths.size() < o2.paths.size()) {
                    return 1;
                }
                if (o1.paths.size() > o2.paths.size()) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public static Comparator<MultiplePathsFromGCRootsRecord> getComparatorByReferencedHeapSize() {
        return new Comparator<MultiplePathsFromGCRootsRecord>(){

            @Override
            public int compare(MultiplePathsFromGCRootsRecord o1, MultiplePathsFromGCRootsRecord o2) {
                block4: {
                    try {
                        if (o1.getReferencedHeapSize() >= o2.getReferencedHeapSize()) break block4;
                        return 1;
                    }
                    catch (SnapshotException e) {
                        return 0;
                    }
                }
                if (o1.getReferencedHeapSize() > o2.getReferencedHeapSize()) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public static Comparator<MultiplePathsFromGCRootsRecord> getComparatorByReferencedRetainedSize() {
        return new Comparator<MultiplePathsFromGCRootsRecord>(){

            @Override
            public int compare(MultiplePathsFromGCRootsRecord o1, MultiplePathsFromGCRootsRecord o2) {
                if (o1.getReferencedRetainedSize() < o2.getReferencedRetainedSize()) {
                    return 1;
                }
                if (o1.getReferencedRetainedSize() > o2.getReferencedRetainedSize()) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

