/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.business.api.helper.filter.FilterService;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.ui.business.api.helper.graphicalfilters.CompositeFilterApplicationBuilder;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.LockStatus;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class FilterListener
implements ModelChangeTrigger {
    public static final int COMPOSITE_FILTER_REFRESH_PRIORITY = 5;
    private DDiagram dDiagram;
    private TransactionalEditingDomain domain;

    public FilterListener(DDiagram dDiagram, TransactionalEditingDomain domain) {
        this.dDiagram = dDiagram;
        this.domain = domain;
    }

    public int priority() {
        return 5;
    }

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        FilteredElementsUpdateCommand finalCommand = null;
        Command sortFiltersCommand = this.getSortFiltersCommand(notifications);
        FilteredElementsUpdateCommand updateFilterApplicationCmd = new FilteredElementsUpdateCommand(this.domain, this.dDiagram);
        if (sortFiltersCommand != null) {
            CompoundCommand compoundCommand = new CompoundCommand();
            compoundCommand.append(sortFiltersCommand);
            compoundCommand.append((Command)updateFilterApplicationCmd);
            finalCommand = compoundCommand;
        } else {
            finalCommand = updateFilterApplicationCmd;
        }
        return Options.newSome((Object)((Object)finalCommand));
    }

    private Command getSortFiltersCommand(Collection<Notification> notifications) {
        FiltersSortingCommand recordingCommand = null;
        for (Notification notification : notifications) {
            if (!(notification.getNotifier() instanceof DDiagram) || !notification.getFeature().equals(DiagramPackage.eINSTANCE.getDDiagram_ActivatedFilters()) || 3 != notification.getEventType() && 5 != notification.getEventType()) continue;
            DDiagram diagram = (DDiagram)notification.getNotifier();
            List sortedFilters = FilterService.sortFilters((Collection)diagram.getActivatedFilters());
            if (Iterables.elementsEqual((Iterable)sortedFilters, (Iterable)diagram.getActivatedFilters())) break;
            recordingCommand = new FiltersSortingCommand(this.domain, diagram, sortedFilters);
            break;
        }
        return recordingCommand;
    }

    private static class FilteredElementsUpdateCommand
    extends RecordingCommand {
        private DDiagram diagram;

        public FilteredElementsUpdateCommand(TransactionalEditingDomain domain, DDiagram dDiagram) {
            super(domain);
            this.diagram = dDiagram;
        }

        protected void doExecute() {
            IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)this.diagram);
            if (permissionAuthority == null || !LockStatus.LOCKED_BY_OTHER.equals((Object)permissionAuthority.getLockStatus((EObject)this.diagram))) {
                CompositeFilterApplicationBuilder builder = new CompositeFilterApplicationBuilder(this.diagram);
                builder.computeCompositeFilterApplications();
            }
        }
    }

    private static final class FiltersSortingCommand
    extends RecordingCommand {
        private final DDiagram diagram;
        private final List<FilterDescription> sortedFilters;

        private FiltersSortingCommand(TransactionalEditingDomain domain, DDiagram diagram, List<FilterDescription> sortedFilters) {
            super(domain);
            this.diagram = diagram;
            this.sortedFilters = sortedFilters;
        }

        protected void doExecute() {
            this.diagram.eSetDeliver(false);
            this.diagram.getActivatedFilters().clear();
            this.diagram.getActivatedFilters().addAll(this.sortedFilters);
            this.diagram.eSetDeliver(true);
        }
    }
}

