/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.layout.ordering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.AbstractNodeViewOrdering;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.GridView;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.ViewOrdering;

public abstract class AbstractTreeViewOrdering
implements ViewOrdering {
    private List<View> views;
    private GridView gridView;
    private boolean userAwareCapable;

    @Override
    public List<View> getSortedViews() {
        return this.views;
    }

    public void setUserAwareCapable(boolean userAwareCapable) {
        this.userAwareCapable = userAwareCapable;
    }

    @Override
    public GridView getSortedViewsAsGrid() {
        if (this.gridView == null) {
            this.buildTree();
        }
        return this.gridView;
    }

    @Override
    public boolean isAbleToManageView(View view) {
        return view instanceof Node;
    }

    @Override
    public <T extends View> void setViews(Collection<T> views) {
        this.views = Collections.unmodifiableList(new ArrayList<T>(views));
        this.gridView = null;
    }

    public abstract List<View> getRoots(List<View> var1);

    public abstract List<View> getChildren(View var1, List<View> var2);

    private void buildTree() {
        AirTree airTree;
        List<View> roots = this.getRoots(this.views);
        UserAwareCapableOrdering userAwareCapableOrdering = new UserAwareCapableOrdering();
        userAwareCapableOrdering.setViews(roots);
        roots = new ArrayList<View>(userAwareCapableOrdering.getSortedViews());
        AirTree dummyRoot = new AirTree(null);
        for (View view : roots) {
            airTree = new AirTree(view);
            airTree.setParent(dummyRoot);
        }
        ArrayList<AirTree> currentViews = new ArrayList<AirTree>(dummyRoot.getChildren());
        while (!currentViews.isEmpty()) {
            airTree = (AirTree)currentViews.get(0);
            List<View> childrenView = this.getChildren(airTree.getView(), this.views);
            if (this.userAwareCapable) {
                UserAwareCapableOrdering ordering = new UserAwareCapableOrdering();
                ordering.setViews(childrenView);
                childrenView = ordering.getSortedViews();
            }
            for (View currentChild : childrenView) {
                AirTree childAirTree = new AirTree(currentChild);
                childAirTree.setParent(airTree);
                currentViews.add(childAirTree);
            }
            currentViews.remove(airTree);
        }
        ExtendedGrid extendedGrid = this.getExtendedGrid(dummyRoot);
        View[][] gridViews = (View[][])extendedGrid.toArray(new View[extendedGrid.getNbColumns()][extendedGrid.getNbLines()]);
        this.gridView = GridView.create(gridViews);
        this.clear();
    }

    protected void clear() {
    }

    private ExtendedGrid getExtendedGrid(AirTree dummyRoot) {
        ExtendedGrid extendedGrid = new ExtendedGrid();
        List<AirTree> currentNodes = dummyRoot.getChildren();
        int lineIndex = 0;
        while (!currentNodes.isEmpty()) {
            LinkedList<AirTree> next = new LinkedList<AirTree>();
            extendedGrid.appendLine();
            for (AirTree node : currentNodes) {
                AirTree parent = node.getParent();
                int childIndex = parent.getChildren().indexOf(node);
                int childrenNumber = parent.getChildren().size();
                if (childIndex == 0) {
                    int nbColumnsToAdd = childrenNumber - childrenNumber % 2;
                    if (lineIndex > 0) {
                        int parentColumnIndex = this.getParentColumnIndex(extendedGrid, parent, lineIndex);
                        extendedGrid.insertColumn(parentColumnIndex);
                        extendedGrid.insertColumn(parentColumnIndex);
                        int i = 0;
                        while (i < nbColumnsToAdd) {
                            parentColumnIndex = this.getParentColumnIndex(extendedGrid, parent, lineIndex);
                            if (i % 2 == 0) {
                                extendedGrid.insertColumn(parentColumnIndex);
                            } else {
                                extendedGrid.insertColumn(parentColumnIndex + 1);
                            }
                            ++i;
                        }
                        extendedGrid.insertColumn(parentColumnIndex + 1);
                        extendedGrid.insertColumn(parentColumnIndex + 1);
                        parentColumnIndex = this.getParentColumnIndex(extendedGrid, parent, lineIndex);
                        extendedGrid.setData(node.getView(), this.getColumnIndex(parentColumnIndex, childrenNumber, childIndex), lineIndex);
                    } else {
                        nbColumnsToAdd = childrenNumber;
                        int i = 0;
                        while (i < nbColumnsToAdd) {
                            extendedGrid.appendColumn();
                            ++i;
                        }
                        extendedGrid.setData(node.getView(), 0, lineIndex);
                    }
                } else {
                    int columnIndex;
                    if (lineIndex == 0) {
                        columnIndex = childIndex;
                    } else {
                        int parentIndex = this.getParentColumnIndex(extendedGrid, parent, lineIndex);
                        columnIndex = this.getColumnIndex(parentIndex, childrenNumber, childIndex);
                        if (childrenNumber % 2 == 0 && childrenNumber / 2 <= childIndex) {
                            ++columnIndex;
                        }
                    }
                    extendedGrid.setData(node.getView(), columnIndex, lineIndex);
                }
                next.addAll(node.getChildren());
            }
            currentNodes = next;
            ++lineIndex;
        }
        return extendedGrid;
    }

    private int getColumnIndex(int parentColumnIndex, int childrenNumber, int childIndex) {
        return parentColumnIndex - (int)Math.floor((double)childrenNumber / 2.0) + childIndex;
    }

    private int getParentColumnIndex(ExtendedGrid extendedGrid, AirTree parent, int lineIndex) {
        return extendedGrid.indexOf(parent.getView(), lineIndex - 1);
    }

    private static class AirTree {
        private List<AirTree> children = new LinkedList<AirTree>();
        private View view;
        private AirTree parent;

        AirTree(View view) {
            this.view = view;
        }

        public View getView() {
            return this.view;
        }

        public List<AirTree> getChildren() {
            return this.children;
        }

        public AirTree getParent() {
            return this.parent;
        }

        public void setParent(AirTree parent) {
            this.parent = parent;
            parent.children.add(this);
        }
    }

    private static class ExtendedGrid {
        private List<List<Object>> grid = new ArrayList<List<Object>>();
        private int nbColumns = 0;
        private int nbLines = 0;

        ExtendedGrid() {
        }

        public void appendColumn() {
            ArrayList<Object> column = new ArrayList<Object>(this.nbLines);
            int i = 0;
            while (i < this.nbLines) {
                column.add(null);
                ++i;
            }
            this.grid.add(column);
            ++this.nbColumns;
        }

        public void insertColumn(int index) {
            if (index >= this.nbColumns) {
                this.appendColumn();
            } else {
                ArrayList<Object> column = new ArrayList<Object>(this.nbLines);
                int i = 0;
                while (i < this.nbLines) {
                    column.add(null);
                    ++i;
                }
                this.grid.add(index, column);
                ++this.nbColumns;
            }
        }

        public void appendLine() {
            for (List<Object> column : this.grid) {
                column.add(null);
            }
            ++this.nbLines;
        }

        public void setData(Object data, int columnIndex, int lineIndex) {
            if (columnIndex >= this.nbColumns || columnIndex < 0) {
                throw new IllegalArgumentException();
            }
            if (lineIndex >= this.nbLines || lineIndex < 0) {
                throw new IllegalArgumentException();
            }
            List<Object> column = this.grid.get(columnIndex);
            column.set(lineIndex, data);
        }

        public int getNbColumns() {
            return this.nbColumns;
        }

        public int getNbLines() {
            return this.nbLines;
        }

        public int indexOf(Object data, int lineIndex) {
            int result = -1;
            int i = 0;
            while (i < this.grid.size() && result < 0) {
                List<Object> currentColumn = this.grid.get(i);
                if (currentColumn.get(lineIndex) != null && currentColumn.get(lineIndex).equals(data)) {
                    result = i;
                }
                ++i;
            }
            return result;
        }

        public Object[][] toArray(Object[][] array) {
            int i = 0;
            while (i < this.nbColumns) {
                List<Object> column = this.grid.get(i);
                int j = 0;
                while (j < this.nbLines) {
                    array[i][j] = column.get(j);
                    ++j;
                }
                ++i;
            }
            return array;
        }
    }

    private static class UserAwareCapableOrdering
    extends AbstractNodeViewOrdering {
        private int orientation = 64;

        private UserAwareCapableOrdering() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            Location loc1 = (Location)node1.getLayoutConstraint();
            Location loc2 = (Location)node2.getLayoutConstraint();
            if (this.orientation == 64) {
                return loc1.getX() - loc2.getX();
            }
            return loc1.getY() - loc2.getY();
        }

        @Override
        public boolean isAbleToManageNode(Node node) {
            return node.getLayoutConstraint() instanceof Location;
        }
    }
}

