/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.properties;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ColorsAndFontsPropertySection;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ConnectionAppearancePropertySection;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.BracketEdgeStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.ColorStyleQuery;
import org.eclipse.sirius.diagram.ui.internal.refresh.diagram.ViewPropertiesSynchronizer;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.color.ColorManager;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.style.ResetStylePropertiesToDefaultValuesAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.style.SetStyleToWorkspaceImageAction;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.ColorPalettePopup;
import org.eclipse.sirius.diagram.ui.tools.internal.properties.ResetStylePropertiesToDefaultValuesSelectionAdapter;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.sirius.viewpoint.description.FixedColor;
import org.eclipse.sirius.viewpoint.description.UserFixedColor;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPart;

public class DiagramConnectionAppearancePropertySection
extends ConnectionAppearancePropertySection {
    protected Button resetStylePropertiesToDefaultValuesButton;
    protected Button setStyleToWorkspaceImageButton;
    private Composite routingGroups;
    private Button fontUnderlineButton;
    private Button fontStrikeThroughButton;

    protected RGB changeColor(SelectionEvent event, Button button, final String propertyId, String commandName, ImageDescriptor imageDescriptor) {
        RGB colorToReturn = null;
        if (!(Properties.ID_FILLCOLOR.equals(propertyId) || Properties.ID_LINECOLOR.equals(propertyId) || Properties.ID_FONTCOLOR.equals(propertyId))) {
            colorToReturn = super.changeColor(event, button, propertyId, commandName, imageDescriptor);
        } else {
            ColorPalettePopup popup = new ColorPalettePopup(button.getParent().getShell(), 25, ColorManager.getDefault().collectVsmAndDefaultColors(new EObjectQuery(this.eObject).getSession()));
            Rectangle r = button.getBounds();
            Point location = button.getParent().toDisplay(r.x, r.y);
            popup.setPreviousColor(this.previousColor);
            popup.open(new Point(location.x, location.y + r.height));
            if (popup.getSelectedColor() == null && !popup.useDefaultColor()) {
                return null;
            }
            RGB selectedColor = popup.getSelectedColor();
            final EStructuralFeature feature = (EStructuralFeature)PackageUtil.getElement((String)propertyId);
            ArrayList<ICommand> commands = new ArrayList<ICommand>();
            Iterator it = this.getInputIterator();
            colorToReturn = selectedColor;
            RGB color = selectedColor;
            while (it.hasNext()) {
                Object preferredValue;
                final IGraphicalEditPart ep = (IGraphicalEditPart)it.next();
                color = selectedColor;
                if (popup.useDefaultColor() && (preferredValue = ep.getPreferredValue(feature)) instanceof Integer) {
                    color = FigureUtilities.integerToRGB((Integer)((Integer)preferredValue));
                }
                if (colorToReturn == null) {
                    colorToReturn = color;
                }
                if (color == null) continue;
                final RGB finalColor = color;
                commands.add(this.createCommand(commandName, ((View)ep.getModel()).eResource(), new Runnable(){

                    @Override
                    public void run() {
                        ENamedElement element = PackageUtil.getElement((String)propertyId);
                        if (element instanceof EStructuralFeature) {
                            ep.setStructuralFeatureValue(feature, (Object)FigureUtilities.RGBToInteger((RGB)finalColor));
                        }
                        View view = (View)ep.getModel();
                        UserFixedColor newColor = DescriptionFactory.eINSTANCE.createUserFixedColor();
                        newColor.setName(Messages.AnonymousUserFixedColorName);
                        newColor.setBlue(finalColor.blue);
                        newColor.setGreen(finalColor.green);
                        newColor.setRed(finalColor.red);
                        IInterpreter interpreter = new EObjectQuery((EObject)view).getSession().getInterpreter();
                        new ViewPropertiesSynchronizer().synchronizeDDiagramElementStyleColorProperties(view, (FixedColor)newColor, propertyId, interpreter);
                    }
                }));
            }
            if (!commands.isEmpty()) {
                this.executeAsCompositeCommand(commandName, commands);
                Image overlyedImage = new ColorsAndFontsPropertySection.ColorOverlayImageDescriptor(imageDescriptor.getImageData(100), color).createImage();
                this.disposeImage(button.getImage());
                button.setImage(overlyedImage);
            }
        }
        return colorToReturn;
    }

    protected void updateColorCache() {
        this.executeAsReadAction(new Runnable(){

            @Override
            public void run() {
                IGraphicalEditPart ep = DiagramConnectionAppearancePropertySection.this.getSingleInput();
                if (ep != null) {
                    Style style;
                    EObject resolveSemanticElement = ep.resolveSemanticElement();
                    if (resolveSemanticElement instanceof DDiagramElement && (style = ((DDiagramElement)resolveSemanticElement).getStyle()) != null) {
                        ColorStyleQuery colorStyleQuery = new ColorStyleQuery(style);
                        colorStyleQuery.getLabelColor().ifPresent(rgbValues -> {
                            RGB rGB = new RGB(rgbValues.getRed(), rgbValues.getGreen(), rgbValues.getBlue());
                            RGB rGB2 = rGB;
                            DiagramConnectionAppearancePropertySection.this.fontColor = rGB;
                        });
                        colorStyleQuery.getLineColor().ifPresent(rgbValues -> {
                            RGB rGB = new RGB(rgbValues.getRed(), rgbValues.getGreen(), rgbValues.getBlue());
                            RGB rGB2 = rGB;
                            DiagramConnectionAppearancePropertySection.this.lineColor = rGB;
                        });
                    }
                } else {
                    DiagramConnectionAppearancePropertySection.this.fontColor = DEFAULT_PREF_COLOR;
                    DiagramConnectionAppearancePropertySection.this.lineColor = DEFAULT_PREF_COLOR;
                }
            }
        });
    }

    protected Composite createFontsGroup(Composite parent) {
        Composite toolBar = super.createFontsGroup(parent);
        Image imageUndo = DiagramUIPlugin.getPlugin().getBundledImage("icons/undo_edit.gif");
        Image imageImage = DiagramUIPlugin.getPlugin().getBundledImage("icons/image_obj.gif");
        Image imageUnderline = DiagramUIPlugin.getPlugin().getBundledImage("icons/underline.gif");
        Image imageStrikeThrough = DiagramUIPlugin.getPlugin().getBundledImage("icons/strikethrough.gif");
        boolean isReadOnly = this.isReadOnly();
        this.fontUnderlineButton = new Button(toolBar, 2);
        this.fontUnderlineButton.setImage(imageUnderline);
        this.fontUnderlineButton.setEnabled(!isReadOnly);
        this.fontUnderlineButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.FontPropertySection_underline;
            }
        });
        this.fontStrikeThroughButton = new Button(toolBar, 2);
        this.fontStrikeThroughButton.setImage(imageStrikeThrough);
        this.fontStrikeThroughButton.setEnabled(!isReadOnly);
        this.fontStrikeThroughButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.FontPropertySection_strikeThrough;
            }
        });
        new Label(toolBar, 16384);
        new Label(toolBar, 16384);
        new Label(toolBar, 16384);
        this.setStyleToWorkspaceImageButton = new Button(toolBar, 8);
        this.setStyleToWorkspaceImageButton.setToolTipText(SetStyleToWorkspaceImageAction.SET_STYLE_TO_WORKSPACE_IMAGE_ACTION_NAME);
        this.setStyleToWorkspaceImageButton.setImage(imageImage);
        this.setStyleToWorkspaceImageButton.setEnabled(false);
        this.resetStylePropertiesToDefaultValuesButton = new Button(toolBar, 8);
        this.resetStylePropertiesToDefaultValuesButton.setToolTipText(ResetStylePropertiesToDefaultValuesAction.ACTION_NAME);
        this.resetStylePropertiesToDefaultValuesButton.setImage(imageUndo);
        this.resetStylePropertiesToDefaultValuesButton.addSelectionListener((SelectionListener)new ResetStylePropertiesToDefaultValuesSelectionAdapter((ColorsAndFontsPropertySection)this));
        this.resetStylePropertiesToDefaultValuesButton.setEnabled(!this.isReadOnly());
        this.fontUnderlineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DiagramConnectionAppearancePropertySection.this.updateFontUnderline();
            }
        });
        this.fontStrikeThroughButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DiagramConnectionAppearancePropertySection.this.updateFontStrikeThrough();
            }
        });
        return toolBar;
    }

    private void updateFontUnderline() {
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        Iterator it = this.getInputIterator();
        while (it.hasNext()) {
            final IGraphicalEditPart ep = (IGraphicalEditPart)it.next();
            commands.add(this.createCommand(FONT_COMMAND_NAME, ((View)ep.getModel()).eResource(), new Runnable(){

                @Override
                public void run() {
                    ep.setStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Underline(), (Object)DiagramConnectionAppearancePropertySection.this.fontUnderlineButton.getSelection());
                }
            }));
        }
        this.executeAsCompositeCommand(FONT_COMMAND_NAME, commands);
    }

    private void updateFontStrikeThrough() {
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        Iterator it = this.getInputIterator();
        while (it.hasNext()) {
            final IGraphicalEditPart ep = (IGraphicalEditPart)it.next();
            commands.add(this.createCommand(FONT_COMMAND_NAME, ((View)ep.getModel()).eResource(), new Runnable(){

                @Override
                public void run() {
                    ep.setStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_StrikeThrough(), (Object)DiagramConnectionAppearancePropertySection.this.fontStrikeThroughButton.getSelection());
                }
            }));
        }
        this.executeAsCompositeCommand(FONT_COMMAND_NAME, commands);
    }

    protected void createRouterOptionsGroup(Composite groups) {
        super.createRouterOptionsGroup(groups);
        this.routingGroups = groups;
    }

    public void setInput(IWorkbenchPart workbenchPart, ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof StructuredSelection)) {
            super.setInput(workbenchPart, selection);
            return;
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        ArrayList newSelection = new ArrayList();
        for (Object selectionItem : structuredSelection) {
            if (this.transformSelection(selectionItem) == null) continue;
            newSelection.add(selectionItem);
        }
        this.composite.setVisible(!newSelection.isEmpty());
        super.setInput(workbenchPart, (ISelection)new StructuredSelection(newSelection));
    }

    protected Object transformSelection(Object selection) {
        EObject target;
        Object object = selection;
        if (object instanceof EditPart) {
            object = ((EditPart)object).getModel();
        } else if (object instanceof IAdaptable) {
            object = ((IAdaptable)object).getAdapter(View.class);
        }
        if (object instanceof View) {
            object = ((View)object).getElement();
        }
        if (object instanceof DSemanticDecorator && ((target = ((DSemanticDecorator)object).getTarget()) == null || target.eResource() == null)) {
            object = null;
        }
        return object;
    }

    public void dispose() {
        this.resetStylePropertiesToDefaultValuesButton = null;
        this.routingGroups = null;
        super.dispose();
    }

    public void refresh() {
        if (!this.isDisposed() && this.getSingleInput() != null) {
            super.refresh();
            this.executeAsReadAction(new Runnable(){

                @Override
                public void run() {
                    boolean hasBracketStyle = false;
                    IGraphicalEditPart ep = DiagramConnectionAppearancePropertySection.this.getSingleInput();
                    if (ep != null) {
                        View view = (View)ep.getModel();
                        EObject dDiagElement = view.getElement();
                        if (dDiagElement instanceof DEdge) {
                            DEdge dEdge = (DEdge)dDiagElement;
                            EdgeStyle edgeStyle = dEdge.getOwnedStyle();
                            hasBracketStyle = edgeStyle instanceof BracketEdgeStyle;
                        }
                        boolean isReadOnly = DiagramConnectionAppearancePropertySection.this.isReadOnly();
                        boolean isCustomizedView = ResetStylePropertiesToDefaultValuesSelectionAdapter.isCustomizedView(view);
                        DiagramConnectionAppearancePropertySection.this.resetStylePropertiesToDefaultValuesButton.setEnabled(!isReadOnly && isCustomizedView);
                        DiagramConnectionAppearancePropertySection.this.enableRoutingGroup(hasBracketStyle);
                        if (DiagramConnectionAppearancePropertySection.this.fontUnderlineButton != null) {
                            boolean underlined = (Boolean)ep.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Underline());
                            DiagramConnectionAppearancePropertySection.this.fontUnderlineButton.setSelection(underlined);
                            DiagramConnectionAppearancePropertySection.this.fontUnderlineButton.setEnabled(!isReadOnly);
                        }
                        if (DiagramConnectionAppearancePropertySection.this.fontStrikeThroughButton != null) {
                            boolean striked = (Boolean)ep.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_StrikeThrough());
                            DiagramConnectionAppearancePropertySection.this.fontStrikeThroughButton.setSelection(striked);
                            DiagramConnectionAppearancePropertySection.this.fontStrikeThroughButton.setEnabled(!isReadOnly);
                        }
                    }
                }
            });
        }
    }

    private void enableRoutingGroup(boolean hasBracketStyle) {
        this.routingGroups.setEnabled(!hasBracketStyle);
        Control[] controlArray = this.routingGroups.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control childControl = controlArray[n2];
            childControl.setEnabled(!hasBracketStyle);
            if (childControl instanceof Composite) {
                Composite childComposite = (Composite)childControl;
                Control[] controlArray2 = childComposite.getChildren();
                int n3 = controlArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Control childOfChildControl = controlArray2[n4];
                    childOfChildControl.setEnabled(!hasBracketStyle);
                    ++n4;
                }
            }
            ++n2;
        }
        for (Object object : Routing.VALUES) {
            Object buttonObj = this.buttons.get(object);
            if (!(buttonObj instanceof Button)) continue;
            Button button = (Button)buttonObj;
            button.setEnabled(!hasBracketStyle);
        }
    }
}

