/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.util;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.HideFilter;

public class NotificationQuery
extends org.eclipse.sirius.common.tools.api.query.NotificationQuery {
    private static final Collection<EStructuralFeature> NOTATION_LAYOUT_FEATURES = new HashSet<EStructuralFeature>(Arrays.asList(NotationPackage.eINSTANCE.getRelativeBendpoints_Points(), NotationPackage.eINSTANCE.getEdge_Bendpoints(), NotationPackage.eINSTANCE.getLocation_Y(), NotationPackage.eINSTANCE.getLocation_X(), NotationPackage.eINSTANCE.getSize_Width(), NotationPackage.eINSTANCE.getSize_Height(), NotationPackage.eINSTANCE.getNode_LayoutConstraint()));
    private final Notification notif;

    public NotificationQuery(Notification notif) {
        super(notif);
        this.notif = (Notification)Preconditions.checkNotNull((Object)notif);
    }

    public boolean isNotationChange() {
        Object feature = this.notif.getFeature();
        return feature instanceof EStructuralFeature && ((EStructuralFeature)feature).getEContainingClass().getEPackage().equals(NotationPackage.eINSTANCE);
    }

    public boolean isNotationLayoutChange() {
        return NOTATION_LAYOUT_FEATURES.contains(this.notif.getFeature());
    }

    public boolean isViewBecomingInvisibleEvent() {
        Object feature = this.notif.getFeature();
        boolean isViewVisibleFalseEvent = NotationPackage.eINSTANCE.getView_Visible().equals(feature);
        isViewVisibleFalseEvent = isViewVisibleFalseEvent && !this.notif.getNewBooleanValue();
        isViewVisibleFalseEvent = isViewVisibleFalseEvent && 1 == this.notif.getEventType();
        return isViewVisibleFalseEvent;
    }

    public boolean isHideFilterAddEvent() {
        Object feature = this.notif.getFeature();
        boolean isHideFilterAddEvent = DiagramPackage.eINSTANCE.getDDiagramElement_GraphicalFilters().equals(feature);
        isHideFilterAddEvent = isHideFilterAddEvent && this.notif.getNewValue() instanceof HideFilter;
        isHideFilterAddEvent = isHideFilterAddEvent && 3 == this.notif.getEventType();
        return isHideFilterAddEvent;
    }
}

