/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.databinding.xwt.model.widgets;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.ObserveTypeContainer;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.widgets.WidgetBindableInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WidgetsObserveTypeContainer
extends ObserveTypeContainer {
    private List<WidgetBindableInfo> m_observables = Collections.emptyList();

    public WidgetsObserveTypeContainer() {
        super(ObserveType.WIDGETS, true, false);
    }

    @Override
    public void synchronizeObserves() throws Exception {
        for (WidgetBindableInfo widget : this.m_observables) {
            widget.update();
        }
    }

    @Override
    public void createObservables(XmlObjectInfo xmlObjectRoot) throws Exception {
        this.m_observables = Lists.newArrayList();
        this.m_observables.add(new WidgetBindableInfo(xmlObjectRoot, null));
    }

    public List<IObserveInfo> getObservables() {
        return CoreUtils.cast(this.m_observables);
    }

    public WidgetBindableInfo resolve(XmlObjectInfo xmlObjectInfo) {
        return this.m_observables.get(0).resolve(xmlObjectInfo);
    }

    public WidgetBindableInfo resolve(DocumentElement element) {
        return this.m_observables.get(0).resolve(element);
    }

    public WidgetBindableInfo resolve(String reference) throws Exception {
        return (WidgetBindableInfo)this.m_observables.get(0).resolveReference(reference);
    }
}

