/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.filterrow.ParseResult;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.papyrus.infra.nattable.filter.FilterRowUtils;
import org.eclipse.papyrus.infra.nattable.filter.IPapyrusMatcherEditorFactory;
import org.eclipse.papyrus.infra.nattable.filter.PapyrusTextMatchingMode;
import org.eclipse.papyrus.infra.nattable.filter.PapyrusThresholdMatcherEditor;
import org.eclipse.papyrus.infra.nattable.filter.RegexFindEditor;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;

public class StringMatcherEditorFactory<T>
implements IPapyrusMatcherEditorFactory<T> {
    private static final TextMatchingMode convertToTextMatchingMode(PapyrusTextMatchingMode mode) {
        switch (mode) {
            case CONTAINS: {
                return TextMatchingMode.CONTAINS;
            }
            case EXACT: {
                return TextMatchingMode.EXACT;
            }
            case REGEX_FIND: 
            case REGEX_MATCH: {
                return TextMatchingMode.REGULAR_EXPRESSION;
            }
            case NUM: {
                return TextMatchingMode.REGULAR_EXPRESSION;
            }
            case START: {
                return TextMatchingMode.STARTS_WITH;
            }
        }
        return TextMatchingMode.CONTAINS;
    }

    @Override
    public EventList<MatcherEditor<T>> instantiateMatcherEditors(IColumnAccessor<T> columnAccessor, Integer columnIndex, Object wantedValue, IConfigRegistry configRegistry) {
        Assert.isTrue((boolean)(wantedValue instanceof String));
        BasicEventList matcherEditors = new BasicEventList();
        StringBuilder columnLabelBuilder = new StringBuilder();
        columnLabelBuilder.append("FILTER_COLUMN_");
        columnLabelBuilder.append(columnIndex);
        String columnLabelId = columnLabelBuilder.toString();
        PapyrusTextMatchingMode papyrusTextMatchingMode = this.getTextMatchingMode((String)wantedValue, configRegistry, columnLabelId);
        String textDelimiter = (String)configRegistry.getConfigAttribute(FilterRowConfigAttributes.TEXT_DELIMITER, "NORMAL", new String[]{columnLabelId});
        String filterText = this.getStringFromColumnObject(columnIndex, wantedValue, configRegistry);
        BasicEventList stringMatcherEditors = new BasicEventList();
        TextMatchingMode textMatchingMode = StringMatcherEditorFactory.convertToTextMatchingMode(papyrusTextMatchingMode);
        IDisplayConverter displayConverter = (IDisplayConverter)configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, "NORMAL", new String[]{columnLabelId});
        Comparator comparator = (Comparator)configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_COMPARATOR, "NORMAL", new String[]{columnLabelId});
        FunctionList.Function<T, Object> columnValueProvider = this.getColumnValueProvider(columnIndex, columnAccessor);
        if (PapyrusTextMatchingMode.REGEX_FIND.equals((Object)papyrusTextMatchingMode)) {
            stringMatcherEditors.add((Object)new RegexFindEditor(columnAccessor, columnIndex, filterText, configRegistry));
        } else {
            List<ParseResult> parseResults = FilterRowUtils.parse(filterText, textDelimiter, textMatchingMode);
            for (ParseResult parseResult : parseResults) {
                ParseResult.MatchType matchOperation = parseResult.getMatchOperation();
                if (matchOperation == ParseResult.MatchType.NONE) {
                    stringMatcherEditors.add(this.getTextMatcherEditor(columnIndex, papyrusTextMatchingMode, textMatchingMode, displayConverter, parseResult.getValueToMatch(), columnAccessor, configRegistry));
                    continue;
                }
                Object threshold = displayConverter.displayToCanonicalValue((Object)parseResult.getValueToMatch());
                stringMatcherEditors.add(this.getThresholdMatcherEditor(columnIndex, threshold, wantedValue, comparator, columnValueProvider, matchOperation, configRegistry));
            }
        }
        if (stringMatcherEditors.size() > 0) {
            CompositeMatcherEditor stringCompositeMatcherEditor = new CompositeMatcherEditor((EventList)stringMatcherEditors);
            stringCompositeMatcherEditor.setMode(24);
            matcherEditors.add((Object)stringCompositeMatcherEditor);
        }
        return matcherEditors;
    }

    protected PapyrusTextMatchingMode getTextMatchingMode(String wantedValue, IConfigRegistry configRegistry, String columnLabel) {
        PapyrusTextMatchingMode papyrusMatchingMode = (PapyrusTextMatchingMode)((Object)configRegistry.getConfigAttribute(NattableConfigAttributes.STRING_FILTER_MATCHING_MODE, "NORMAL", new String[]{columnLabel}));
        TextMatchingMode nattableMatchingMode = (TextMatchingMode)configRegistry.getConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, "NORMAL", new String[]{columnLabel});
        if (papyrusMatchingMode == null && nattableMatchingMode == null) {
            papyrusMatchingMode = PapyrusTextMatchingMode.CONTAINS;
        }
        if ((papyrusMatchingMode != null || papyrusMatchingMode == null && nattableMatchingMode != null) && (PapyrusTextMatchingMode.CONTAINS.equals((Object)papyrusMatchingMode) || nattableMatchingMode.equals((Object)TextMatchingMode.CONTAINS))) {
            if (wantedValue.startsWith(PapyrusTextMatchingMode.REGEX_FIND.getMode())) {
                return PapyrusTextMatchingMode.REGEX_FIND;
            }
            if (wantedValue.startsWith(PapyrusTextMatchingMode.REGEX_MATCH.getMode())) {
                return PapyrusTextMatchingMode.REGEX_MATCH;
            }
            if (wantedValue.startsWith(PapyrusTextMatchingMode.CONTAINS.getMode())) {
                return PapyrusTextMatchingMode.CONTAINS;
            }
            if (wantedValue.startsWith(PapyrusTextMatchingMode.EXACT.getMode())) {
                return PapyrusTextMatchingMode.EXACT;
            }
            if (wantedValue.startsWith(PapyrusTextMatchingMode.START.getMode())) {
                return PapyrusTextMatchingMode.START;
            }
            if (wantedValue.startsWith(PapyrusTextMatchingMode.NUM.getMode())) {
                return PapyrusTextMatchingMode.NUM;
            }
        }
        if (papyrusMatchingMode == null) {
            switch (nattableMatchingMode) {
                case CONTAINS: {
                    return PapyrusTextMatchingMode.CONTAINS;
                }
                case EXACT: {
                    return PapyrusTextMatchingMode.EXACT;
                }
                case REGULAR_EXPRESSION: {
                    return PapyrusTextMatchingMode.NUM;
                }
                case STARTS_WITH: {
                    return PapyrusTextMatchingMode.START;
                }
            }
            return PapyrusTextMatchingMode.CONTAINS;
        }
        return papyrusMatchingMode;
    }

    protected String getStringFromColumnObject(int columnIndex, Object object, IConfigRegistry configRegistry) {
        Assert.isTrue((boolean)(object instanceof String));
        String str = (String)object;
        if (str.startsWith(PapyrusTextMatchingMode.REGEX_FIND.getMode())) {
            str = str.replaceFirst(PapyrusTextMatchingMode.REGEX_FIND.getMode(), "");
        } else if (str.startsWith(PapyrusTextMatchingMode.REGEX_MATCH.getMode())) {
            str = str.replaceFirst(PapyrusTextMatchingMode.REGEX_MATCH.getMode(), "");
        } else if (str.startsWith(PapyrusTextMatchingMode.CONTAINS.getMode())) {
            str = str.replaceFirst(PapyrusTextMatchingMode.CONTAINS.getMode(), "");
        } else if (str.startsWith(PapyrusTextMatchingMode.EXACT.getMode())) {
            str = str.replaceFirst(PapyrusTextMatchingMode.EXACT.getMode(), "");
        } else if (str.startsWith(PapyrusTextMatchingMode.START.getMode())) {
            str = str.replaceFirst(PapyrusTextMatchingMode.START.getMode(), "");
        } else if (str.startsWith(PapyrusTextMatchingMode.NUM.getMode())) {
            str = str.replaceFirst(PapyrusTextMatchingMode.NUM.getMode(), "");
        }
        return str;
    }

    @Deprecated
    protected PapyrusThresholdMatcherEditor<T, Object> getThresholdMatcherEditor(Integer columnIndex, Object threshold, Comparator<Object> comparator, FunctionList.Function<T, Object> columnValueProvider, ParseResult.MatchType matchOperation, IConfigRegistry configRegistry) {
        PapyrusThresholdMatcherEditor thresholdMatcherEditor = new PapyrusThresholdMatcherEditor<T, Object>(threshold, null, comparator, columnValueProvider){};
        FilterRowUtils.setMatchOperation(thresholdMatcherEditor, matchOperation);
        return thresholdMatcherEditor;
    }

    protected PapyrusThresholdMatcherEditor<T, Object> getThresholdMatcherEditor(Integer columnIndex, Object threshold, Object objectToMatch, Comparator<Object> comparator, FunctionList.Function<T, Object> columnValueProvider, ParseResult.MatchType matchOperation, IConfigRegistry configRegistry) {
        PapyrusThresholdMatcherEditor thresholdMatcherEditor = new PapyrusThresholdMatcherEditor<T, Object>(threshold, null, comparator, columnValueProvider, columnIndex, objectToMatch){};
        FilterRowUtils.setMatchOperation(thresholdMatcherEditor, matchOperation);
        return thresholdMatcherEditor;
    }

    protected FunctionList.Function<T, Object> getColumnValueProvider(final int columnIndex, final IColumnAccessor<T> columnAccessor) {
        return new FunctionList.Function<T, Object>(){

            public Object evaluate(T rowObject) {
                return columnAccessor.getDataValue(rowObject, columnIndex);
            }
        };
    }

    @Deprecated
    protected TextMatcherEditor<T> getTextMatcherEditor(Integer columnIndex, TextMatchingMode textMatchingMode, IDisplayConverter converter, String filterText, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        PapyrusTextMatcherEditor<T> textMatcherEditor = new PapyrusTextMatcherEditor<T>(this.getTextFilterator(columnIndex, converter, columnAccessor, configRegistry), columnIndex, filterText, PapyrusTextMatchingMode.REGEX_FIND);
        textMatcherEditor.setFilterText(new String[]{filterText});
        textMatcherEditor.setMode(StringMatcherEditorFactory.getGlazedListsTextMatcherEditorMode(textMatchingMode));
        return textMatcherEditor;
    }

    protected TextMatcherEditor<T> getTextMatcherEditor(Integer columnIndex, PapyrusTextMatchingMode papyrusTextMatchingMode, TextMatchingMode textMatchingMode, IDisplayConverter converter, String filterText, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        PapyrusTextMatcherEditor<T> textMatcherEditor = new PapyrusTextMatcherEditor<T>(this.getTextFilterator(columnIndex, converter, columnAccessor, configRegistry), columnIndex, filterText, papyrusTextMatchingMode);
        textMatcherEditor.setFilterText(new String[]{filterText});
        textMatcherEditor.setMode(StringMatcherEditorFactory.getGlazedListsTextMatcherEditorMode(textMatchingMode));
        return textMatcherEditor;
    }

    protected TextFilterator<T> getTextFilterator(final Integer columnIndex, IDisplayConverter converter, IColumnAccessor<T> columnAccessor, final IConfigRegistry configRegistry) {
        return new TextFilterator<T>(){

            public void getFilterStrings(List<String> objectAsListOfStrings, T rowObject) {
                IDisplayConverter displayConverter;
                Object res;
                Object representedObject = AxisUtils.getRepresentedElement(rowObject);
                if (representedObject instanceof TreeFillingConfiguration) {
                    return;
                }
                INattableModelManager manager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
                int index = manager.getRowElementsList().indexOf(rowObject);
                BodyLayerStack stack = manager.getBodyLayerStack();
                ILayerCell cell = stack.getBodyDataLayer().getCellByPosition(columnIndex.intValue(), index);
                Object value = CellManagerFactory.INSTANCE.getCrossValue(manager.getColumnElement(columnIndex), rowObject, manager);
                if (cell == null) {
                    cell = new LabelProviderCellContextElementWrapper();
                    ((LabelProviderCellContextElementWrapper)cell).setConfigRegistry(configRegistry);
                    ((LabelProviderCellContextElementWrapper)cell).setCell((ILayerCell)new LayerCell((ILayer)stack.getBodyDataLayer(), columnIndex.intValue(), index));
                }
                if ((res = (displayConverter = (IDisplayConverter)configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, "NORMAL", new String[]{"FILTER_COLUMN_" + columnIndex})).canonicalToDisplayValue(cell, configRegistry, value)) instanceof String) {
                    objectAsListOfStrings.add((String)res);
                } else if (res instanceof Collection) {
                    Collection col = (Collection)res;
                    for (Object object : col) {
                        objectAsListOfStrings.add(object.toString());
                    }
                }
            }
        };
    }

    public static final int getGlazedListsTextMatcherEditorMode(TextMatchingMode textMatchingMode) {
        switch (textMatchingMode) {
            case EXACT: {
                return 3;
            }
            case STARTS_WITH: {
                return 1;
            }
            case REGULAR_EXPRESSION: {
                return 2;
            }
        }
        return 0;
    }

    public class PapyrusTextMatcherEditor<E>
    extends TextMatcherEditor<E> {
        private int columnIndex;
        private Object objectToMatch;
        private String papyrusMode;

        public PapyrusTextMatcherEditor(TextFilterator<? super E> filterator, int columnIndex, Object matchOn, PapyrusTextMatchingMode papyrusTextMatchingMode) {
            super(filterator);
            this.columnIndex = columnIndex;
            this.objectToMatch = matchOn;
            this.papyrusMode = papyrusTextMatchingMode.getMode();
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public Object getObjectToMatch() {
            return this.objectToMatch;
        }

        public String getPapyrusMode() {
            return this.papyrusMode;
        }
    }
}

