/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.layerstack;

import ca.odell.glazedlists.TreeList;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeData;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeRowModel;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.papyrus.infra.nattable.dataprovider.HierarchicalRowLabelHeaderDataProvider;
import org.eclipse.papyrus.infra.nattable.layer.PapyrusTreeLayer;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.layerstack.RowHeaderLayerStack;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.ITreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.painter.PapyrusIndentedTreeImagePainter;

public class RowHeaderHierarchicalLayerStack
extends RowHeaderLayerStack {
    private Object rowSortModel;
    private ColumnHideShowLayer columnHideShowLayer;
    private TreeLayer treeLayer;
    private ViewportLayer viewportLayer;

    public RowHeaderHierarchicalLayerStack(BodyLayerStack bodyLayer, INattableModelManager tableManager) {
        super(bodyLayer, tableManager);
    }

    @Override
    protected IDataProvider createLabelDataProvider() {
        return new HierarchicalRowLabelHeaderDataProvider(this.tableManager);
    }

    @Override
    protected AbstractLayer createLabelRowHeaderLayer(BodyLayerStack bodyLayerStack, INattableModelManager tableManager) {
        TreeList managedAxis = ((ITreeNattableModelManager)tableManager).getTreeList();
        if (managedAxis instanceof TreeList) {
            GlazedListTreeData glazedListTreeData = new GlazedListTreeData(managedAxis);
            this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)this.getLabelDataLayer());
            this.treeLayer = new PapyrusTreeLayer((IUniqueIndexLayer)this.columnHideShowLayer, (ITreeRowModel<?>)new GlazedListTreeRowModel(glazedListTreeData), new PapyrusIndentedTreeImagePainter(), true);
            this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.treeLayer);
            return new RowHeaderLayer((IUniqueIndexLayer)this.viewportLayer, (ILayer)bodyLayerStack, bodyLayerStack.getSelectionLayer(), false){

                public ICellPainter getCellPainter(int columnPosition, int rowPosition, ILayerCell cell, IConfigRegistry configRegistry) {
                    rowPosition = this.underlyingToLocalRowPosition((ILayer)RowHeaderHierarchicalLayerStack.this.treeLayer, rowPosition);
                    columnPosition = this.underlyingToLocalColumnPosition((ILayer)RowHeaderHierarchicalLayerStack.this.treeLayer, columnPosition);
                    return RowHeaderHierarchicalLayerStack.this.treeLayer.getCellPainter(columnPosition, rowPosition, cell, configRegistry);
                }
            };
        }
        return super.createLabelRowHeaderLayer(bodyLayerStack, tableManager);
    }

    public ColumnHideShowLayer getRowHeaderColumnHideShowLayer() {
        return this.columnHideShowLayer;
    }

    public TreeLayer getTreeLayer() {
        return this.treeLayer;
    }

    public ViewportLayer getViewportLayer() {
        return this.viewportLayer;
    }

    public void dispose() {
        super.dispose();
        this.columnHideShowLayer = null;
        this.treeLayer = null;
    }
}

