/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.dialog.PasteImportStatusDialog;
import org.eclipse.papyrus.infra.nattable.manager.AbstractPasteImportInsertInNattableManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.provider.PasteEObjectAxisInNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.provider.PasteEObjectTreeAxisInNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.provider.PasteInSelectionNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.provider.PasteInSelectionTreeNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.provider.PasteNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.PapyrusNattableStatus;
import org.eclipse.papyrus.infra.nattable.utils.PasteEnablementStatus;
import org.eclipse.papyrus.infra.nattable.utils.PasteHelperUtils;
import org.eclipse.papyrus.infra.nattable.utils.PasteModeEnumeration;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractPasteImportInNattableManager
extends AbstractPasteImportInsertInNattableManager {
    protected boolean isPasteWithOverwrite;
    private boolean isPasteWithOverwriteAlreadyCalculated = false;

    public AbstractPasteImportInNattableManager(INattableModelManager tableManager, CSVPasteHelper pasteHelper, boolean useProgressMonitorDialog, boolean openDialog, int preferredUserAction) {
        super(tableManager, pasteHelper, useProgressMonitorDialog, openDialog, preferredUserAction);
        this.isPasteWithOverwrite = false;
        this.isPasteWithOverwriteAlreadyCalculated = false;
    }

    public AbstractPasteImportInNattableManager(INattableModelManager tableManager, CSVPasteHelper pasteHelper, boolean useProgressMonitorDialog, boolean openDialog, int preferredUserAction, TableSelectionWrapper tableSelectionWrapper) {
        super(tableManager, pasteHelper, useProgressMonitorDialog, openDialog, preferredUserAction, tableSelectionWrapper);
        this.isPasteWithOverwrite = false;
        this.isPasteWithOverwriteAlreadyCalculated = false;
    }

    public AbstractPasteImportInNattableManager(INattableModelManager tableManager, CSVPasteHelper pasteHelper, boolean useProgressMonitorDialog, boolean openDialog, int preferredUserAction, TableSelectionWrapper tableSelectionWrapper, boolean isPasteWithOverwrite) {
        super(tableManager, pasteHelper, useProgressMonitorDialog, openDialog, preferredUserAction, tableSelectionWrapper);
        this.isPasteWithOverwrite = isPasteWithOverwrite;
        this.isPasteWithOverwriteAlreadyCalculated = true;
    }

    @Override
    public IStatus doAction() {
        Status resultStatus = new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_PasteNotYetManaged);
        PasteEnablementStatus pasteStatus = null;
        int maxDepth = Integer.MAX_VALUE;
        boolean useElse = true;
        if (!this.isNeededPasteConfiguration()) {
            if (!this.isPasteWithOverwriteAlreadyCalculated) {
                this.isPasteWithOverwrite = PasteHelperUtils.isPasteWithOverwrite(this.tableManager, this.pasteHelper, this.createReader());
            }
            if (this.isPasteWithOverwrite) {
                MultiStatus status = new MultiStatus("org.eclipse.papyrus.infra.nattable", 0, Messages.AbstractPasteImportInsertInNattableManager_NoPasteConfigurationNeeded, null);
                if (this.tableSelectionWrapper == null) {
                    pasteStatus = this.findPasteModeFromTableConfiguration(this.tableManager);
                    if (PasteModeEnumeration.PASTE_NO_CONFIGURATION != pasteStatus.getPasteMode() && PasteModeEnumeration.CANT_PASTE != pasteStatus.getPasteMode()) {
                        pasteStatus = AbstractPasteImportInNattableManager.findPasteConfigurationAxisIdentifier(this.tableManager);
                    }
                } else if (!this.tableSelectionWrapper.getFullySelectedColumns().isEmpty()) {
                    status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_NoPasteConfigurationNeeded));
                    pasteStatus = new PasteEnablementStatus(status, null);
                } else if (!this.tableSelectionWrapper.getFullySelectedRows().isEmpty()) {
                    pasteStatus = AbstractPasteImportInNattableManager.findPasteConfigurationAxisIdentifier(this.tableManager);
                } else {
                    status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_NoPasteConfigurationNeeded));
                    pasteStatus = new PasteEnablementStatus(null, status);
                }
                useElse = false;
            }
        }
        if (useElse) {
            if (TableHelper.isTreeTable(this.tableManager)) {
                maxDepth = PasteHelperUtils.getMaxDepthToPaste(this.tableManager, this.pasteHelper, this.createReader());
            }
            if ((pasteStatus = this.findPasteModeFromTableConfiguration(this.tableManager)).getPasteMode() == PasteModeEnumeration.PASTE_EOBJECT_ROW_OR_COLUMN) {
                boolean value = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)PasteImportStatusDialog.DIALOG_TITLE, (String)Messages.AbstractPasteImportInsertInNattableManager_WhatAreYouPasting);
                if (value) {
                    pasteStatus.getColumnStatus().add((IStatus)new Status(8, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_TheUserChosesToPasteRows));
                } else {
                    pasteStatus.getRowStatus().add((IStatus)new Status(8, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_TheUserChosesToPasteColumns));
                }
            }
        }
        PasteModeEnumeration pasteMode = pasteStatus.getPasteMode();
        switch (pasteMode) {
            case PASTE_NO_CONFIGURATION: {
                resultStatus = new PapyrusNattableStatus(22, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_NoPasteConfiguration2);
                break;
            }
            case CANT_PASTE: {
                resultStatus = this.createCantPasteStatus(pasteStatus);
                break;
            }
            case PASTE_EOBJECT_ROW: {
                resultStatus = this.pasteRow(this.tableManager, pasteStatus, this.pasteHelper, maxDepth);
                break;
            }
            case PASTE_EOBJECT_COLUMN: {
                resultStatus = this.pasteColumn(this.tableManager, pasteStatus, this.pasteHelper);
                break;
            }
            case PASTE_EOBJECT_ROW_OR_COLUMN: {
                break;
            }
        }
        return resultStatus;
    }

    protected boolean isNeededPasteConfiguration() {
        boolean result = true;
        if (this.tableSelectionWrapper == null || this.tableSelectionWrapper.getFullySelectedColumns().isEmpty() && this.tableSelectionWrapper.getFullySelectedRows().isEmpty() && !this.tableSelectionWrapper.getSelectedCells().isEmpty() || !this.tableSelectionWrapper.getFullySelectedColumns().isEmpty() && this.tableSelectionWrapper.getFullySelectedRows().isEmpty() || this.tableSelectionWrapper.getFullySelectedColumns().isEmpty() && !this.tableSelectionWrapper.getFullySelectedRows().isEmpty()) {
            result = false;
        }
        return result;
    }

    protected IStatus createCantPasteStatus(PasteEnablementStatus pasteStatus) {
        PapyrusNattableStatus resultStatus = new PapyrusNattableStatus(22, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_NoPasteConfiguration2);
        MultiStatus rowStatus = pasteStatus.getRowStatus();
        MultiStatus columnStatus = pasteStatus.getColumnStatus();
        if (rowStatus == null && columnStatus != null) {
            resultStatus = new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", this.getFirstNonOKStatus((IStatus)columnStatus).getMessage());
        } else if (columnStatus == null && rowStatus != null) {
            resultStatus = new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", this.getFirstNonOKStatus((IStatus)rowStatus).getMessage());
        } else if (columnStatus != null && rowStatus != null) {
            StringBuffer buffer = new StringBuffer(Messages.AbstractPasteImportInsertInNattableManager_NoPasteConfiguration);
            buffer.append(Messages.AbstractPasteImportInNattableManager_PasteRowsError);
            buffer.append(this.getFirstNonOKStatus((IStatus)rowStatus).getMessage());
            buffer.append(Messages.AbstractPasteImportInNattableManager_PasteColumnsError);
            buffer.append(this.getFirstNonOKStatus((IStatus)columnStatus).getMessage());
            resultStatus = new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", buffer.toString());
        }
        return resultStatus;
    }

    private IStatus pasteColumn(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper) {
        Status resultStatus = new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_PasteNotYetManaged);
        if (this.tableSelectionWrapper != null) {
            resultStatus = this.pasteColumns(manager, pasteStatus, pasteHelper, this.tableSelectionWrapper);
        }
        return resultStatus;
    }

    private IStatus pasteRow(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper, int maxDepth) {
        IStatus resultStatus = Status.OK_STATUS;
        resultStatus = TableHelper.isTreeTable(manager) ? (this.tableSelectionWrapper != null ? this.pasteTreeRows(manager, pasteStatus, pasteHelper, this.tableSelectionWrapper) : this.pasteTreeRows(manager, pasteStatus, pasteHelper, maxDepth)) : (this.tableSelectionWrapper != null ? this.pasteNormalRows(manager, pasteStatus, pasteHelper, this.tableSelectionWrapper) : this.pasteNormalRows(manager, pasteStatus, pasteHelper));
        return resultStatus;
    }

    private IStatus pasteTreeRows(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper, TableSelectionWrapper tableSelectionWrapper) {
        IStatus status = Status.OK_STATUS;
        if (status.isOK()) {
            status = this.pasteTree(manager, pasteStatus, this.useProgressMonitorDialog, this.createReader(), tableSelectionWrapper, this.getDataSize());
        }
        return status;
    }

    private IStatus pasteTreeRows(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper, int maxDepth) {
        IStatus status = this.checkTreeTableConfiguration(manager, maxDepth);
        if (status.isOK()) {
            status = this.pasteTree(manager, pasteStatus, this.useProgressMonitorDialog, this.createReader(), null, this.getDataSize());
        }
        return status;
    }

    private IStatus pasteNormalRows(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper) {
        Reader reader = this.createReader();
        IStatus status = this.verifyColumnCountOnFirstLine(manager, reader);
        try {
            reader.close();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        if (status.isOK()) {
            status = this.paste(manager, pasteStatus, this.useProgressMonitorDialog, this.createReader(), null, this.getDataSize());
        }
        return status;
    }

    private IStatus pasteNormalRows(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper, TableSelectionWrapper tableSelectionWrapper) {
        Reader reader = this.createReader();
        IStatus status = this.verifyColumnCountOnFirstLine(manager, reader);
        try {
            reader.close();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        if (status.isOK()) {
            status = this.paste(manager, pasteStatus, this.useProgressMonitorDialog, this.createReader(), tableSelectionWrapper, this.getDataSize());
        }
        return status;
    }

    private IStatus pasteColumns(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper, TableSelectionWrapper tableSelectionWrapper) {
        IStatus status = Status.OK_STATUS;
        status = TableHelper.isTreeTable(manager) ? this.pasteTree(manager, pasteStatus, this.useProgressMonitorDialog, this.createReader(), tableSelectionWrapper, this.getDataSize()) : this.paste(manager, pasteStatus, this.useProgressMonitorDialog, this.createReader(), tableSelectionWrapper, this.getDataSize());
        return status;
    }

    private IStatus pasteTree(INattableModelManager manager, PasteEnablementStatus status, boolean useProgressMonitorDialog, Reader reader, TableSelectionWrapper tableSelectionWrapper, long totalSize) {
        IStatus resultStatus = Status.OK_STATUS;
        PasteNattableCommandProvider commandProvider = null;
        if (!this.isPasteWithOverwrite) {
            switch (status.getPasteMode()) {
                case PASTE_EOBJECT_ROW: {
                    commandProvider = new PasteEObjectTreeAxisInNattableCommandProvider(manager, false, reader, this.pasteHelper, totalSize);
                    break;
                }
            }
        } else if (tableSelectionWrapper != null) {
            switch (status.getPasteMode()) {
                case PASTE_EOBJECT_ROW: {
                    commandProvider = new PasteInSelectionTreeNattableCommandProvider(manager, false, false, reader, this.pasteHelper, this.tableSelectionWrapper, this.preferredUserAction, totalSize);
                    break;
                }
                case PASTE_EOBJECT_COLUMN: {
                    commandProvider = new PasteInSelectionTreeNattableCommandProvider(manager, true, false, reader, this.pasteHelper, this.tableSelectionWrapper, this.preferredUserAction, totalSize);
                    break;
                }
            }
        } else {
            commandProvider = new PasteInSelectionTreeNattableCommandProvider(manager, PasteModeEnumeration.PASTE_EOBJECT_COLUMN.equals((Object)status.getPasteMode()), true, reader, this.pasteHelper, this.tableSelectionWrapper, this.preferredUserAction, totalSize);
        }
        if (commandProvider != null) {
            resultStatus = commandProvider.executePasteFromStringCommand(useProgressMonitorDialog, this.openDialog);
        }
        return resultStatus;
    }

    private IStatus paste(INattableModelManager manager, PasteEnablementStatus status, boolean useProgressMonitorDialog, Reader reader, TableSelectionWrapper tableSelectionWrapper, long totalSize) {
        IStatus resultStatus = Status.OK_STATUS;
        PasteNattableCommandProvider commandProvider = null;
        if (!this.isPasteWithOverwrite) {
            switch (status.getPasteMode()) {
                case PASTE_EOBJECT_ROW: {
                    commandProvider = new PasteEObjectAxisInNattableCommandProvider(manager, false, reader, this.pasteHelper, totalSize);
                    break;
                }
            }
        } else if (tableSelectionWrapper != null) {
            switch (status.getPasteMode()) {
                case PASTE_EOBJECT_ROW: {
                    commandProvider = new PasteInSelectionNattableCommandProvider(manager, false, false, reader, this.pasteHelper, tableSelectionWrapper, this.preferredUserAction, totalSize);
                    break;
                }
                case PASTE_EOBJECT_COLUMN: {
                    commandProvider = new PasteInSelectionNattableCommandProvider(manager, true, false, reader, this.pasteHelper, tableSelectionWrapper, this.preferredUserAction, totalSize);
                    break;
                }
            }
        } else {
            commandProvider = new PasteInSelectionNattableCommandProvider(manager, PasteModeEnumeration.PASTE_EOBJECT_COLUMN.equals((Object)status.getPasteMode()), true, reader, this.pasteHelper, tableSelectionWrapper, this.preferredUserAction, totalSize);
        }
        if (commandProvider != null) {
            resultStatus = commandProvider.executePasteFromStringCommand(useProgressMonitorDialog, this.openDialog);
        }
        return resultStatus;
    }
}

