/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Comment;
import org.eclipse.wst.jsdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;

public class JSdoc
extends Comment {
    public static final SimplePropertyDescriptor COMMENT_PROPERTY = new SimplePropertyDescriptor(JSdoc.class, "comment", String.class, true);
    public static final ChildListPropertyDescriptor TAGS_PROPERTY = new ChildListPropertyDescriptor(JSdoc.class, "tags", TagElement.class, true);
    private static final List PROPERTY_DESCRIPTORS_2_0;
    private static final List PROPERTY_DESCRIPTORS_3_0;
    private static final String MINIMAL_DOC_COMMENT = "/** */";
    private String comment = "/** */";
    private ASTNode.NodeList tags = new ASTNode.NodeList(TAGS_PROPERTY);

    static {
        ArrayList properyList = new ArrayList(3);
        JSdoc.createPropertyList(JSdoc.class, properyList);
        JSdoc.addProperty(COMMENT_PROPERTY, properyList);
        JSdoc.addProperty(TAGS_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS_2_0 = JSdoc.reapPropertyList(properyList);
        properyList = new ArrayList(2);
        JSdoc.createPropertyList(JSdoc.class, properyList);
        JSdoc.addProperty(TAGS_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS_3_0 = JSdoc.reapPropertyList(properyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel == 2) {
            return PROPERTY_DESCRIPTORS_2_0;
        }
        return PROPERTY_DESCRIPTORS_3_0;
    }

    JSdoc(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return JSdoc.propertyDescriptors(apiLevel);
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == COMMENT_PROPERTY) {
            if (get) {
                return this.getComment();
            }
            this.setComment((String)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == TAGS_PROPERTY) {
            return this.tags();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final int getNodeType0() {
        return 29;
    }

    @Override
    ASTNode clone0(AST target) {
        JSdoc result = new JSdoc(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        if (this.comment != MINIMAL_DOC_COMMENT) {
            result.setComment(this.getComment());
        }
        result.tags().addAll(ASTNode.copySubtrees(target, this.tags()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChildren(visitor, this.tags);
        }
        visitor.endVisit(this);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String docComment) {
        if (docComment == null) {
            throw new IllegalArgumentException();
        }
        char[] source = docComment.toCharArray();
        Scanner scanner = this.ast.scanner;
        scanner.resetTo(0, source.length);
        scanner.setSource(source);
        try {
            int token;
            boolean onlyOneComment = false;
            while ((token = scanner.getNextToken()) != 70) {
                switch (token) {
                    case 1003: {
                        if (onlyOneComment) {
                            throw new IllegalArgumentException();
                        }
                        onlyOneComment = true;
                        break;
                    }
                    default: {
                        onlyOneComment = false;
                    }
                }
            }
            if (!onlyOneComment) {
                throw new IllegalArgumentException();
            }
        }
        catch (InvalidInputException invalidInputException) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(COMMENT_PROPERTY);
        this.comment = docComment;
        this.postValueChange(COMMENT_PROPERTY);
    }

    public List tags() {
        return this.tags;
    }

    @Override
    int memSize() {
        int size = super.memSize() + 8;
        if (this.comment != MINIMAL_DOC_COMMENT) {
            size += JSdoc.stringSize(this.comment);
        }
        return size;
    }

    @Override
    int treeSize() {
        return this.memSize() + this.tags.listSize();
    }
}

