/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ContextResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
public class ObjectMapperProvider
implements ContextResolver<ObjectMapper> {
    private static final Logger log = LoggerFactory.getLogger(ObjectMapperProvider.class);
    private static final SimpleModule MODULE = new SimpleModule();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public ObjectMapper getContext(Class<?> type) {
        return OBJECT_MAPPER;
    }

    public static ObjectMapper objectMapper() {
        return OBJECT_MAPPER;
    }

    static {
        try {
            MODULE.addSerializer(Set.class, (JsonSerializer)new SetSerializer());
            MODULE.addDeserializer(Set.class, (JsonDeserializer)new SetDeserializer());
            OBJECT_MAPPER.registerModule((Module)MODULE);
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        catch (Throwable t) {
            log.error("Failure during static initialization", t);
            throw t;
        }
    }

    public static class SetDeserializer
    extends JsonDeserializer<Set> {
        public Set<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Map map = (Map)OBJECT_MAPPER.readValue(jp, Map.class);
            return map == null ? null : map.keySet();
        }
    }

    public static class SetSerializer
    extends JsonSerializer<Set> {
        public void serialize(Set value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            Map<Object, Map> map = value == null ? null : value.stream().collect(Collectors.toMap(s -> s, s -> Collections.emptyMap()));
            OBJECT_MAPPER.writeValue(jgen, map);
        }
    }
}

