/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel.properties;

import com.ibm.icu.text.MessageFormat;
import java.util.Map;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.MessagesForProperties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;

public class LabelText
extends LabelAttribute {
    public static final MessageFormat DEFAULT_MESSAGE = new MessageFormat(MessagesForProperties.DefaultLabelMessage_label);
    private MessageFormat fMessageFormat;
    private String[] fPropertyNames;

    public LabelText() {
        this(DEFAULT_MESSAGE, EMPTY_PROPERTY_NAMES_ARRAY);
    }

    public LabelText(String formatPattern, String[] propertyNames) {
        this(new MessageFormat(formatPattern), propertyNames);
    }

    public LabelText(MessageFormat format, String[] propertyNames) {
        this.fMessageFormat = format;
        this.fPropertyNames = propertyNames;
    }

    @Override
    public String[] getPropertyNames() {
        return this.fPropertyNames;
    }

    public MessageFormat getMessageFormat() {
        return this.fMessageFormat;
    }

    public void setMessageFormat(MessageFormat messageFormat) {
        this.fMessageFormat = messageFormat;
    }

    @Override
    public void updateAttribute(ILabelUpdate update, int columnIndex, IStatus status, Map<String, Object> properties) {
        String[] propertyNames = this.getPropertyNames();
        Object[] propertyValues = new Object[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            propertyValues[i] = this.getPropertyValue(propertyNames[i], status, properties);
            ++i;
        }
        try {
            update.setLabel(this.getMessageFormat().format(propertyValues, new StringBuffer(), null).toString(), columnIndex);
        }
        catch (IllegalArgumentException e) {
            update.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 0, "Failed formatting a message for column " + columnIndex + ", for update " + update, (Throwable)e));
        }
    }

    protected Object getPropertyValue(String propertyName, IStatus status, Map<String, Object> properties) {
        return properties.get(propertyName);
    }
}

