/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.ui.wizards;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ptp.internal.rm.jaxb.ui.JAXBUIPlugin;
import org.eclipse.ptp.internal.rm.jaxb.ui.messages.Messages;
import org.eclipse.ptp.internal.rm.jaxb.ui.wizards.JAXBRMConfigurationImportWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.progress.UIJob;

public class JAXBRMConfigurationImportWizard
extends Wizard
implements IImportWizard {
    private JAXBRMConfigurationImportWizardPage mainPage;

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.ConfigurationImportWizardTitle);
        this.setNeedsProgressMonitor(true);
        this.mainPage = new JAXBRMConfigurationImportWizardPage(Messages.ConfigurationImportWizardPageTitle);
        this.mainPage.loadConfigurations();
    }

    public boolean performFinish() {
        new UIJob("targetConfigurations"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
                try {
                    URL selection = JAXBRMConfigurationImportWizard.this.mainPage.getSelectedConfiguration();
                    if (selection != null) {
                        IProject project;
                        String name;
                        block11: {
                            name = JAXBRMConfigurationImportWizard.this.mainPage.getSelectedName();
                            project = JAXBRMConfigurationImportWizard.checkResourceManagersProject((IProgressMonitor)subMon.newChild(10));
                            if (project != null) break block11;
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        try {
                            int createTry = 1;
                            IFile newConfig = project.getFile(String.valueOf(name) + " " + "(" + createTry++ + ")" + ".xml");
                            while (newConfig.exists()) {
                                newConfig = project.getFile(String.valueOf(name) + " " + "(" + createTry++ + ")" + ".xml");
                            }
                            newConfig.create(selection.openStream(), 0, (IProgressMonitor)subMon.newChild(10));
                        }
                        catch (CoreException io) {
                            JAXBUIPlugin.log(io);
                        }
                        catch (IOException io) {
                            JAXBUIPlugin.log(io);
                        }
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
        }.schedule();
        return true;
    }

    private static IProject checkResourceManagersProject(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("targetConfigurations");
        if (!project.exists()) {
            boolean create = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.ResourceManagersNotExist_title, (String)Messages.JAXBRMConfigurationImportWizard_createResourceManagersProject);
            if (!create) {
                return null;
            }
            project.create((IProgressMonitor)subMon.newChild(10));
            if (!project.isOpen()) {
                project.open((IProgressMonitor)subMon.newChild(10));
            }
        }
        return project;
    }
}

