/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching.sourcelookup.advanced;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class FileHashing {
    private static final HasherImpl HASHER = new HasherImpl(5000);

    public static Hasher hasher() {
        return HASHER;
    }

    public static Hasher newHasher() {
        return new HasherImpl(HASHER);
    }

    private static HashCode sha1(File file) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unsupported JVM", e);
        }
        byte[] buf = new byte[4096];
        Throwable throwable = null;
        Object var4_6 = null;
        try (FileInputStream is = new FileInputStream(file);){
            int len;
            while ((len = ((InputStream)is).read(buf)) > 0) {
                digest.update(buf, 0, len);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new HashCode(digest.digest());
    }

    private static class CacheKey {
        public final File file;
        private final long length;
        private final long lastModified;

        public CacheKey(File file) throws IOException {
            this.file = file.getCanonicalFile();
            this.length = file.length();
            this.lastModified = file.lastModified();
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.file.hashCode();
            hash = hash * 31 + (int)this.length;
            hash = hash * 31 + (int)this.lastModified;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.file.equals(other.file) && this.length == other.length && this.lastModified == other.lastModified;
        }
    }

    private static class HashCode {
        private final byte[] bytes;
        private static final char[] hexDigits = "0123456789abcdef".toCharArray();

        public HashCode(byte[] bytes) {
            this.bytes = bytes;
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof HashCode)) {
                return false;
            }
            return Arrays.equals(this.bytes, ((HashCode)obj).bytes);
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder(2 * this.bytes.length);
            byte[] byArray = this.bytes;
            int n = this.bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                sb.append(hexDigits[b >> 4 & 0xF]).append(hexDigits[b & 0xF]);
                ++n2;
            }
            return sb.toString();
        }
    }

    public static interface Hasher {
        public Object hash(File var1);
    }

    private static class HasherImpl
    implements Hasher {
        private final Map<CacheKey, HashCode> cache;

        public HasherImpl(final int cacheSize) {
            this.cache = new LinkedHashMap<CacheKey, HashCode>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<CacheKey, HashCode> eldest) {
                    return this.size() > cacheSize;
                }
            };
        }

        public HasherImpl(HasherImpl initial) {
            this.cache = new LinkedHashMap<CacheKey, HashCode>(initial.cache);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object hash(File file) {
            if (file == null || !file.isFile()) {
                return null;
            }
            try {
                CacheKey cacheKey = new CacheKey(file);
                Map<CacheKey, HashCode> map = this.cache;
                synchronized (map) {
                    HashCode hashCode = this.cache.get(cacheKey);
                    if (hashCode != null) {
                        return hashCode;
                    }
                }
                HashCode hashCode = FileHashing.sha1(file);
                Map<CacheKey, HashCode> map2 = this.cache;
                synchronized (map2) {
                    this.cache.put(cacheKey, hashCode);
                }
                return hashCode;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

