/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.colors.ColorUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;

public class StylePropertiesUtils {
    public static @NonNull Map<@NonNull String, @NonNull Object> updateEventStyleProperties(@Nullable Map<String, Object> styleMap) {
        String symbolType;
        RGBAColor rgba;
        if (styleMap == null) {
            return new HashMap<String, Object>();
        }
        @NonNull HashMap<@NonNull String, @NonNull Object> updatedStyles = new HashMap<String, Object>(styleMap);
        Object object = styleMap.get(ITimeEventStyleStrings.label());
        if (object != null && !styleMap.containsKey("style-name")) {
            updatedStyles.put("style-name", object);
        }
        if ((object = styleMap.get(ITimeEventStyleStrings.heightFactor())) != null && !styleMap.containsKey("height")) {
            updatedStyles.put("height", object);
        }
        if ((object = styleMap.get(ITimeEventStyleStrings.fillStyle())) != null && !styleMap.containsKey("linear-gradient")) {
            if (object.equals(ITimeEventStyleStrings.gradientColorFillStyle())) {
                updatedStyles.put("linear-gradient", true);
            } else {
                updatedStyles.put("linear-gradient", false);
            }
        }
        if ((object = styleMap.get(ITimeEventStyleStrings.fillColor())) != null && object instanceof Integer) {
            rgba = new RGBAColor(((Integer)object).intValue());
            String hexColor = ColorUtils.toHexColor(rgba.getRed(), rgba.getGreen(), rgba.getBlue());
            float opacity = (float)rgba.getAlpha() / 255.0f;
            if (!styleMap.containsKey("background-color")) {
                updatedStyles.put("background-color", hexColor);
            }
            if (!styleMap.containsKey("color")) {
                updatedStyles.put("color", hexColor);
            }
            if (!styleMap.containsKey("opacity")) {
                updatedStyles.put("opacity", Float.valueOf(opacity));
            }
        }
        if ((object = styleMap.get(ITimeEventStyleStrings.fillColorEnd())) != null && !styleMap.containsKey("linear-gradient-color-end") && object instanceof Integer) {
            rgba = new RGBAColor(((Integer)object).intValue());
            updatedStyles.put("linear-gradient-color-end", ColorUtils.toHexColor(rgba.getRed(), rgba.getGreen(), rgba.getBlue()));
        }
        if ((object = styleMap.get(ITimeEventStyleStrings.borderEnable())) != null && !styleMap.containsKey("border-style")) {
            if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                updatedStyles.put("border-style", "solid");
            } else {
                updatedStyles.put("border-style", "none");
            }
        }
        if ((object = styleMap.get(ITimeEventStyleStrings.borderColor())) != null && !styleMap.containsKey("border-color") && object instanceof Integer) {
            rgba = new RGBAColor(((Integer)object).intValue());
            updatedStyles.put("border-color", ColorUtils.toHexColor(rgba.getRed(), rgba.getGreen(), rgba.getBlue()));
        }
        if ((object = styleMap.get(ITimeEventStyleStrings.borderThickness())) != null && !styleMap.containsKey("border-width")) {
            updatedStyles.put("border-width", object);
        }
        if ((object = styleMap.get(ITimeEventStyleStrings.symbolStyle())) != null && !styleMap.containsKey("symbol-type") && (symbolType = ITimeEventStyleStrings.SYMBOL_TYPES.get(object)) != null) {
            updatedStyles.put("symbol-type", symbolType);
        }
        return updatedStyles;
    }
}

