/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.ui.handlers;

import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.transformation.debug.model.TransformationThread;
import org.eclipse.viatra.transformation.debug.model.breakpoint.ConditionalTransformationBreakpoint;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationState;
import org.eclipse.viatra.transformation.debug.ui.handlers.ConditionalBreakpointDialog;
import org.eclipse.viatra.transformation.debug.util.ViatraDebuggerUtil;

public class AddConditionalBreakpointHandler
extends AbstractHandler {
    @Inject
    private Injector injector;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof TransformationState) {
                TransformationState state = (TransformationState)((IStructuredSelection)selection).getFirstElement();
                TransformationThread thread = ViatraDebuggerUtil.getThread((TransformationState)state);
                ConditionalBreakpointDialog dialog = new ConditionalBreakpointDialog(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), this.injector);
                dialog.create();
                dialog.open();
                if (dialog.getReturnCode() == 0 && thread != null) {
                    String results = dialog.getResults();
                    ConditionalTransformationBreakpoint breakpoint = new ConditionalTransformationBreakpoint(results);
                    breakpoint.setMarker(thread.getTransformationType().getResource().createMarker(breakpoint.getMarkerIdentifier()));
                    breakpoint.setEnabled(true);
                    DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)breakpoint);
                }
            }
        }
        catch (CoreException e) {
            throw new ExecutionException("Error while adding conditional breakpoint", (Throwable)e);
        }
        return null;
    }
}

