/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ssh.internal.core;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ssh.internal.core.Activator;
import org.eclipse.jsch.core.IJSchService;

public class ChannelPool {
    private final long inactivityTimeout;
    private final String userName;
    private final int port;
    private final String hostName;
    private String password;
    private Session session;
    private final List<ChannelSftp> freeChannels = new ArrayList<ChannelSftp>();
    private final Map<ChannelSftp, ChannelUsageInfo> usedChannels = new IdentityHashMap<ChannelSftp, ChannelUsageInfo>();
    private static boolean DEBUG = false;
    private final Object channelNotifier = new Object();
    private final Object lock = new Object();
    private static final String CHANNEL_IS_NOT_OPENED = "channel is not opened.";
    private static final long loadedAt = System.currentTimeMillis();

    public ChannelPool(String userName, String hostName, int port, long inactivityTimeout) {
        this.userName = userName;
        this.hostName = hostName;
        this.port = port;
        this.inactivityTimeout = inactivityTimeout;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectSession() throws JSchException {
        Object object = this.lock;
        synchronized (object) {
            if (this.session == null) {
                IJSchService service = Activator.getDefault().getJSch();
                this.session = service.createSession(this.hostName, this.port, this.userName);
                this.session.setTimeout(0);
                this.session.setServerAliveInterval(300000);
                this.session.setServerAliveCountMax(6);
                this.session.setPassword(this.password);
                LocalUserInfo ui = new LocalUserInfo();
                this.session.setUserInfo((UserInfo)ui);
            }
            if (!this.session.isConnected()) {
                if (DEBUG) {
                    this.log("session.connect()");
                }
                this.session.connect(60000);
                if (DEBUG) {
                    this.log("...connected");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChannelSftp acquireChannel(Object context, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                return this.acquireChannel(context);
            }
            catch (JSchException e) {
                if (this.isOutOfChannels(e) && this.tryCloseOldChannels()) continue;
                if (System.currentTimeMillis() - start > timeout) {
                    Activator.error("Failed to create direct connection", e);
                    return null;
                }
                if (DEBUG) {
                    this.log(" <sleep>");
                }
                try {
                    Object object = this.channelNotifier;
                    synchronized (object) {
                        this.channelNotifier.wait(1000L);
                    }
                }
                catch (InterruptedException e1) {
                    return null;
                }
            }
        }
    }

    private boolean isOutOfChannels(JSchException e) {
        return CHANNEL_IS_NOT_OPENED.equals(e.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChannelSftp acquireChannel(Object context) throws JSchException {
        this.connectSession();
        if (DEBUG) {
            this.log("<acquireChannel> " + context);
        }
        Object object = this.lock;
        synchronized (object) {
            while (!this.freeChannels.isEmpty()) {
                ChannelSftp channel = this.freeChannels.remove(this.freeChannels.size() - 1);
                if (!channel.isConnected()) continue;
                this.usedChannels.put(channel, this.createUsageInfo(context));
                return channel;
            }
        }
        ChannelSftp channel = (ChannelSftp)this.session.openChannel("sftp");
        if (!channel.isConnected()) {
            if (DEBUG) {
                this.log("channel.connect()");
            }
            channel.connect(10000);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.usedChannels.put(channel, this.createUsageInfo(context));
        }
        return channel;
    }

    private ChannelUsageInfo createUsageInfo(Object context) {
        return new ChannelUsageInfo(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseChannel(ChannelSftp channel) {
        if (DEBUG) {
            this.log("<releaseChannel>");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.usedChannels.remove(channel) != null) {
                this.freeChannels.add(channel);
            } else {
                channel.disconnect();
            }
        }
        object = this.channelNotifier;
        synchronized (object) {
            this.channelNotifier.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyChannel(ChannelSftp channel) {
        if (DEBUG) {
            this.log("<destroyChannel>");
        }
        Object object = this.lock;
        synchronized (object) {
            this.usedChannels.remove(channel);
        }
        channel.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryCloseOldChannels() {
        Object object = this.lock;
        synchronized (object) {
            block6: {
                long currentTime;
                if (this.usedChannels.isEmpty()) break block6;
                ChannelSftp selectedChannel = null;
                ChannelUsageInfo selectedUsageInfo = null;
                long selectedLastActivity = 0L;
                for (Map.Entry<ChannelSftp, ChannelUsageInfo> entry : this.usedChannels.entrySet()) {
                    long lastActivity;
                    ChannelUsageInfo usageInfo = entry.getValue();
                    if (!this.canClose(usageInfo.context) || (lastActivity = this.getLastActivity(usageInfo.context)) == Long.MIN_VALUE || selectedChannel != null && lastActivity >= selectedLastActivity) continue;
                    selectedChannel = entry.getKey();
                    selectedUsageInfo = usageInfo;
                    selectedLastActivity = lastActivity;
                }
                if (selectedChannel == null || (currentTime = System.currentTimeMillis()) - selectedLastActivity <= this.inactivityTimeout) break block6;
                Activator.warn("Close active channel \"" + selectedUsageInfo.context + "\" created " + (currentTime - selectedUsageInfo.timestamp) + "ms ago, lastActivity=" + (currentTime - selectedLastActivity) + "ms ago");
                if (DEBUG) {
                    this.log(" channel.disconnect() " + selectedUsageInfo.context);
                }
                selectedChannel.disconnect();
                this.usedChannels.remove(selectedChannel);
                return true;
            }
        }
        return false;
    }

    protected boolean canClose(Object context) {
        return false;
    }

    protected long getLastActivity(Object context) {
        return Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            for (ChannelSftp channelSftp : this.freeChannels) {
                if (DEBUG) {
                    this.log("channel.disconnect()");
                }
                channelSftp.disconnect();
            }
            this.freeChannels.clear();
            for (Map.Entry entry : this.usedChannels.entrySet()) {
                ChannelUsageInfo usageInfo = (ChannelUsageInfo)entry.getValue();
                Activator.warn("Close active channel \"" + usageInfo.context + "\" created " + (System.currentTimeMillis() - usageInfo.timestamp) + "ms ago");
                if (DEBUG) {
                    this.log(" channel.disconnect() " + usageInfo.context);
                }
                ((ChannelSftp)entry.getKey()).disconnect();
            }
            this.usedChannels.clear();
            if (this.session != null) {
                if (DEBUG) {
                    this.log("session.disconnect()");
                }
                this.session.disconnect();
                this.session = null;
            }
        }
    }

    protected void log(Object message) {
        System.out.println("[" + (System.currentTimeMillis() - loadedAt) + "] " + message);
    }

    public boolean isConnected() {
        return this.session != null && this.session.isConnected();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelPool other = (ChannelPool)obj;
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    private static class ChannelUsageInfo {
        final Object context;
        final long timestamp;

        public ChannelUsageInfo(Object context) {
            this.context = context;
            this.timestamp = System.currentTimeMillis();
        }
    }

    private final class LocalUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private LocalUserInfo() {
        }

        public void showMessage(String arg0) {
        }

        public boolean promptYesNo(String arg0) {
            return false;
        }

        public boolean promptPassword(String arg0) {
            return true;
        }

        public boolean promptPassphrase(String arg0) {
            return false;
        }

        public String getPassword() {
            return ChannelPool.this.password;
        }

        public String getPassphrase() {
            return "";
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            String[] stringArray;
            String p = ChannelPool.this.password;
            if (p != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = p;
            } else {
                stringArray = null;
            }
            return stringArray;
        }
    }
}

