/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.callhierarchy.CElementSet;
import org.eclipse.cdt.internal.ui.callhierarchy.CHMultiDefNode;
import org.eclipse.cdt.internal.ui.callhierarchy.CHNode;
import org.eclipse.cdt.internal.ui.callhierarchy.CHQueries;
import org.eclipse.cdt.internal.ui.callhierarchy.CHReferenceInfo;
import org.eclipse.cdt.internal.ui.callhierarchy.CHViewPart;
import org.eclipse.cdt.internal.ui.callhierarchy.CalledByResult;
import org.eclipse.cdt.internal.ui.callhierarchy.CallsToResult;
import org.eclipse.cdt.internal.ui.viewsupport.AsyncTreeContentProvider;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.internal.ui.viewsupport.WorkingSetFilterUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.ICHEContentProvider;
import org.eclipse.cdt.ui.ICHENode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class CHContentProvider
extends AsyncTreeContentProvider {
    private static final IProgressMonitor NPM = new NullProgressMonitor();
    private boolean fComputeReferencedBy = true;
    private WorkingSetFilterUI fFilter;
    private CHViewPart fView;

    public CHContentProvider(CHViewPart view, Display disp) {
        super(disp);
        this.fView = view;
    }

    @Override
    public Object getParent(Object element) {
        if (element instanceof CHNode) {
            CHNode node = (CHNode)element;
            return node.getParent();
        }
        return super.getParent(element);
    }

    @Override
    protected Object[] syncronouslyComputeChildren(Object parentElement) {
        if (parentElement instanceof CHMultiDefNode) {
            return ((CHMultiDefNode)parentElement).getChildNodes();
        }
        if (parentElement instanceof CHNode) {
            CHNode node = (CHNode)parentElement;
            if (node.isRecursive() || node.getRepresentedDeclaration() == null) {
                return NO_CHILDREN;
            }
            if (this.fComputeReferencedBy ? node.isInitializer() : node.isVariableOrEnumerator() || node.isMacro()) {
                return NO_CHILDREN;
            }
        }
        return null;
    }

    @Override
    protected Object[] asyncronouslyComputeChildren(Object parentElement, IProgressMonitor monitor) {
        try {
            ICHEContentProvider[] providers = this.fView.getContentProviders();
            if (providers != null) {
                ICHEContentProvider[] iCHEContentProviderArray = providers;
                int n = providers.length;
                int n2 = 0;
                while (n2 < n) {
                    ICHEContentProvider provider = iCHEContentProviderArray[n2];
                    Object[] object = provider.asyncComputeExtendedRoot(parentElement);
                    if (object != null) {
                        return object;
                    }
                    ++n2;
                }
            }
            if (parentElement instanceof ICHENode) {
                return this.asyncComputeRoot(((ICHENode)parentElement).getRepresentedDeclaration());
            }
            if (parentElement instanceof ICElement) {
                return this.asyncComputeRoot((ICElement)parentElement);
            }
            if (parentElement instanceof CHNode) {
                CHNode node = (CHNode)parentElement;
                if (this.fComputeReferencedBy) {
                    return this.asyncronouslyComputeReferencedBy(node);
                }
                return this.asyncronouslyComputeRefersTo(node);
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return NO_CHILDREN;
    }

    private Object[] asyncComputeRoot(ICElement input) throws CoreException, InterruptedException {
        IIndex index = CCorePlugin.getIndexManager().getIndex(input.getCProject(), 67);
        index.acquireReadLock();
        try {
            ICElement[] defs;
            IIndexBinding methodBinding;
            IIndexName methodName;
            ICElement element = input;
            if (CHQueries.isExternal(element)) {
                ITranslationUnit tu = CModelUtil.getTranslationUnit(element);
                Object[] objectArray = new Object[]{new CHNode(null, tu, 0L, element, -1)};
                return objectArray;
            }
            if (!IndexUI.isIndexed(index, input)) {
                this.getDisplay().asyncExec(() -> this.fView.reportNotIndexed(input));
            } else {
                ICElement finalElement = element = IndexUI.attemptConvertionToHandle(index, input);
                this.getDisplay().asyncExec(() -> this.fView.reportInputReplacement(input, finalElement));
            }
            ITranslationUnit tu = CModelUtil.getTranslationUnit(element);
            if (!this.fComputeReferencedBy && element instanceof IMethod && (methodName = IndexUI.elementToName(index, element)) != null && (methodBinding = index.findBinding((IName)methodName)) instanceof ICPPMethod && (defs = CHQueries.findOverriders(index, (ICPPMethod)methodBinding)) != null && defs.length > 0) {
                Object[] objectArray = new Object[]{new CHMultiDefNode(null, tu, 0L, defs, methodBinding.getLinkage().getLinkageID())};
                return objectArray;
            }
            Object[] objectArray = new Object[]{new CHNode(null, tu, 0L, element, -1)};
            return objectArray;
        }
        finally {
            index.releaseReadLock();
        }
    }

    private Object[] asyncronouslyComputeReferencedBy(CHNode parent) throws CoreException, InterruptedException {
        ICProject[] scope = CoreModel.getDefault().getCModel().getCProjects();
        IIndex index = CCorePlugin.getIndexManager().getIndex(scope, 64);
        index.acquireReadLock();
        try {
            Object[] objectArray = CHQueries.findCalledBy(this, parent, index, NPM);
            return objectArray;
        }
        finally {
            index.releaseReadLock();
        }
    }

    private Object[] asyncronouslyComputeRefersTo(CHNode parent) throws CoreException, InterruptedException {
        ICProject[] scope = CoreModel.getDefault().getCModel().getCProjects();
        IIndex index = CCorePlugin.getIndexManager().getIndex(scope, 64);
        index.acquireReadLock();
        try {
            Object[] objectArray = CHQueries.findCalls(this, parent, index, NPM);
            return objectArray;
        }
        finally {
            index.releaseReadLock();
        }
    }

    public void setComputeReferencedBy(boolean value) {
        this.fComputeReferencedBy = value;
    }

    public boolean getComputeReferencedBy() {
        return this.fComputeReferencedBy;
    }

    public void setWorkingSetFilter(WorkingSetFilterUI filterUI) {
        this.fFilter = filterUI;
        this.recompute();
    }

    CHNode[] createNodes(CHNode node, CalledByResult result) throws CoreException {
        ICElement[] elements;
        ArrayList<CHNode> nodes = new ArrayList<CHNode>();
        ICElement[] iCElementArray = elements = result.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexName[] refs;
            ICElement element = iCElementArray[n2];
            if (element != null && (this.fFilter == null || this.fFilter.isPartOfWorkingSet(element)) && (refs = result.getReferences(element)) != null && refs.length > 0) {
                CHNode newNode = this.createRefbyNode(node, element, refs);
                nodes.add(newNode);
            }
            ++n2;
        }
        return nodes.toArray(new CHNode[nodes.size()]);
    }

    private CHNode createRefbyNode(CHNode parent, ICElement element, IIndexName[] refs) throws CoreException {
        ITranslationUnit tu = CModelUtil.getTranslationUnit(element);
        IIndexFile file = refs[0].getFile();
        CHNode node = new CHNode(parent, tu, file.getTimestamp(), element, file.getLinkageID());
        if (element instanceof IVariable || element instanceof IEnumerator) {
            node.setInitializer(true);
        }
        boolean readAccess = false;
        boolean writeAccess = false;
        IIndexName[] iIndexNameArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexName reference = iIndexNameArray[n2];
            node.addReference(new CHReferenceInfo(reference.getNodeOffset(), reference.getNodeLength()));
            readAccess = readAccess || reference.isReadAccess();
            writeAccess = writeAccess || reference.isWriteAccess();
            ++n2;
        }
        node.setRWAccess(readAccess, writeAccess);
        node.sortReferencesByOffset();
        return node;
    }

    CHNode[] createNodes(CHNode node, CallsToResult callsTo) throws CoreException {
        CElementSet[] elementSets;
        ITranslationUnit tu = CModelUtil.getTranslationUnit(node.getRepresentedDeclaration());
        ArrayList<CHNode> result = new ArrayList<CHNode>();
        CElementSet[] cElementSetArray = elementSets = callsTo.getElementSets();
        int n = elementSets.length;
        int n2 = 0;
        while (n2 < n) {
            CElementSet elementSet = cElementSetArray[n2];
            CElementSet set = elementSet;
            if (!set.isEmpty()) {
                IIndexName[] refs = callsTo.getReferences(set);
                ICElement[] elements = set.getElements(this.fFilter);
                if (elements.length > 0) {
                    CHNode childNode = this.createReftoNode(node, tu, elements, refs);
                    result.add(childNode);
                }
            }
            ++n2;
        }
        return result.toArray(new CHNode[result.size()]);
    }

    private CHNode createReftoNode(CHNode parent, ITranslationUnit tu, ICElement[] elements, IIndexName[] references) throws CoreException {
        assert (elements.length > 0);
        IIndexFile file = references[0].getFile();
        long timestamp = file.getTimestamp();
        int linkageID = file.getLinkageID();
        CHNode node = elements.length == 1 ? new CHNode(parent, tu, timestamp, elements[0], linkageID) : new CHMultiDefNode(parent, tu, timestamp, elements, linkageID);
        boolean readAccess = false;
        boolean writeAccess = false;
        IIndexName[] iIndexNameArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexName reference = iIndexNameArray[n2];
            node.addReference(new CHReferenceInfo(reference.getNodeOffset(), reference.getNodeLength()));
            readAccess = readAccess || reference.isReadAccess();
            writeAccess = writeAccess || reference.isWriteAccess();
            ++n2;
        }
        node.sortReferencesByOffset();
        node.setRWAccess(readAccess, writeAccess);
        return node;
    }
}

