/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.ArtifactRef;
import org.eclipse.m2e.core.embedder.ArtifactRepositoryRef;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;

public class MavenProjectFacade
implements IMavenProjectFacade,
Serializable {
    private static final long serialVersionUID = -3648172776786224087L;
    private static final String CTX_EXECUTION_PLANS = String.valueOf(MavenProjectFacade.class.getName()) + "/executionPlans";
    private static final String CTX_SETUP_EXECUTIONS = String.valueOf(MavenProjectFacade.class.getName()) + "/setupExecutions";
    public static final String PROP_LIFECYCLE_MAPPING = String.valueOf(MavenProjectFacade.class.getName()) + "/lifecycleMapping";
    public static final String PROP_CONFIGURATORS = String.valueOf(MavenProjectFacade.class.getName()) + "/configurators";
    private final ProjectRegistryManager manager;
    private final IFile pom;
    private final File pomFile;
    private final ResolverConfiguration resolverConfiguration;
    private final long[] timestamp;
    private final ArtifactKey artifactKey;
    private final List<String> modules;
    private final String packaging;
    private final IPath[] resourceLocations;
    private final IPath[] testResourceLocations;
    private final IPath[] compileSourceLocations;
    private final IPath[] testCompileSourceLocations;
    private final IPath outputLocation;
    private final IPath testOutputLocation;
    private final String finalName;
    private final Set<ArtifactRepositoryRef> artifactRepositories;
    private final Set<ArtifactRepositoryRef> pluginArtifactRepositories;
    private Set<ArtifactRef> artifacts;
    private String lifecycleMappingId;
    private Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mojoExecutionMapping;
    private transient Map<String, Object> sessionProperties;

    public MavenProjectFacade(ProjectRegistryManager manager, IFile pom, MavenProject mavenProject, ResolverConfiguration resolverConfiguration) {
        this.manager = manager;
        this.pom = pom;
        this.pomFile = ProjectRegistryManager.toJavaIoFile(pom);
        this.resolverConfiguration = resolverConfiguration;
        this.artifactKey = new ArtifactKey(mavenProject.getArtifact());
        this.packaging = mavenProject.getPackaging();
        this.modules = mavenProject.getModules();
        this.resourceLocations = MavenProjectUtils.getResourceLocations(this.getProject(), mavenProject.getResources());
        this.testResourceLocations = MavenProjectUtils.getResourceLocations(this.getProject(), mavenProject.getTestResources());
        this.compileSourceLocations = MavenProjectUtils.getSourceLocations(this.getProject(), mavenProject.getCompileSourceRoots());
        this.testCompileSourceLocations = MavenProjectUtils.getSourceLocations(this.getProject(), mavenProject.getTestCompileSourceRoots());
        IPath fullPath = this.getProject().getFullPath();
        IPath path = this.getProjectRelativePath(mavenProject.getBuild().getOutputDirectory());
        this.outputLocation = path != null ? fullPath.append(path) : null;
        path = this.getProjectRelativePath(mavenProject.getBuild().getTestOutputDirectory());
        this.testOutputLocation = path != null ? fullPath.append(path) : null;
        this.finalName = mavenProject.getBuild().getFinalName();
        this.artifactRepositories = new LinkedHashSet<ArtifactRepositoryRef>();
        for (ArtifactRepository repository : mavenProject.getRemoteArtifactRepositories()) {
            this.artifactRepositories.add(new ArtifactRepositoryRef(repository));
        }
        this.pluginArtifactRepositories = new LinkedHashSet<ArtifactRepositoryRef>();
        for (ArtifactRepository repository : mavenProject.getPluginArtifactRepositories()) {
            this.pluginArtifactRepositories.add(new ArtifactRepositoryRef(repository));
        }
        this.timestamp = new long[ProjectRegistryManager.METADATA_PATH.size() + 1];
        IProject project = this.getProject();
        int i = 0;
        for (IPath iPath : ProjectRegistryManager.METADATA_PATH) {
            this.timestamp[i] = MavenProjectFacade.getModificationStamp(project.getFile(iPath));
            ++i;
        }
        this.timestamp[this.timestamp.length - 1] = MavenProjectFacade.getModificationStamp(pom);
    }

    public MavenProjectFacade(MavenProjectFacade other) {
        this.manager = other.manager;
        this.pom = other.pom;
        this.pomFile = other.pomFile;
        this.resolverConfiguration = other.resolverConfiguration;
        this.artifactKey = other.artifactKey;
        this.packaging = other.packaging;
        this.modules = new ArrayList<String>(other.modules);
        this.resourceLocations = MavenProjectFacade.arrayCopy(other.resourceLocations);
        this.testResourceLocations = MavenProjectFacade.arrayCopy(other.testResourceLocations);
        this.compileSourceLocations = MavenProjectFacade.arrayCopy(other.compileSourceLocations);
        this.testCompileSourceLocations = MavenProjectFacade.arrayCopy(other.testCompileSourceLocations);
        this.outputLocation = other.outputLocation;
        this.testOutputLocation = other.testOutputLocation;
        this.finalName = other.finalName;
        this.artifactRepositories = new LinkedHashSet<ArtifactRepositoryRef>(other.artifactRepositories);
        this.pluginArtifactRepositories = new LinkedHashSet<ArtifactRepositoryRef>(other.pluginArtifactRepositories);
        this.timestamp = Arrays.copyOf(other.timestamp, other.timestamp.length);
    }

    private static <T> T[] arrayCopy(T[] a) {
        return Arrays.copyOf(a, a.length);
    }

    @Override
    public IPath[] getResourceLocations() {
        return this.resourceLocations;
    }

    @Override
    public IPath[] getTestResourceLocations() {
        return this.testResourceLocations;
    }

    @Override
    public IPath[] getCompileSourceLocations() {
        return this.compileSourceLocations;
    }

    @Override
    public IPath[] getTestCompileSourceLocations() {
        return this.testCompileSourceLocations;
    }

    @Override
    public IPath getProjectRelativePath(String resourceLocation) {
        return MavenProjectUtils.getProjectRelativePath(this.getProject(), resourceLocation);
    }

    @Override
    public IPath getOutputLocation() {
        return this.outputLocation;
    }

    @Override
    public IPath getTestOutputLocation() {
        return this.testOutputLocation;
    }

    @Override
    public String getFinalName() {
        return this.finalName;
    }

    @Override
    public IPath getFullPath() {
        return this.getProject().getFullPath();
    }

    @Override
    public MavenProject getMavenProject(IProgressMonitor monitor) throws CoreException {
        return this.manager.getMavenProject(this, monitor);
    }

    @Override
    public MavenProject getMavenProject() {
        return this.manager.getMavenProject(this);
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public IProject getProject() {
        return this.pom.getProject();
    }

    @Override
    public IFile getPom() {
        return this.pom;
    }

    @Override
    public File getPomFile() {
        return this.pomFile;
    }

    @Override
    public IPath getFullPath(File file) {
        return MavenProjectUtils.getFullPath(this.getProject(), file);
    }

    @Override
    public List<String> getMavenProjectModules() {
        return this.modules;
    }

    @Override
    public Set<ArtifactRef> getMavenProjectArtifacts() {
        return this.artifacts;
    }

    void setMavenProjectArtifacts(MavenProject mavenProject) {
        this.artifacts = Collections.unmodifiableSet(ArtifactRef.fromArtifact(mavenProject.getArtifacts()));
    }

    @Override
    public ResolverConfiguration getResolverConfiguration() {
        return this.resolverConfiguration;
    }

    @Override
    public boolean isStale() {
        IProject project = this.getProject();
        int i = 0;
        for (IPath iPath : ProjectRegistryManager.METADATA_PATH) {
            if (this.timestamp[i] != MavenProjectFacade.getModificationStamp(project.getFile(iPath))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static long getModificationStamp(IFile file) {
        return file.getLocalTimeStamp() + file.getModificationStamp();
    }

    @Override
    public ArtifactKey getArtifactKey() {
        return this.artifactKey;
    }

    @Override
    public synchronized void setSessionProperty(String key, Object value) {
        if (this.sessionProperties == null) {
            this.sessionProperties = new HashMap<String, Object>();
        }
        if (value != null) {
            this.sessionProperties.put(key, value);
        } else {
            this.sessionProperties.remove(key);
        }
    }

    @Override
    public synchronized Object getSessionProperty(String key) {
        return this.sessionProperties != null ? this.sessionProperties.get(key) : null;
    }

    @Override
    public Set<ArtifactRepositoryRef> getArtifactRepositoryRefs() {
        return this.artifactRepositories;
    }

    @Override
    public Set<ArtifactRepositoryRef> getPluginArtifactRepositoryRefs() {
        return this.pluginArtifactRepositories;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getProject().toString()).append(": ").append(this.getArtifactKey().toString());
        return sb.toString();
    }

    @Override
    public String getLifecycleMappingId() {
        return this.lifecycleMappingId;
    }

    public void setLifecycleMappingId(String lifecycleMappingId) {
        this.lifecycleMappingId = lifecycleMappingId;
    }

    @Override
    public Map<MojoExecutionKey, List<IPluginExecutionMetadata>> getMojoExecutionMapping() {
        return this.mojoExecutionMapping;
    }

    public void setMojoExecutionMapping(Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mojoExecutionMapping) {
        this.mojoExecutionMapping = mojoExecutionMapping;
    }

    private Map<String, List<MojoExecution>> getExecutionPlans(IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = this.getMavenProject(monitor);
        Map<String, List<MojoExecution>> executionPlans = (Map<String, List<MojoExecution>>)MavenProjectFacade.getContextValue(mavenProject, CTX_EXECUTION_PLANS);
        if (executionPlans == null) {
            executionPlans = this.manager.calculateExecutionPlans(this.pom, mavenProject, monitor);
            mavenProject.setContextValue(CTX_EXECUTION_PLANS, executionPlans);
        }
        return executionPlans;
    }

    private static <T> T getContextValue(MavenProject mavenProject, String key) {
        return (T)mavenProject.getContextValue(key);
    }

    private Map<MojoExecutionKey, MojoExecution> getSetupMojoExecutions(IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = this.getMavenProject(monitor);
        LinkedHashMap executionPlans = (LinkedHashMap)MavenProjectFacade.getContextValue(mavenProject, CTX_SETUP_EXECUTIONS);
        if (executionPlans == null) {
            executionPlans = new LinkedHashMap();
            mavenProject.setContextValue(CTX_SETUP_EXECUTIONS, executionPlans);
        }
        return executionPlans;
    }

    @Override
    public MojoExecution getMojoExecution(MojoExecutionKey mojoExecutionKey, IProgressMonitor monitor) throws CoreException {
        Map<MojoExecutionKey, MojoExecution> setupMojoExecutions = this.getSetupMojoExecutions(monitor);
        MojoExecution execution = setupMojoExecutions.get(mojoExecutionKey);
        if (execution == null) {
            for (MojoExecution _execution : this.getMojoExecutions(monitor)) {
                if (!mojoExecutionKey.match(_execution)) continue;
                execution = this.manager.setupMojoExecution(this, _execution, monitor);
                break;
            }
            this.putSetupMojoExecution(setupMojoExecutions, mojoExecutionKey, execution);
        }
        return execution;
    }

    private void putSetupMojoExecution(Map<MojoExecutionKey, MojoExecution> setupMojoExecutions, MojoExecutionKey mojoExecutionKey, MojoExecution execution) {
        if (execution != null) {
            setupMojoExecutions.put(mojoExecutionKey, execution);
        }
    }

    @Override
    public List<MojoExecution> getMojoExecutions(String groupId, String artifactId, IProgressMonitor monitor, String ... goals) throws CoreException {
        ArrayList<MojoExecution> result = new ArrayList<MojoExecution>();
        List<MojoExecution> _executions = this.getMojoExecutions(monitor);
        if (_executions != null) {
            for (MojoExecution _execution : _executions) {
                if (!groupId.equals(_execution.getGroupId()) || !artifactId.equals(_execution.getArtifactId()) || !MavenProjectFacade.contains(goals, _execution.getGoal())) continue;
                MojoExecutionKey _key = new MojoExecutionKey(_execution);
                Map<MojoExecutionKey, MojoExecution> setupMojoExecutions = this.getSetupMojoExecutions(monitor);
                MojoExecution execution = setupMojoExecutions.get(_key);
                if (execution == null) {
                    execution = this.manager.setupMojoExecution(this, _execution, monitor);
                    this.putSetupMojoExecution(setupMojoExecutions, _key, execution);
                }
                result.add(execution);
            }
        }
        return result;
    }

    private static boolean contains(String[] goals, String goal) {
        String[] stringArray = goals;
        int n = goals.length;
        int n2 = 0;
        while (n2 < n) {
            String goal2 = stringArray[n2];
            if (goal2.equals(goal)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public List<MojoExecution> getMojoExecutions() {
        try {
            return this.getMojoExecutions(null);
        }
        catch (CoreException ex) {
            return null;
        }
    }

    public List<MojoExecution> getMojoExecutions(IProgressMonitor monitor) throws CoreException {
        Map<String, List<MojoExecution>> executionPlans = this.getExecutionPlans(monitor);
        if (executionPlans == null) {
            return null;
        }
        ArrayList<MojoExecution> mojoExecutions = new ArrayList<MojoExecution>();
        for (List<MojoExecution> executionPlan : executionPlans.values()) {
            if (executionPlan == null) continue;
            mojoExecutions.addAll(executionPlan);
        }
        return mojoExecutions;
    }

    public List<MojoExecution> getExecutionPlan(String lifecycle, IProgressMonitor monitor) throws CoreException {
        Map<String, List<MojoExecution>> executionPlans = this.getExecutionPlans(monitor);
        return executionPlans != null ? executionPlans.get(lifecycle) : null;
    }
}

