/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.internal.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.datatools.sqltools.plan.internal.PlanViewPlugin;
import org.eclipse.datatools.sqltools.plan.internal.util.ILogger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class Images {
    private static ILogger _log = PlanViewPlugin.getLogger(null);
    private static final String NAME_PREFIX = "org.eclipse.datatools.sqltools.result";
    private static final int NAME_PREFIX_LENGTH = "org.eclipse.datatools.sqltools.result".length();
    private static URL _baseURL = null;
    private static ImageRegistry fgImageRegistry = null;
    private static HashMap fgAvoidSWTErrorMap = new HashMap();
    public static final String IMG_HORIZONTAL_PLAN_VIEW = "org.eclipse.datatools.sqltools.resulthorizontal_plan_view.gif";
    public static final ImageDescriptor DESC_HORIZONTAL_PLAN_VIEW;
    public static final String IMG_VERTICAL_PLAN_VIEW = "org.eclipse.datatools.sqltools.resultvertical_plan_view.gif";
    public static final ImageDescriptor DESC_VERTICAL_PLAN_VIEW;
    public static final String IMG_CURRENT_OPERATOR = "org.eclipse.datatools.sqltools.resultcurrent_operator.gif";
    public static final ImageDescriptor DESC_CURRENT_OPERATOR;
    public static final String IMG_SHOWPLAN = "org.eclipse.datatools.sqltools.resultshowplan.gif";
    public static final ImageDescriptor DESC_SHOWPLAN;
    public static final String IMG_REMOVEALL_DISABLE = "org.eclipse.datatools.sqltools.resultremoveall_disable.gif";
    public static final ImageDescriptor DESC_REMOVEALL_DISABLE;
    public static final String IMG_REMOVEALL = "org.eclipse.datatools.sqltools.resultremoveall.gif";
    public static final ImageDescriptor DESC_REMOVEALL;
    public static final String IMG_REMOVE_DISABLE = "org.eclipse.datatools.sqltools.resultremove_disable.gif";
    public static final ImageDescriptor DESC_REMOVE_DISABLE;
    public static final String IMG_REMOVE = "org.eclipse.datatools.sqltools.resultremove.gif";
    public static final ImageDescriptor DESC_REMOVE;
    public static final String IMG_TEXT_PLAN = "org.eclipse.datatools.sqltools.resulttext_plan.gif";
    public static final ImageDescriptor DESC_TEXT_PLAN;
    public static final String IMG_GRAPHIC_PLAN = "org.eclipse.datatools.sqltools.resultgraphic_plan.gif";
    public static final ImageDescriptor DESC_GRAPHIC_PLAN;
    public static final String IMG_FAILED_PLAN = "org.eclipse.datatools.sqltools.resultfailed_plan.gif";
    public static final ImageDescriptor DESC_FAILED_PLAN;
    public static final String IMG_EXPORT_PLAN = "org.eclipse.datatools.sqltools.resultexport_plan.gif";
    public static final ImageDescriptor DESC_EXPORT_PLAN;
    public static final String IMG_EXPORT_PLAN_DISABLE = "org.eclipse.datatools.sqltools.resultexport_plan_disable.gif";
    public static final ImageDescriptor DESC_EXPORT_PLAN_DISABLE;
    public static final String IMG_IMPORT_PLAN = "org.eclipse.datatools.sqltools.resultimport_plan.gif";
    public static final ImageDescriptor DESC_IMPORT_PLAN;
    public static final String IMG_IMPORT_PLAN_DISABLE = "org.eclipse.datatools.sqltools.resultimport_plan_disable.gif";
    public static final ImageDescriptor DESC_IMPORT_PLAN_DISABLE;
    public static final String IMG_PLAN_TYPE = "org.eclipse.datatools.sqltools.resultplan_type_switch.gif";
    public static final ImageDescriptor DESC_PLAN_TYPE;

    static {
        String pathSuffix = "icons/";
        _baseURL = PlanViewPlugin.getDefault().getBundle().getEntry(pathSuffix);
        DESC_HORIZONTAL_PLAN_VIEW = Images.createManaged(IMG_HORIZONTAL_PLAN_VIEW);
        DESC_VERTICAL_PLAN_VIEW = Images.createManaged(IMG_VERTICAL_PLAN_VIEW);
        DESC_CURRENT_OPERATOR = Images.createManaged(IMG_CURRENT_OPERATOR);
        DESC_SHOWPLAN = Images.createManaged(IMG_SHOWPLAN);
        DESC_REMOVEALL_DISABLE = Images.createManaged(IMG_REMOVEALL_DISABLE);
        DESC_REMOVEALL = Images.createManaged(IMG_REMOVEALL);
        DESC_REMOVE_DISABLE = Images.createManaged(IMG_REMOVE_DISABLE);
        DESC_REMOVE = Images.createManaged(IMG_REMOVE);
        DESC_TEXT_PLAN = Images.createManaged(IMG_TEXT_PLAN);
        DESC_GRAPHIC_PLAN = Images.createManaged(IMG_GRAPHIC_PLAN);
        DESC_FAILED_PLAN = Images.createManaged(IMG_FAILED_PLAN);
        DESC_EXPORT_PLAN = Images.createManaged(IMG_EXPORT_PLAN);
        DESC_EXPORT_PLAN_DISABLE = Images.createManaged(IMG_EXPORT_PLAN_DISABLE);
        DESC_IMPORT_PLAN = Images.createManaged(IMG_IMPORT_PLAN);
        DESC_IMPORT_PLAN_DISABLE = Images.createManaged(IMG_IMPORT_PLAN_DISABLE);
        DESC_PLAN_TYPE = Images.createManaged(IMG_PLAN_TYPE);
    }

    public static Image get(String key) {
        return Images.getImageRegistry().get(key);
    }

    static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry();
            for (String key : fgAvoidSWTErrorMap.keySet()) {
                fgImageRegistry.put(key, (ImageDescriptor)fgAvoidSWTErrorMap.get(key));
            }
            fgAvoidSWTErrorMap = null;
        }
        return fgImageRegistry;
    }

    private static ImageDescriptor createManaged(String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)Images.makeIconFileURL(name.substring(NAME_PREFIX_LENGTH)));
            fgAvoidSWTErrorMap.put(name, result);
            return result;
        }
        catch (MalformedURLException e) {
            _log.error("Debugger.Images.malformedURLException", (Object)name, (Throwable)e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String name) throws MalformedURLException {
        if (_baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(name);
        return new URL(_baseURL, buffer.toString());
    }
}

