/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.api.tools.internal.builder.AbstractIllegalTypeReference;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;

public class IllegalImplementsProblemDetector
extends AbstractIllegalTypeReference {
    private HashMap<String, IApiType> fRestrictedInterfaces = new HashMap();

    @Override
    public int getReferenceKinds() {
        return 2;
    }

    @Override
    protected int getProblemKind() {
        return 4;
    }

    @Override
    protected String getSeverityKey() {
        return "ILLEGAL_IMPLEMENT";
    }

    @Override
    public boolean considerReference(IReference reference, IProgressMonitor monitor) {
        block7: {
            if (!super.considerReference(reference, monitor)) break block7;
            return true;
        }
        try {
            IApiType type = (IApiType)reference.getMember();
            IApiType[] inters = type.getSuperInterfaces();
            IApiType inter = null;
            IApiType[] iApiTypeArray = inters;
            int n = inters.length;
            int n2 = 0;
            while (n2 < n) {
                IApiType interLoop = iApiTypeArray[n2];
                if (interLoop.getName().equals(reference.getReferencedTypeName())) {
                    inter = interLoop;
                    break;
                }
                ++n2;
            }
            if (inter != null && this.findRestrictedSuperinterfaces(type.getApiComponent(), reference.getReferencedTypeName(), inter)) {
                this.retainReference(reference);
                return true;
            }
        }
        catch (CoreException ce) {
            if (ApiPlugin.DEBUG_PROBLEM_DETECTOR) {
                ApiPlugin.log(ce);
            }
            IllegalImplementsProblemDetector.checkIfDisposed(reference.getMember().getApiComponent(), monitor);
        }
        return false;
    }

    @Override
    protected boolean isProblem(IReference reference, IProgressMonitor monitor) {
        try {
            IApiMember member;
            if (this.isIllegalType(reference)) {
                return super.isProblem(reference, monitor);
            }
            if (this.fRestrictedInterfaces.size() > 0 && (member = reference.getMember()).getType() == 2) {
                IApiType itype = this.fRestrictedInterfaces.get(reference.getReferencedTypeName());
                return itype != null && !this.isImplemented(((IApiType)member).getSuperclass(), itype.getName());
            }
            return true;
        }
        catch (CoreException ce) {
            IApiMember member;
            if (ApiPlugin.DEBUG_PROBLEM_DETECTOR) {
                ApiPlugin.log(ce);
            }
            if ((member = reference.getMember()) != null) {
                IllegalImplementsProblemDetector.checkIfDisposed(member.getApiComponent(), monitor);
            }
            return super.isProblem(reference, monitor);
        }
    }

    @Override
    protected String[] getMessageArgs(IReference reference) throws CoreException {
        IApiType type;
        IApiType inter;
        String[] args = super.getMessageArgs(reference);
        if (!this.isIllegalType(reference) && this.fRestrictedInterfaces.size() > 0 && (inter = this.fRestrictedInterfaces.get((type = (IApiType)reference.getResolvedReference()).getName())) != null) {
            String[] newargs = new String[args.length + 1];
            System.arraycopy(args, 0, newargs, 0, args.length);
            newargs[args.length] = this.getSimpleTypeName(inter);
            return newargs;
        }
        return args;
    }

    @Override
    protected String[] getQualifiedMessageArgs(IReference reference) throws CoreException {
        IApiType type;
        IApiType inter;
        String[] args = super.getQualifiedMessageArgs(reference);
        if (!this.isIllegalType(reference) && this.fRestrictedInterfaces.size() > 0 && (inter = this.fRestrictedInterfaces.get((type = (IApiType)reference.getResolvedReference()).getName())) != null) {
            String[] newargs = new String[args.length + 1];
            System.arraycopy(args, 0, newargs, 0, args.length);
            newargs[args.length] = inter.getName();
            return newargs;
        }
        return args;
    }

    @Override
    protected int getProblemFlags(IReference reference) {
        if (this.isIllegalType(reference)) {
            return super.getProblemFlags(reference);
        }
        IApiType type = (IApiType)reference.getMember();
        if (type.isLocal()) {
            return 13;
        }
        return 12;
    }

    private boolean isImplemented(IApiType type, String iname) throws CoreException {
        if (type == null) {
            return false;
        }
        if (this.isImplemented(iname, type.getSuperInterfaces())) {
            return true;
        }
        return this.isImplemented(type.getSuperclass(), iname);
    }

    private boolean isImplemented(String iname, IApiType[] interfaces) throws CoreException {
        if (interfaces.length == 0) {
            return false;
        }
        IApiType[] iApiTypeArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            IApiType interfaceLoop = iApiTypeArray[n2];
            if (interfaceLoop.getName().equals(iname)) {
                return true;
            }
            if (this.isImplemented(iname, interfaceLoop.getSuperInterfaces())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean findRestrictedSuperinterfaces(IApiComponent originalcomponent, String entryinterface, IApiType type) throws CoreException {
        IApiType[] inters = type.getSuperInterfaces();
        if (inters.length == 0) {
            return false;
        }
        IApiAnnotations annot = null;
        IApiComponent comp = null;
        IApiType[] iApiTypeArray = inters;
        int n = inters.length;
        int n2 = 0;
        while (n2 < n) {
            IApiType inter = iApiTypeArray[n2];
            comp = inter.getApiComponent();
            if (comp != null) {
                if (!comp.equals(originalcomponent) && (annot = comp.getApiDescription().resolveAnnotations(Factory.typeDescriptor(inter.getName()))) != null && RestrictionModifiers.isImplementRestriction(annot.getRestrictions())) {
                    this.fRestrictedInterfaces.put(entryinterface, inter);
                    return true;
                }
                return this.findRestrictedSuperinterfaces(originalcomponent, entryinterface, inter);
            }
            ++n2;
        }
        return false;
    }
}

