/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.php.core.PHPVersion;

public class SimpleProposal {
    public static final SimpleProposal[] BASIC_TYPES = new SimpleProposal[]{new SimpleProposal("self"), new SimpleProposal("array"), new SimpleProposal("callable", PHPVersion.PHP5_4), new SimpleProposal("bool", PHPVersion.PHP7_0), new SimpleProposal("float", PHPVersion.PHP7_0), new SimpleProposal("int", PHPVersion.PHP7_0), new SimpleProposal("string", PHPVersion.PHP7_0), new SimpleProposal("parent", PHPVersion.PHP5_3), new SimpleProposal("Closure"), new SimpleProposal("iterable", PHPVersion.PHP7_1), new SimpleProposal("object", PHPVersion.PHP7_2)};
    public String proposal;
    public PHPVersion validSince;

    public SimpleProposal(@NonNull String proposal) {
        this(proposal, null);
    }

    public SimpleProposal(@NonNull String proposal, @Nullable PHPVersion validSince) {
        Assert.isNotNull((Object)proposal);
        this.proposal = proposal;
        this.validSince = validSince;
    }

    public boolean isValidPrefix(String prefix, PHPVersion phpVersion) {
        if (this.validSince != null && this.validSince != phpVersion && !this.validSince.isLessThan(phpVersion)) {
            return false;
        }
        return this.getProposal().startsWith(prefix);
    }

    public boolean isValid(String proposal, PHPVersion phpVersion) {
        if (this.validSince != null && this.validSince != phpVersion && !this.validSince.isLessThan(phpVersion)) {
            return false;
        }
        return this.getProposal().equals(proposal);
    }

    @NonNull
    public String getProposal() {
        return this.proposal;
    }

    @Nullable
    public PHPVersion getValidSince() {
        return this.validSince;
    }
}

