/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import java.util.Map;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.php.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.internal.core.format.ICodeFormattingProcessor;
import org.eclipse.text.edits.MultiTextEdit;

public class DefaultCodeFormattingProcessor
extends AbstractVisitor
implements ICodeFormattingProcessor {
    private final Map<String, String> options;

    public DefaultCodeFormattingProcessor(Map<String, String> options) {
        this.options = options;
    }

    @Override
    @NonNull
    public String createIndentationString(int indentationUnits) {
        String useTabs;
        if (indentationUnits > 0 && (useTabs = this.options.get("org.eclipse.php.core.phpForamtterUseTabs")) != null) {
            String sizeValue;
            String indentation = "\t";
            if ("false".equalsIgnoreCase(useTabs) && (sizeValue = this.options.get("org.eclipse.php.core.phpForamtterIndentationSize")) != null) {
                StringBuilder sb = new StringBuilder();
                int size = Integer.parseInt(sizeValue);
                int i = 0;
                while (i < size) {
                    sb.append(' ');
                    ++i;
                }
                indentation = sb.toString();
            }
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < indentationUnits) {
                sb.append(indentation);
                ++i;
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    @NonNull
    public MultiTextEdit getTextEdits() {
        return new MultiTextEdit();
    }
}

