/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.phar.PharConstants;

public class PharPath {
    private String pharName;
    private String folder;
    private String file;

    private PharPath(String pharName, String folder, String file) {
        this.pharName = pharName;
        this.folder = folder;
        this.file = file;
    }

    public String getPharName() {
        return this.pharName;
    }

    public void setPharName(String pharName) {
        this.pharName = pharName;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public boolean isPhar() {
        return !(this.folder != null && !StringUtils.isBlank((CharSequence)this.folder) || this.file != null && !StringUtils.isBlank((CharSequence)this.file));
    }

    public static PharPath getPharPath(IPath path) {
        if (!PharPath.isPharPath(path)) {
            return null;
        }
        String folder = "";
        String file = "";
        path = PharConstants.WINDOWS ? path.setDevice(null) : new Path(path.toString().substring("phar:".length()));
        String pathString = path.toString();
        int index = pathString.indexOf(".phar");
        if (index >= 0) {
            String pharName = PharConstants.WINDOWS && pathString.startsWith("/") ? pathString.substring(1, index) : pathString.substring(0, index += ".phar".length());
            path = new Path(pathString = pathString.substring(index));
            if (path.segmentCount() > 0) {
                file = path.lastSegment();
                if ((path = path.removeLastSegments(1)).segmentCount() > 0) {
                    folder = path.toString().substring(1);
                }
            }
            return new PharPath(pharName, folder, file);
        }
        return null;
    }

    public static boolean isPharPath(IPath path) {
        return path.toString().startsWith("phar:");
    }
}

