/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.internal.core.phar.IStub;
import org.eclipse.php.internal.core.phar.Messages;
import org.eclipse.php.internal.core.phar.PharAchiveOutputEntry;
import org.eclipse.php.internal.core.phar.PharConstants;
import org.eclipse.php.internal.core.phar.PharException;
import org.eclipse.php.internal.core.phar.PharPackage;
import org.eclipse.php.internal.core.phar.digest.Digest;

public class PharUtil {
    public static ByteArrayInputStream getStubInputStream(IStub stub) throws IOException, CoreException {
        ByteArrayOutputStream stubOutput = new ByteArrayOutputStream();
        stub.write(stubOutput);
        ByteArrayInputStream fileInput = new ByteArrayInputStream(stubOutput.toByteArray());
        return fileInput;
    }

    public static ByteArrayInputStream getInputStream(byte[] signature) throws IOException {
        ByteArrayInputStream fileInput = new ByteArrayInputStream(signature);
        return fileInput;
    }

    public static byte[] getStubVersionBytes(String version) {
        int versionNumberLength = 4;
        String[] s = version.split("\\.");
        List versionNumbers = new ArrayList<Integer>();
        int i = 0;
        while (i < s.length) {
            versionNumbers.add(Integer.valueOf(s[i]));
            ++i;
        }
        i = 0;
        while (i < versionNumberLength) {
            versionNumbers.add(0);
            ++i;
        }
        versionNumbers = versionNumbers.subList(0, versionNumberLength);
        byte[] versionBytes = new byte[versionNumberLength / 2];
        int i2 = 0;
        while (i2 < versionBytes.length) {
            versionBytes[i2] = (byte)((Integer)versionNumbers.get(i2 * 2) * 16 + (Integer)versionNumbers.get(i2 * 2 + 1));
            ++i2;
        }
        return versionBytes;
    }

    public static int getPositive(byte b) {
        return (256 + b) % 256;
    }

    public static void throwPharException(String string) throws PharException {
        throw new PharException(string);
    }

    public static String getVersion(byte[] subBytes) {
        StringBuilder sb = new StringBuilder();
        sb.append(subBytes[0] >> 4 & 0xF);
        sb.append(subBytes[0] & 0xF);
        sb.append(subBytes[1] >> 4 & 0xF);
        return sb.toString();
    }

    public static void checkStubVilidaty(InputStream bis) throws IOException {
        boolean stubHasBeenFound = false;
        int n = -1;
        int currentByte = -1;
        while (!(stubHasBeenFound || currentByte != 95 && (n = bis.read()) == -1)) {
            if (n != 95) continue;
            boolean match = false;
            int j = 1;
            while (j < PharConstants.STUB_ENDS.length && n != -1) {
                n = bis.read();
                if (n != PharConstants.STUB_ENDS[j]) break;
                if (j == PharConstants.STUB_ENDS.length - 1) {
                    match = true;
                }
                ++j;
            }
            if (!match) continue;
            if (bis.available() > 0) {
                j = 0;
                match = false;
                while (j < PharConstants.STUB_TAIL.length && n != -1) {
                    n = bis.read();
                    if (n != PharConstants.STUB_TAIL[j]) break;
                    if (j == PharConstants.STUB_TAIL.length - 1) {
                        match = true;
                    }
                    ++j;
                }
                if (bis.available() == 0) {
                    stubHasBeenFound = match;
                    continue;
                }
                if (!PharUtil.isEndOfLine(bis)) continue;
                stubHasBeenFound = match;
                continue;
            }
            stubHasBeenFound = match;
        }
        if (!stubHasBeenFound) {
            PharUtil.throwIOException(Messages.Stub_Invalid);
        }
    }

    private static boolean isEndOfLine(InputStream bis) throws IOException {
        int available = bis.available();
        if (available == 1) {
            int first = bis.read();
            return first == 13 || first == 10;
        }
        if (available == 2) {
            int first = bis.read();
            int second = bis.read();
            return first == 13 && second == 10 || first == 10 && second == 13;
        }
        return false;
    }

    private static void throwIOException(String string) throws IOException {
        throw new IOException(string);
    }

    public static byte[] getWholeSignature(byte[] signature, PharPackage pharPackage) {
        byte[] tmp = PharUtil.comcat(signature, Digest.DIGEST_MAP.get(pharPackage.getSignature()).getBitMap());
        tmp = PharUtil.comcat(tmp, PharConstants.GBMB);
        return tmp;
    }

    public static byte[] comcat(byte[] bs, byte[] content) {
        byte[] tmp = new byte[bs.length + content.length];
        System.arraycopy(bs, 0, tmp, 0, bs.length);
        System.arraycopy(content, 0, tmp, bs.length, content.length);
        return tmp;
    }

    public static boolean byteArrayEquals(byte[] b1, byte[] b2) {
        if (b1 != null && b2 != null && b1.length == b2.length) {
            int i = 0;
            while (i < b1.length) {
                if (b1[i] != b2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean byteArrayEquals(byte[] b1, byte[] b2, int offset) {
        if (b1 == null) {
            return false;
        }
        if (b2 == null) {
            return false;
        }
        if (offset < 0) {
            return false;
        }
        if (offset == 0) {
            return PharUtil.byteArrayEquals(b1, b2);
        }
        if (offset + b2.length > b1.length) {
            return false;
        }
        int i = 0;
        while (i < b2.length) {
            if (b1[offset + i] != b2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean checkSignature(File file, int fileEnd, Digest digest, byte[] digestData) throws IOException {
        MessageDigest messageDigest = digest.getDigest();
        messageDigest.reset();
        int length = 0;
        try (BufferedInputStream contentStream = new BufferedInputStream(new FileInputStream(file));){
            int n;
            int size = 4096;
            byte[] readBuffer = fileEnd < size ? new byte[fileEnd] : new byte[4096];
            while ((n = ((InputStream)contentStream).read(readBuffer)) > 0) {
                messageDigest.update(readBuffer, 0, n);
                if ((length += n) == fileEnd) break;
                if (length + readBuffer.length <= fileEnd) continue;
                readBuffer = new byte[fileEnd - length];
            }
            if (PharUtil.byteArrayEquals(messageDigest.digest(), digestData)) {
                return true;
            }
        }
        return false;
    }

    public static byte[] getCopy(byte[] bytes) {
        byte[] result = new byte[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            result[i] = bytes[i];
            ++i;
        }
        return result;
    }

    public static byte[] getGlobalBitmap(PharPackage pharPackage) {
        byte[] globalBitmap = PharUtil.getCopy(PharConstants.Default_Global_Bitmap);
        switch (pharPackage.getCompressType()) {
            case 2: {
                globalBitmap[1] = 32;
                break;
            }
            case 1: {
                globalBitmap[1] = 16;
                break;
            }
        }
        if (pharPackage.isUseSignature()) {
            globalBitmap[2] = 1;
        }
        return globalBitmap;
    }

    public static byte[] getBitmapBytes(PharAchiveOutputEntry entry) {
        byte[] bitmap = PharUtil.getCopy(PharConstants.Default_Entry_Bitmap);
        switch (entry.getMethod()) {
            case 2: {
                bitmap[1] = (byte)(bitmap[1] + 32);
                break;
            }
            case 1: {
                bitmap[1] = (byte)(bitmap[1] + 16);
                break;
            }
        }
        return bitmap;
    }

    public static void skip(BufferedInputStream bis, long length) throws IOException {
        long n;
        while ((n = bis.skip(length)) != 0L) {
            length -= n;
        }
    }
}

