/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.shells.ui.view;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.shells.ui.ShellResources;
import org.eclipse.rse.internal.shells.ui.view.SystemCommandsViewPart;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.shells.ui.view.CommandEntryViewerConfiguration;
import org.eclipse.rse.shells.ui.view.SystemCommandEditor;
import org.eclipse.rse.shells.ui.view.SystemCommandsView;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.shells.core.model.RemoteOutput;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemCopyToClipboardAction;
import org.eclipse.rse.ui.actions.SystemPasteFromClipboardAction;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemTableViewProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.themes.IThemeManager;

public class CommandsViewPage
implements SelectionListener,
IPropertyChangeListener,
ISelectionChangedListener,
FocusListener {
    private Listener _keyListener = new Listener(){

        private boolean checkState(Event event) {
            boolean isEnabled;
            boolean bl = isEnabled = !CommandsViewPage.this._inputEntry.isInCodeAssist();
            if (event.character == '\r') {
                CommandsViewPage.this._inputEntry.setInCodeAssist(false);
            }
            return isEnabled;
        }

        public void handleEvent(Event e) {
            if (this.checkState(e)) {
                if (e.character == '\r' && e.stateMask != 262144) {
                    CommandsViewPage.this.sendInput();
                } else if (e.keyCode == 13) {
                    CommandsViewPage.this.sendInput();
                } else if (e.keyCode == 0x1000001) {
                    CommandsViewPage.this.handleUp();
                } else if (e.keyCode == 0x1000002) {
                    CommandsViewPage.this.handleDown();
                } else if (e.stateMask == 262144 && e.character == '\u0003') {
                    if (CommandsViewPage.this._inputEntry.getSelectedText().length() == 0) {
                        CommandsViewPage.this.sendBreak();
                    } else {
                        CommandsViewPage.this._inputEntry.doOperation(4);
                    }
                }
            }
        }
    };
    private CommandEntryViewerConfiguration _entryViewerConfiguration = new CommandEntryViewerConfiguration();
    private SystemCommandsView _viewer;
    private SystemCommandEditor _inputEntry;
    private Button _upButton;
    private Button _downButton;
    private Composite _inputContainer;
    private Composite _tabFolderPage;
    private int _commandHistoryOffset = 0;
    private SystemCommandsViewPart _viewPart;
    private String _title;
    private SystemCopyToClipboardAction _copyAction;
    private SystemPasteFromClipboardAction _pasteAction;
    private SelectAllAction _selectAllAction;
    private IActionBars _actionBars;
    static /* synthetic */ Class class$0;

    public CommandsViewPage(SystemCommandsViewPart viewPart) {
        this._viewPart = viewPart;
        this._actionBars = this._viewPart.getViewSite().getActionBars();
    }

    public Composite createTabFolderPage(CTabFolder tabFolder, CellEditorActionHandler editorActionHandler) {
        this._tabFolderPage = new Composite((Composite)tabFolder, 0);
        Font font = tabFolder.getFont();
        this._tabFolderPage.setFont(font);
        GridLayout gridLayout = new GridLayout();
        this._tabFolderPage.setLayout((Layout)gridLayout);
        this.createControl(this._tabFolderPage);
        Clipboard clipboard = RSEUIPlugin.getTheSystemRegistryUI().getSystemClipboard();
        this._copyAction = new SystemCopyToClipboardAction(this._viewer.getShell(), clipboard);
        this._copyAction.setEnabled(false);
        this._pasteAction = new SystemPasteFromClipboardAction(this._viewer.getShell(), clipboard);
        this._pasteAction.setEnabled(false);
        editorActionHandler.setCopyAction((IAction)this._copyAction);
        editorActionHandler.setPasteAction((IAction)this._pasteAction);
        this._selectAllAction = new SelectAllAction();
        this._selectAllAction.setEnabled(false);
        editorActionHandler.setSelectAllAction((IAction)this._selectAllAction);
        this._viewer.addSelectionChangedListener(this);
        this._viewer.getControl().addFocusListener((FocusListener)this);
        this._inputEntry.getControl().addFocusListener((FocusListener)this);
        return this._tabFolderPage;
    }

    public void setFocus() {
        this._inputEntry.getTextWidget().setFocus();
        this._viewPart.getSite().setSelectionProvider((ISelectionProvider)this._viewer);
    }

    public IActionBars getActionBars() {
        return this._actionBars;
    }

    public void selectionChanged(SelectionChangedEvent e) {
        IStructuredSelection sel = (IStructuredSelection)e.getSelection();
        this._copyAction.setEnabled(this._copyAction.updateSelection(sel));
        this._pasteAction.setEnabled(this._pasteAction.updateSelection(sel));
        this._selectAllAction.setEnabled(true);
    }

    public void setEnabled(boolean flag) {
        if (!flag) {
            this._inputEntry.getTextWidget().setEnabled(flag);
            this._inputEntry.setEditable(flag);
            Table table = this._viewer.getTable();
            Color bgcolour = this._tabFolderPage.getBackground();
            table.setBackground(bgcolour);
            this._inputEntry.getTextWidget().setBackground(bgcolour);
        }
    }

    public void createControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        Table table = new Table(parent, 101122);
        this._viewer = new SystemCommandsView(table, this._viewPart);
        this._viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CommandsViewPage.this.handleDoubleClick(event);
            }
        });
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        GridData gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        this._inputContainer = new Composite(parent, 0);
        GridLayout ilayout = new GridLayout();
        ilayout.numColumns = 4;
        Label label = new Label(this._inputContainer, 0);
        label.setText(ShellResources.RESID_COMMANDSVIEW_COMMAND_LABEL);
        this._inputEntry = new SystemCommandEditor(this._viewPart.getViewSite(), this._inputContainer, 2052, 50, this._entryViewerConfiguration, "", ShellResources.ACTION_CONTENT_ASSIST);
        this._inputEntry.getTextWidget().setToolTipText(ShellResources.RESID_COMMANDSVIEW_COMMAND_TOOLTIP);
        this._upButton = new Button(this._inputContainer, 132);
        this._upButton.addSelectionListener((SelectionListener)this);
        this._upButton.setToolTipText(ShellResources.RESID_COMMANDSVIEW_PREVIOUS_TOOLTIP);
        this._downButton = new Button(this._inputContainer, 1028);
        this._downButton.addSelectionListener((SelectionListener)this);
        this._downButton.setToolTipText(ShellResources.RESID_COMMANDSVIEW_PREVIOUS_TOOLTIP);
        GridData idata = new GridData(1816);
        idata.heightHint = 22;
        this._inputEntry.getTextWidget().setLayoutData((Object)idata);
        this._inputEntry.getTextWidget().addListener(2, this._keyListener);
        this._inputEntry.getTextWidget().addListener(1, this._keyListener);
        this.enableEntry(false);
        GridData gridData1 = new GridData(768);
        this._inputContainer.setLayout((Layout)ilayout);
        this._inputContainer.setLayoutData((Object)gridData1);
        this.updateTheme();
        IThemeManager mgr = PlatformUI.getWorkbench().getThemeManager();
        mgr.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.updateTheme();
    }

    public void updateTheme() {
        IThemeManager mgr = PlatformUI.getWorkbench().getThemeManager();
        Color bg = mgr.getCurrentTheme().getColorRegistry().get("REMOTE_COMMANDS_VIEW_BG_COLOR");
        Color fg = mgr.getCurrentTheme().getColorRegistry().get("REMOTE_COMMANDS_VIEW_FG_COLOR");
        Font fFont = mgr.getCurrentTheme().getFontRegistry().get("REMOTE_COMMANDS_VIEW_FONT");
        this._inputEntry.getControl().setBackground(bg);
        this._inputEntry.getControl().setForeground(fg);
        this._inputEntry.getControl().setFont(fFont);
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        ISystemViewElementAdapter adapter;
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (element == null) {
            return;
        }
        IAdaptable iAdaptable = (IAdaptable)element;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
            if (adapter.hasChildren((IAdaptable)element)) {
                IRemoteFile folder;
                if (element instanceof IRemoteFile && (folder = (IRemoteFile)element).isDirectory()) {
                    String path = folder.getAbsolutePath();
                    ISubSystem cmdSubSystem = adapter.getSubSystem(element);
                    String cdCmd = "cd " + PathUtility.enQuoteUnix((String)path);
                    if (cmdSubSystem.getHost().getSystemType().isWindows()) {
                        cdCmd = "cd /d \"" + path + '\"';
                    }
                    this.sendInput(cdCmd);
                }
            } else if (element instanceof RemoteOutput) {
                RemoteOutput out = (RemoteOutput)element;
                if (out.getType().equals("directory")) {
                    String path = out.getAbsolutePath();
                    ISubSystem cmdSubSystem = adapter.getSubSystem(element);
                    String cdCmd = "cd " + PathUtility.enQuoteUnix((String)path);
                    if (cmdSubSystem.getHost().getSystemType().isWindows()) {
                        cdCmd = "cd /d \"" + path + '\"';
                    }
                    this.sendInput(cdCmd);
                } else {
                    adapter.handleDoubleClick(element);
                }
            } else {
                adapter.handleDoubleClick(element);
            }
        }
    }

    public void dispose() {
        IThemeManager mgr = PlatformUI.getWorkbench().getThemeManager();
        mgr.removePropertyChangeListener((IPropertyChangeListener)this);
        this._inputEntry.getTextWidget().removeListener(2, this._keyListener);
        this._inputEntry.getTextWidget().dispose();
        this._inputContainer.dispose();
        this._viewer.dispose();
        this._tabFolderPage.dispose();
    }

    private void enableEntry(boolean flag) {
        if (!this._inputEntry.getTextWidget().isDisposed()) {
            this._inputEntry.getTextWidget().setEnabled(flag);
        }
    }

    public void sendInput() {
        String inputStr = this._inputEntry.getTextWidget().getText();
        this.sendInput(inputStr);
    }

    public void sendInput(String inputStr) {
        Object input = this._viewer.getInput();
        if (input instanceof IRemoteCommandShell) {
            this._commandHistoryOffset = this.getCommandHistory().length + 1;
            IRemoteCommandShell remoteCommand = (IRemoteCommandShell)input;
            IRemoteCmdSubSystem commandSubSystem = remoteCommand.getCommandSubSystem();
            try {
                commandSubSystem.sendCommandToShell(inputStr, (Object)remoteCommand, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this._inputEntry.getTextWidget().setText("");
        this._inputEntry.getTextWidget().setFocus();
    }

    public void sendBreak() {
        Object input = this._viewer.getInput();
        if (input instanceof IRemoteCommandShell) {
            IRemoteCommandShell remoteCommand = (IRemoteCommandShell)input;
            IRemoteCmdSubSystem commandSubSystem = remoteCommand.getCommandSubSystem();
            try {
                commandSubSystem.sendCommandToShell("#break", (Object)remoteCommand, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Object getInput() {
        if (this._viewer != null) {
            return this._viewer.getInput();
        }
        return null;
    }

    public void setInput(IAdaptable object) {
        this.setInput(object, true);
        this.updateTitle(object);
    }

    public void updateTitle(IAdaptable object) {
        if (object instanceof IRemoteCommandShell) {
            IRemoteCommandShell command = (IRemoteCommandShell)object;
            String title = command.getType();
            String msgTxt = null;
            msgTxt = !command.isActive() ? NLS.bind((String)CommonMessages.MSG_OPERATION_FINISHED, (Object)title) : NLS.bind((String)CommonMessages.MSG_OPERATION_RUNNING, (Object)title);
            this._title = msgTxt;
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setInput(IAdaptable object, boolean updateHistory) {
        if (this._viewer != null && object != null) {
            this._viewer.setInput(object);
            this._entryViewerConfiguration.setRemoteCommand((IRemoteCommandShell)object);
        }
    }

    public void clearInput() {
        if (this._viewer != null) {
            this._viewer.setInput(null);
            this._entryViewerConfiguration.setRemoteCommand(null);
        }
    }

    public SystemCommandsView getViewer() {
        return this._viewer;
    }

    SystemCommandEditor getEditor() {
        return this._inputEntry;
    }

    public void updateOutput() {
        if (this._viewer != null) {
            ((SystemTableViewProvider)this._viewer.getContentProvider()).flushCache();
            this._viewer.updateChildren();
            this._commandHistoryOffset = this.getCommandHistory().length;
        }
    }

    public void updateActionStates() {
        Object input = this._viewer.getInput();
        if (input != null) {
            if (input instanceof IRemoteCommandShell) {
                IRemoteCommandShell cmdInput = (IRemoteCommandShell)input;
                if (cmdInput.isActive()) {
                    this.enableEntry(true);
                } else {
                    this.enableEntry(false);
                }
            } else {
                this.enableEntry(false);
            }
        } else {
            this.enableEntry(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Widget source = e.widget;
        if (source == this._upButton) {
            this.handleUp();
        } else if (source == this._downButton) {
            this.handleDown();
        }
    }

    private String[] getCommandHistory() {
        Object input = this._viewer.getInput();
        if (input != null && input instanceof IRemoteCommandShell) {
            IRemoteCommandShell command = (IRemoteCommandShell)input;
            return command.getHistory();
        }
        return null;
    }

    private void handleUp() {
        String[] history = this.getCommandHistory();
        --this._commandHistoryOffset;
        if (this._commandHistoryOffset > 0) {
            if (history.length > this._commandHistoryOffset) {
                String lastCommand = history[this._commandHistoryOffset];
                this._inputEntry.getTextWidget().setText(lastCommand);
                this._inputEntry.getTextWidget().setCaretOffset(this._inputEntry.getTextWidget().getCharCount());
            }
        } else {
            this._commandHistoryOffset = 0;
            if (history.length > 0) {
                this._inputEntry.getTextWidget().setText(history[0]);
                this._inputEntry.getTextWidget().setCaretOffset(this._inputEntry.getTextWidget().getCharCount());
            }
        }
    }

    private void handleDown() {
        ++this._commandHistoryOffset;
        if (this._commandHistoryOffset >= this.getCommandHistory().length) {
            this._commandHistoryOffset = this.getCommandHistory().length;
            this._inputEntry.getTextWidget().setText("");
        } else {
            String[] history = this.getCommandHistory();
            if (history.length > 0) {
                String lastCommand = history[this._commandHistoryOffset];
                this._inputEntry.getTextWidget().setText(lastCommand);
                this._inputEntry.getTextWidget().setCaretOffset(this._inputEntry.getTextWidget().getCharCount());
            }
        }
    }

    public void focusGained(FocusEvent arg0) {
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            if (arg0.widget == this._viewer.getControl()) {
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this._copyAction);
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.PASTE, (IAction)this._pasteAction);
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)this._selectAllAction);
                actionBars.updateActionBars();
            } else if (arg0.widget == this._inputEntry.getControl()) {
                this._inputEntry.setActionHandlers();
            }
        }
    }

    public void focusLost(FocusEvent arg0) {
    }

    class SelectAllAction
    extends Action {
        public SelectAllAction() {
            super(SystemResources.ACTION_SELECT_ALL_LABEL, null);
            this.setToolTipText(SystemResources.ACTION_SELECT_ALL_TOOLTIP);
        }

        public void checkEnabledState() {
            this.setEnabled(true);
        }

        public void run() {
            SystemCommandsView view = CommandsViewPage.this._viewer;
            view.getTable().selectAll();
            view.setSelection(view.getSelection());
        }
    }
}

