/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.macro.ActiveAnnotationContext;
import org.eclipse.xtend.core.macro.ActiveAnnotationContexts;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtend.core.macro.XAnnotationExtensions;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class ActiveAnnotationContextProvider {
    private static final Logger logger = Logger.getLogger(ActiveAnnotationContextProvider.class);
    @Inject
    @Extension
    private XAnnotationExtensions _xAnnotationExtensions;
    @Inject
    @Extension
    private ProcessorInstanceForJvmTypeProvider _processorInstanceForJvmTypeProvider;
    @Inject
    private Provider<CompilationUnitImpl> compilationUnitProvider;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public ActiveAnnotationContexts computeContext(XtendFile file) {
        Stopwatches.StoppedTask task = Stopwatches.forTask((String)"[macros] findActiveAnnotations (ActiveAnnotationContextProvider.computeContext)");
        task.start();
        try {
            ActiveAnnotationContexts result = ActiveAnnotationContexts.installNew(file.eResource());
            CompilationUnitImpl compilationUnit = (CompilationUnitImpl)this.compilationUnitProvider.get();
            compilationUnit.setXtendFile(file);
            result.compilationUnit = compilationUnit;
            IAcceptor _function = it -> {
                boolean _not;
                boolean _containsKey = result.getContexts().containsKey(it.getKey());
                boolean bl = _not = !_containsKey;
                if (_not) {
                    ActiveAnnotationContext fa = new ActiveAnnotationContext();
                    fa.setCompilationUnit(compilationUnit);
                    JvmType processorType = this._xAnnotationExtensions.getProcessorType((JvmAnnotationType)it.getKey());
                    try {
                        Object processorInstance = this._processorInstanceForJvmTypeProvider.getProcessorInstance(processorType);
                        if (processorInstance == null) {
                            String _identifier = processorType.getIdentifier();
                            String _plus = "Couldn't instantiate the annotation processor of type '" + _identifier;
                            String _plus_1 = String.valueOf(_plus) + "'. This is usually the case when the processor resides in the same project as the annotated element.";
                            throw new IllegalStateException(_plus_1);
                        }
                        fa.setProcessorInstance(processorInstance);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof VirtualMachineError) {
                            VirtualMachineError e = (VirtualMachineError)_t;
                            throw e;
                        }
                        if (_t instanceof Throwable) {
                            Throwable e_1 = _t;
                            this.operationCanceledManager.propagateAsErrorIfCancelException(e_1);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("Problem while loading annotation processor: ");
                            String _switchResult = null;
                            boolean _matched = false;
                            if (e_1 instanceof ExceptionInInitializerError) {
                                _matched = true;
                                _switchResult = ((ExceptionInInitializerError)e_1).getException().getMessage();
                            }
                            if (!_matched) {
                                _switchResult = e_1.getMessage();
                            }
                            _builder.append(_switchResult);
                            String msg = _builder.toString();
                            logger.error((Object)msg, e_1);
                            EList _errors = file.eResource().getErrors();
                            XAnnotation _value = (XAnnotation)it.getValue();
                            EObjectDiagnosticImpl _eObjectDiagnosticImpl = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtend.core.validation.IssueCodes.processing_error", msg, (EObject)_value, (EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE, -1, null);
                            _errors.add((Object)_eObjectDiagnosticImpl);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    result.getContexts().put((JvmAnnotationType)it.getKey(), fa);
                }
                List<XtendAnnotationTarget> _annotatedSourceElements = result.getContexts().get(it.getKey()).getAnnotatedSourceElements();
                XtendAnnotationTarget _annotatedTarget = this._xAnnotationExtensions.getAnnotatedTarget((XAnnotation)it.getValue());
                _annotatedSourceElements.add(_annotatedTarget);
            };
            this.searchAnnotatedElements(file, (IAcceptor<Pair<JvmAnnotationType, XAnnotation>>)_function);
            ActiveAnnotationContexts activeAnnotationContexts = result;
            return activeAnnotationContexts;
        }
        catch (Throwable _t) {
            if (_t instanceof Throwable) {
                Throwable e = _t;
                this.operationCanceledManager.propagateAsErrorIfCancelException(e);
                boolean _matched = false;
                if (e instanceof VirtualMachineError) {
                    _matched = true;
                    throw (VirtualMachineError)e;
                }
                if (!_matched && e instanceof LinkageError) {
                    _matched = true;
                    throw (LinkageError)e;
                }
                logger.warn((Object)"Error finding the elements to be processed by active annotations", e);
                ActiveAnnotationContexts activeAnnotationContexts = ActiveAnnotationContexts.installNew(file.eResource());
                return activeAnnotationContexts;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        finally {
            task.stop();
        }
    }

    protected void searchAnnotatedElements(EObject element, IAcceptor<Pair<JvmAnnotationType, XAnnotation>> acceptor) {
        Consumer<XtendAnnotationTarget> _function;
        boolean _matched = false;
        if (element instanceof XtendFile) {
            _matched = true;
            _function = it -> this.searchAnnotatedElements((EObject)it, acceptor);
            ((XtendFile)element).getXtendTypes().forEach(_function);
        }
        if (!_matched && element instanceof XtendClass) {
            _matched = true;
            this.registerMacroAnnotations((XtendAnnotationTarget)element, acceptor);
            _function = it -> this.searchAnnotatedElements((EObject)it, acceptor);
            ((XtendClass)element).getMembers().forEach(_function);
        }
        if (!_matched && element instanceof XtendInterface) {
            _matched = true;
            this.registerMacroAnnotations((XtendAnnotationTarget)element, acceptor);
            _function = it -> this.searchAnnotatedElements((EObject)it, acceptor);
            ((XtendInterface)element).getMembers().forEach(_function);
        }
        if (!_matched && element instanceof XtendEnum) {
            _matched = true;
            this.registerMacroAnnotations((XtendAnnotationTarget)element, acceptor);
            _function = it -> this.searchAnnotatedElements((EObject)it, acceptor);
            ((XtendEnum)element).getMembers().forEach(_function);
        }
        if (!_matched && element instanceof XtendAnnotationType) {
            _matched = true;
            this.registerMacroAnnotations((XtendAnnotationTarget)element, acceptor);
            _function = it -> this.searchAnnotatedElements((EObject)it, acceptor);
            ((XtendAnnotationType)element).getMembers().forEach(_function);
        }
        if (!_matched && element instanceof XtendFunction) {
            _matched = true;
            this.registerMacroAnnotations((XtendAnnotationTarget)element, acceptor);
            _function = it -> this.searchAnnotatedElements((EObject)it, acceptor);
            ((XtendFunction)element).getParameters().forEach(_function);
        }
        if (!_matched && element instanceof XtendConstructor) {
            _matched = true;
            this.registerMacroAnnotations((XtendAnnotationTarget)element, acceptor);
            _function = it -> this.searchAnnotatedElements((EObject)it, acceptor);
            ((XtendConstructor)element).getParameters().forEach(_function);
        }
        if (!_matched && element instanceof XtendAnnotationTarget) {
            _matched = true;
            this.registerMacroAnnotations((XtendAnnotationTarget)element, acceptor);
        }
    }

    protected void registerMacroAnnotations(XtendAnnotationTarget candidate, IAcceptor<Pair<JvmAnnotationType, XAnnotation>> acceptor) {
        Functions.Function1 _function = it -> this._xAnnotationExtensions.isProcessed((XAnnotation)it);
        Iterable _filter = IterableExtensions.filter(candidate.getAnnotations(), (Functions.Function1)_function);
        for (XAnnotation annotation : _filter) {
            boolean _isValid;
            JvmAnnotationType activeAnnotationDeclaration = this._xAnnotationExtensions.tryFindAnnotationType(annotation);
            if (activeAnnotationDeclaration == null || !(_isValid = this.isValid(annotation, activeAnnotationDeclaration))) continue;
            Pair _mappedTo = Pair.of((Object)activeAnnotationDeclaration, (Object)annotation);
            acceptor.accept((Object)_mappedTo);
        }
    }

    private boolean isValid(XAnnotation annotation, JvmAnnotationType activeAnnotationDeclaration) {
        return annotation != null;
    }
}

