/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.build;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BuildScriptGenerator;
import org.eclipse.pde.internal.core.ClasspathHelper;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.builders.BuildErrorReporter;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.build.BaseBuildAction;

public class GeneratePluginBuildFileAction
extends BaseBuildAction {
    @Override
    protected void makeScripts(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        IProject project = this.fManifestFile.getProject();
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        BuildErrorReporter buildErrorReporter = new BuildErrorReporter(this.fManifestFile);
        IResource buildXML = project.findMember("build.xml");
        if (buildXML != null && buildXML.exists() && buildErrorReporter.isCustomBuild()) {
            throw new CoreException(Status.warning((String)PDEUIMessages.BuildPluginAction_WarningCustomBuildExists));
        }
        BuildScriptGenerator generator = new BuildScriptGenerator();
        AbstractScriptGenerator.setEmbeddedSource((boolean)AbstractScriptGenerator.getDefaultEmbeddedSource());
        AbstractScriptGenerator.setForceUpdateJar((boolean)AbstractScriptGenerator.getForceUpdateJarFormat());
        AbstractScriptGenerator.setConfigInfo((String)AbstractScriptGenerator.getDefaultConfigInfos());
        generator.setWorkingDirectory(project.getLocation().toOSString());
        String url = ClasspathHelper.getDevEntriesProperties((String)(String.valueOf(project.getLocation().addTrailingSeparator().toString()) + "dev.properties"), (boolean)false);
        generator.setDevEntries(url);
        generator.setPDEState(TargetPlatformHelper.getState());
        generator.setNextId(TargetPlatformHelper.getPDEState().getNextId());
        generator.setStateExtraData(TargetPlatformHelper.getBundleClasspaths((PDEState)TargetPlatformHelper.getPDEState()), TargetPlatformHelper.getPatchMap((PDEState)TargetPlatformHelper.getPDEState()));
        Properties properties = new Properties();
        properties.put("allowBinaryCycles", "true");
        generator.setImmutableAntProperties(properties);
        if (model != null && model.getPluginBase().getId() != null) {
            generator.setBundles(new BundleDescription[]{model.getBundleDescription()});
            generator.generate();
        } else {
            MessageDialog.openError(null, (String)PDEUIMessages.BuildPluginAction_ErrorDialog_Title, (String)PDEUIMessages.BuildPluginAction_ErrorDialog_Message);
        }
    }
}

