/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttributeMapper;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCustomField;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.bugzilla.core.IBugzillaConstants;
import org.eclipse.mylyn.internal.bugzilla.core.Messages;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;

public class BugzillaTaskDataHandler
extends AbstractTaskDataHandler {
    protected final BugzillaRepositoryConnector connector;

    public BugzillaTaskDataHandler(BugzillaRepositoryConnector connector) {
        this.connector = connector;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        HashSet<String> taskIds = new HashSet<String>();
        taskIds.add(taskId);
        final TaskData[] retrievedData = new TaskData[1];
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                retrievedData[0] = taskData;
            }
        };
        this.getMultiTaskData(repository, taskIds, collector, monitor);
        if (retrievedData[0] == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Task data could not be retrieved. Please re-synchronize task"));
        }
        return retrievedData[0];
    }

    public void getMultiTaskData(TaskRepository repository, Set<String> taskIds, TaskDataCollector collector, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            try {
                monitor.beginTask(Messages.BugzillaTaskDataHandler_Receiving_tasks, taskIds.size());
                BugzillaClient client = this.connector.getClientManager().getClient(repository, monitor);
                CoreException[] collectionException = new CoreException[1];
                Boolean[] updateConfig = new Boolean[1];
                class CollectorWrapper
                extends TaskDataCollector {
                    private final IProgressMonitor monitor2;
                    private final TaskDataCollector collector;
                    private final /* synthetic */ TaskRepository val$repository;
                    private final /* synthetic */ Boolean[] val$updateConfig;
                    private final /* synthetic */ CoreException[] val$collectionException;

                    public void failed(String taskId, IStatus status) {
                        this.collector.failed(taskId, status);
                    }

                    public CollectorWrapper(TaskDataCollector collector, IProgressMonitor monitor2, TaskRepository taskRepository, Boolean[] booleanArray, CoreException[] coreExceptionArray) {
                        this.val$repository = taskRepository;
                        this.val$updateConfig = booleanArray;
                        this.val$collectionException = coreExceptionArray;
                        this.collector = collector;
                        this.monitor2 = monitor2;
                    }

                    public void accept(TaskData taskData) {
                        block4: {
                            try {
                                BugzillaTaskDataHandler.this.initializeTaskData(this.val$repository, taskData, null, (IProgressMonitor)new SubProgressMonitor(this.monitor2, 1));
                            }
                            catch (CoreException e) {
                                if (e.getStatus().getCode() == 1 && e.getMessage().contains("Update Config")) {
                                    if (this.val$updateConfig[0] == null) {
                                        this.val$updateConfig[0] = true;
                                    }
                                }
                                if (this.val$collectionException[0] != null) break block4;
                                this.val$collectionException[0] = e;
                            }
                        }
                        this.collector.accept(taskData);
                        this.monitor2.worked(1);
                    }
                }
                CollectorWrapper collector2 = new CollectorWrapper(collector, monitor, repository, updateConfig, collectionException);
                client.getTaskData(taskIds, collector2, this.getAttributeMapper(repository), monitor);
                if (collectionException[0] != null) {
                    throw collectionException[0];
                }
                if (updateConfig[0] != null) {
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                    client.getRepositoryConfiguration((IProgressMonitor)subMonitor, null);
                    subMonitor.done();
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, repository.getRepositoryUrl(), e));
            }
        }
        finally {
            monitor.done();
        }
    }

    public void migrateTaskData(TaskRepository taskRepository, TaskData taskData) {
        float bugzillaTaskDataVersion = 0.0f;
        String taskDataVersion = taskData.getVersion();
        if (taskDataVersion != null) {
            try {
                bugzillaTaskDataVersion = Float.parseFloat(taskDataVersion);
            }
            catch (NumberFormatException e) {
                bugzillaTaskDataVersion = 0.0f;
            }
        }
        TaskDataVersion[] taskDataVersionArray = TaskDataVersion.values();
        int n = taskDataVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            TaskDataVersion version = taskDataVersionArray[n2];
            if (bugzillaTaskDataVersion <= version.getVersionNum()) {
                version.migrate(taskRepository, taskData, this.connector);
            }
            ++n2;
        }
    }

    public RepositoryResponse postTaskData(TaskRepository repository, TaskData taskData, Set<TaskAttribute> changedAttributes, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask(Messages.BugzillaTaskDataHandler_Submitting_task, -1);
            BugzillaClient client = this.connector.getClientManager().getClient(repository, monitor);
            try {
                RepositoryResponse repositoryResponse = client.postTaskData(taskData, monitor);
                return repositoryResponse;
            }
            catch (CoreException e) {
                try {
                    throw e;
                }
                catch (IOException e2) {
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, repository.getRepositoryUrl(), e2));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData taskData, ITaskMapping initializationData, IProgressMonitor monitor) throws CoreException {
        taskData.setVersion(TaskDataVersion.VERSION_CURRENT.toString());
        try {
            monitor = Policy.monitorFor((IProgressMonitor)monitor);
            monitor.beginTask("Initialize Task Data", -1);
            RepositoryConfiguration repositoryConfiguration = this.connector.getRepositoryConfiguration(repository, false, monitor);
            if (repositoryConfiguration == null) {
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, repository.getRepositoryUrl(), "Retrieving repository configuration failed."));
            }
            if (taskData.isNew()) {
                String product = null;
                String component = null;
                if (initializationData == null || initializationData.getProduct() == null) {
                    if (repositoryConfiguration.getOptionValues(BugzillaAttribute.PRODUCT).size() > 0) {
                        product = repositoryConfiguration.getOptionValues(BugzillaAttribute.PRODUCT).get(0);
                    }
                } else {
                    product = initializationData.getProduct();
                }
                if (product == null) {
                    return false;
                }
                if (initializationData != null && initializationData.getComponent() != null && initializationData.getComponent().length() > 0) {
                    component = initializationData.getComponent();
                }
                this.initializeNewTaskDataAttributes(repositoryConfiguration, taskData, product, component, monitor);
                if (this.connector != null) {
                    this.connector.setPlatformDefaultsOrGuess(repository, taskData);
                }
                return true;
            }
            boolean shortLogin = Boolean.parseBoolean(repository.getProperty("bugzilla.shortLoginEnabled"));
            repositoryConfiguration.configureTaskData(taskData, shortLogin, this.connector);
            for (TaskAttribute taskAttribute : taskData.getRoot().getAttributes().values()) {
                Map opt = taskAttribute.getOptions();
                if (opt == null || opt.isEmpty()) continue;
                List values = taskAttribute.getValues();
                for (String value : values) {
                    if (opt.containsKey(value)) continue;
                    taskAttribute.putOption(value, value);
                }
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    private boolean initializeNewTaskDataAttributes(RepositoryConfiguration repositoryConfiguration, TaskData taskData, String product, String component, IProgressMonitor monitor) {
        TaskAttribute attrAddSelfToCc;
        TaskAttribute attrOwner;
        TaskAttribute attrDescription;
        TaskRepository taskRepository;
        TaskAttribute productAttribute = BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.PRODUCT);
        productAttribute.setValue(product);
        List<String> optionValues = repositoryConfiguration.getOptionValues(BugzillaAttribute.PRODUCT);
        Collections.sort(optionValues);
        for (String optionValue : optionValues) {
            productAttribute.putOption(optionValue, optionValue);
        }
        TaskAttribute attributeStatus = BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.BUG_STATUS);
        optionValues = repositoryConfiguration.getOptionValues(BugzillaAttribute.BUG_STATUS);
        for (String option : optionValues) {
            attributeStatus.putOption(option, option);
        }
        BugzillaVersion bugzillaVersion = repositoryConfiguration.getInstallVersion();
        if (bugzillaVersion == null) {
            bugzillaVersion = BugzillaVersion.MIN_VERSION;
        }
        if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_0) < 0) {
            attributeStatus.setValue(repositoryConfiguration.getStartStatus());
        } else if (repositoryConfiguration.getOptionValues(BugzillaAttribute.BUG_STATUS).contains(IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.IN_PROGRESS.toString()) || repositoryConfiguration.getOptionValues(BugzillaAttribute.BUG_STATUS).contains(IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.CONFIRMED.toString())) {
            attributeStatus.setValue(IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.START.toString());
            repositoryConfiguration.addValidOperations(taskData);
        } else {
            attributeStatus.setValue(repositoryConfiguration.getStartStatus());
        }
        BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.SHORT_DESC);
        TaskAttribute attributeVersion = BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.VERSION);
        optionValues = repositoryConfiguration.getProductOptionValues(BugzillaAttribute.VERSION, productAttribute.getValue());
        Collections.sort(optionValues);
        for (String option : optionValues) {
            attributeVersion.putOption(option, option);
        }
        if (optionValues.size() > 0) {
            attributeVersion.setValue(optionValues.get(optionValues.size() - 1));
        }
        TaskAttribute attributeComponent = BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.COMPONENT);
        optionValues = repositoryConfiguration.getProductOptionValues(BugzillaAttribute.COMPONENT, productAttribute.getValue());
        Collections.sort(optionValues);
        for (String option : optionValues) {
            attributeComponent.putOption(option, option);
        }
        if (optionValues.size() == 1) {
            attributeComponent.setValue(optionValues.get(0));
        }
        if (component != null && optionValues.contains(component)) {
            attributeComponent.setValue(component);
        }
        if (BugzillaUtil.getTaskPropertyWithDefaultTrue(taskRepository = taskData.getAttributeMapper().getTaskRepository(), "bugzilla.param.usetargetmilestone") && (optionValues = repositoryConfiguration.getProductOptionValues(BugzillaAttribute.TARGET_MILESTONE, productAttribute.getValue())).size() > 0) {
            TaskAttribute attributeTargetMilestone = BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.TARGET_MILESTONE);
            for (String option : optionValues) {
                attributeTargetMilestone.putOption(option, option);
            }
            if (product != null && !product.equals("")) {
                String defaultMilestone = repositoryConfiguration.getDefaultMilestones(product);
                if (defaultMilestone != null) {
                    attributeTargetMilestone.setValue(defaultMilestone);
                } else if (optionValues.contains("---")) {
                    attributeTargetMilestone.setValue("---");
                }
            } else if (optionValues.contains("---")) {
                attributeTargetMilestone.setValue("---");
            }
        }
        TaskAttribute attributePlatform = BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.REP_PLATFORM);
        optionValues = repositoryConfiguration.getOptionValues(BugzillaAttribute.REP_PLATFORM);
        for (String option : optionValues) {
            attributePlatform.putOption(option, option);
        }
        if (optionValues.size() > 0) {
            attributePlatform.setValue(optionValues.get(0));
        }
        TaskAttribute attributeOPSYS = BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.OP_SYS);
        optionValues = repositoryConfiguration.getOptionValues(BugzillaAttribute.OP_SYS);
        for (String option : optionValues) {
            attributeOPSYS.putOption(option, option);
        }
        if (optionValues.size() > 0) {
            attributeOPSYS.setValue(optionValues.get(0));
        }
        TaskAttribute attributePriority = BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.PRIORITY);
        optionValues = repositoryConfiguration.getOptionValues(BugzillaAttribute.PRIORITY);
        for (String option : optionValues) {
            attributePriority.putOption(option, option);
        }
        if (optionValues.size() > 0) {
            attributePriority.setValue(optionValues.get(optionValues.size() / 2));
        }
        TaskAttribute attributeSeverity = BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.BUG_SEVERITY);
        optionValues = repositoryConfiguration.getOptionValues(BugzillaAttribute.BUG_SEVERITY);
        for (String option : optionValues) {
            attributeSeverity.putOption(option, option);
        }
        if (optionValues.size() > 0) {
            attributeSeverity.setValue(optionValues.get(optionValues.size() / 2));
        }
        TaskAttribute attributeAssignedTo = BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.ASSIGNED_TO);
        attributeAssignedTo.setValue("");
        if (BugzillaUtil.getTaskPropertyWithDefaultTrue(taskRepository, "bugzilla.param.useqacontact")) {
            TaskAttribute attributeQAContact = BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.QA_CONTACT);
            attributeQAContact.setValue("");
        }
        TaskAttribute attributeBugFileLoc = BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.BUG_FILE_LOC);
        attributeBugFileLoc.setValue("http://");
        BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.DEPENDSON);
        BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.BLOCKED);
        BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.NEWCC);
        BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.LONG_DESC);
        List<String> keywords = repositoryConfiguration.getOptionValues(BugzillaAttribute.KEYWORDS);
        if (keywords.size() > 0) {
            BugzillaTaskDataHandler.createAttribute(taskData, BugzillaAttribute.KEYWORDS);
        }
        if ((attrDescription = taskData.getRoot().getMappedAttribute("task.common.description")) != null) {
            attrDescription.getMetaData().setReadOnly(false);
        }
        if ((attrOwner = taskData.getRoot().getMappedAttribute("task.common.user.assigned")) != null) {
            attrOwner.getMetaData().setReadOnly(false);
        }
        if ((attrAddSelfToCc = taskData.getRoot().getMappedAttribute("task.common.addselfcc")) != null) {
            attrAddSelfToCc.getMetaData().setKind(null);
        }
        List<Object> customFields = new ArrayList();
        if (repositoryConfiguration != null) {
            customFields = repositoryConfiguration.getCustomFields();
        }
        for (BugzillaCustomField bugzillaCustomField : customFields) {
            TaskAttribute attribute;
            if (!bugzillaCustomField.isEnterBug()) continue;
            List<String> options = bugzillaCustomField.getOptions();
            BugzillaCustomField.FieldType fieldType = bugzillaCustomField.getFieldType();
            if (options.size() < 1 && (fieldType.equals((Object)BugzillaCustomField.FieldType.DropDown) || fieldType.equals((Object)BugzillaCustomField.FieldType.MultipleSelection)) || (attribute = taskData.getRoot().createAttribute(bugzillaCustomField.getName())) == null) continue;
            attribute.getMetaData().defaults().setLabel(bugzillaCustomField.getDescription());
            attribute.getMetaData().setKind("task.common.kind.default");
            switch (bugzillaCustomField.getFieldType()) {
                case FreeText: {
                    attribute.getMetaData().setType("shortText");
                    break;
                }
                case DropDown: {
                    attribute.getMetaData().setType("singleSelect");
                    break;
                }
                case MultipleSelection: {
                    attribute.getMetaData().setType("multiSelect");
                    break;
                }
                case LargeText: {
                    attribute.getMetaData().setType("longText");
                    break;
                }
                case DateTime: {
                    attribute.getMetaData().setType("dateTime");
                    break;
                }
                default: {
                    if (options.size() > 0) {
                        attribute.getMetaData().setType("singleSelect");
                        break;
                    }
                    attribute.getMetaData().setType("shortText");
                }
            }
            attribute.getMetaData().setReadOnly(false);
            for (String option : options) {
                attribute.putOption(option, option);
            }
            if (bugzillaCustomField.getFieldType() != BugzillaCustomField.FieldType.DropDown || options.size() <= 0) continue;
            attribute.setValue(options.get(0));
        }
        return true;
    }

    public boolean canGetMultiTaskData(TaskRepository taskRepository) {
        return true;
    }

    public boolean canInitializeSubTaskData(TaskRepository taskRepository, ITask task) {
        return true;
    }

    public boolean initializeSubTaskData(TaskRepository repository, TaskData subTaskData, TaskData parentTaskData, IProgressMonitor monitor) throws CoreException {
        TaskMapper mapper = new TaskMapper(parentTaskData);
        if (this.initializeTaskData(repository, subTaskData, (ITaskMapping)mapper, monitor)) {
            new TaskMapper(subTaskData).merge((ITaskMapping)mapper);
            subTaskData.getRoot().getMappedAttribute(BugzillaAttribute.DEPENDSON.getKey()).setValue("");
            subTaskData.getRoot().getMappedAttribute("task.common.description").setValue("");
            subTaskData.getRoot().getMappedAttribute("task.common.summary").setValue("");
            TaskAttribute keywords = subTaskData.getRoot().getMappedAttribute("task.common.keywords");
            if (keywords != null) {
                keywords.setValue("");
            }
            subTaskData.getRoot().getAttribute(BugzillaAttribute.BLOCKED.getKey()).setValue(parentTaskData.getTaskId());
            TaskAttribute parentAttributeAssigned = parentTaskData.getRoot().getMappedAttribute("task.common.user.assigned");
            subTaskData.getRoot().getAttribute(BugzillaAttribute.ASSIGNED_TO.getKey()).setValue(parentAttributeAssigned.getValue());
            return true;
        }
        return false;
    }

    public TaskAttributeMapper getAttributeMapper(TaskRepository taskRepository) {
        return new BugzillaAttributeMapper(taskRepository, this.connector);
    }

    public static TaskAttribute createAttribute(TaskData data, BugzillaAttribute key) {
        return BugzillaTaskDataHandler.createAttribute(data.getRoot(), key);
    }

    public static TaskAttribute createAttribute(TaskAttribute parent, BugzillaAttribute key) {
        TaskAttribute attribute = parent.createAttribute(key.getKey());
        attribute.getMetaData().defaults().setReadOnly(key.isReadOnly()).setKind(key.getKind()).setLabel(key.toString()).setType(key.getType());
        if (key == BugzillaAttribute.STATUS_WHITEBOARD) {
            attribute.getMetaData().putValue("task.meta.index.content", Boolean.TRUE.toString());
        }
        return attribute;
    }

    public void postUpdateAttachment(TaskRepository repository, TaskAttribute taskAttribute, String action, IProgressMonitor monitor) throws CoreException {
        block9: {
            monitor = Policy.monitorFor((IProgressMonitor)monitor);
            try {
                try {
                    monitor.beginTask(Messages.BugzillaTaskDataHandler_updating_attachment, -1);
                    BugzillaClient client = this.connector.getClientManager().getClient(repository, monitor);
                    try {
                        client.postUpdateAttachment(taskAttribute, action, monitor);
                    }
                    catch (CoreException e) {
                        if (e.getStatus().getCode() == 3) {
                            AuthenticationCredentials creds = repository.getCredentials(AuthenticationType.REPOSITORY);
                            if (creds != null && creds.getUserName() != null && creds.getUserName().length() > 0) {
                                client.postUpdateAttachment(taskAttribute, action, monitor);
                                break block9;
                            }
                            throw e;
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, repository.getRepositoryUrl(), e));
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum TaskDataVersion {
        VERSION_0(0.0f){

            @Override
            void migrate(TaskRepository repository, TaskData data, BugzillaRepositoryConnector connector) {
            }
        }
        ,
        VERSION_1_0(1.0f){

            @Override
            void migrate(TaskRepository repository, TaskData data, BugzillaRepositoryConnector connector) {
                for (TaskAttribute attribute : new ArrayList(data.getRoot().getAttributes().values())) {
                    if (!attribute.getId().equals(BugzillaAttribute.DESC.getKey())) continue;
                    TaskAttribute attrLongDesc = BugzillaTaskDataHandler.createAttribute(data, BugzillaAttribute.LONG_DESC);
                    attrLongDesc.setValue(attribute.getValue());
                    data.getRoot().removeAttribute(BugzillaAttribute.DESC.getKey());
                }
                HashSet<TaskAttribute> operationsToRemove = new HashSet<TaskAttribute>();
                for (TaskAttribute attribute : data.getAttributeMapper().getAttributesByType(data, "operation")) {
                    operationsToRemove.add(attribute);
                }
                for (TaskAttribute taskAttribute : operationsToRemove) {
                    data.getRoot().removeAttribute(taskAttribute.getId());
                }
                RepositoryConfiguration configuration = connector.getRepositoryConfiguration(repository.getRepositoryUrl());
                if (configuration != null) {
                    configuration.addValidOperations(data);
                }
            }
        }
        ,
        VERSION_2_0(2.0f){

            @Override
            void migrate(TaskRepository repository, TaskData data, BugzillaRepositoryConnector connector) {
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.LONG_DESC);
            }
        }
        ,
        VERSION_3_0(3.0f){

            @Override
            void migrate(TaskRepository repository, TaskData data, BugzillaRepositoryConnector connector) {
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.NEW_COMMENT);
            }
        }
        ,
        VERSION_4_0(4.0f){

            @Override
            void migrate(TaskRepository repository, TaskData data, BugzillaRepositoryConnector connector) {
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.DEADLINE);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.ACTUAL_TIME);
            }
        }
        ,
        VERSION_4_1(4.1f){

            @Override
            void migrate(TaskRepository repository, TaskData data, BugzillaRepositoryConnector connector) {
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.VOTES);
                TaskAttribute attrDeadline = data.getRoot().getMappedAttribute(BugzillaAttribute.VOTES.getKey());
                if (attrDeadline != null) {
                    attrDeadline.getMetaData().setType(BugzillaAttribute.VOTES.getType());
                }
            }
        }
        ,
        VERSION_4_2(4.2f){

            @Override
            void migrate(TaskRepository repository, TaskData data, BugzillaRepositoryConnector connector) {
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.CC);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.DEPENDSON);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.BLOCKED);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.BUG_FILE_LOC);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.KEYWORDS);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.STATUS_WHITEBOARD);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.QA_CONTACT);
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.NEWCC);
            }
        }
        ,
        VERSION_4_3(4.3f){

            @Override
            void migrate(TaskRepository repository, TaskData data, BugzillaRepositoryConnector connector) {
                for (TaskAttribute attribute : data.getRoot().getAttributes().values()) {
                    if (!attribute.getId().startsWith("cf_")) continue;
                    attribute.getMetaData().setKind("task.common.kind.default");
                    attribute.getMetaData().setReadOnly(false);
                    if (attribute.getOptions().size() > 0) {
                        attribute.getMetaData().setType("singleSelect");
                        continue;
                    }
                    attribute.getMetaData().setType("shortText");
                }
            }
        }
        ,
        VERSION_4_4(4.4f){

            @Override
            void migrate(TaskRepository repository, TaskData data, BugzillaRepositoryConnector connector) {
                TaskDataVersion.updateAttribute(data, BugzillaAttribute.SHORT_DESC);
            }
        }
        ,
        VERSION_4_5(4.5f){

            @Override
            void migrate(TaskRepository repository, TaskData data, BugzillaRepositoryConnector connector) {
                RepositoryConfiguration configuration = connector.getRepositoryConfiguration(repository.getRepositoryUrl());
                if (configuration == null) {
                    return;
                }
                for (TaskAttribute attribute : data.getRoot().getAttributes().values()) {
                    if (!attribute.getId().startsWith("cf_")) continue;
                    BugzillaCustomField customField = null;
                    String actName = attribute.getId();
                    for (BugzillaCustomField bugzillaCustomField : configuration.getCustomFields()) {
                        if (!actName.equals(bugzillaCustomField.getName())) continue;
                        customField = bugzillaCustomField;
                        break;
                    }
                    if (customField == null) continue;
                    String desc = customField.getDescription();
                    attribute.getMetaData().defaults().setLabel(desc).setReadOnly(false);
                    attribute.getMetaData().setKind("task.common.kind.default");
                    attribute.getMetaData().setType("shortText");
                    switch (customField.getFieldType()) {
                        case FreeText: {
                            attribute.getMetaData().setType("shortText");
                            break;
                        }
                        case DropDown: {
                            attribute.getMetaData().setType("singleSelect");
                            break;
                        }
                        case MultipleSelection: {
                            attribute.getMetaData().setType("multiSelect");
                            break;
                        }
                        case LargeText: {
                            attribute.getMetaData().setType("longText");
                            break;
                        }
                        case DateTime: {
                            attribute.getMetaData().setType("dateTime");
                            break;
                        }
                        default: {
                            List<String> options = customField.getOptions();
                            if (options.size() > 0) {
                                attribute.getMetaData().setType("singleSelect");
                                break;
                            }
                            attribute.getMetaData().setType("shortText");
                        }
                    }
                    attribute.getMetaData().setReadOnly(false);
                }
            }
        }
        ,
        VERSION_4_6(4.6f){

            @Override
            void migrate(TaskRepository repository, TaskData data, BugzillaRepositoryConnector connector) {
                String bugzillaVersionString = repository.getVersion();
                BugzillaVersion bugzillaVersion = new BugzillaVersion(bugzillaVersionString);
                if (bugzillaVersion.compareTo(BugzillaVersion.BUGZILLA_3_2) >= 0) {
                    for (TaskAttribute attribute : data.getRoot().getAttributes().values()) {
                        if (!attribute.getId().startsWith("task.common.kind.flag")) continue;
                        attribute.getMetaData().setKind("task.common.kind.flag");
                    }
                }
            }
        }
        ,
        VERSION_4_7(4.7f){

            @Override
            void migrate(TaskRepository repository, TaskData data, BugzillaRepositoryConnector connector) {
                String exporterName;
                TaskAttribute exporter = data.getRoot().getAttribute(BugzillaAttribute.EXPORTER_NAME.getKey());
                if (exporter == null && (exporterName = repository.getUserName()) != null && !exporterName.equals("")) {
                    exporter = data.getRoot().createAttribute(BugzillaAttribute.EXPORTER_NAME.getKey());
                    exporter.setValue(exporterName);
                }
            }
        }
        ,
        VERSION_CURRENT(4.8f){

            @Override
            void migrate(TaskRepository repository, TaskData data, BugzillaRepositoryConnector connector) {
                data.setVersion(VERSION_CURRENT.toString());
            }
        };

        private float versionNumber = 0.0f;

        private TaskDataVersion(float verNum) {
            this.versionNumber = verNum;
        }

        public float getVersionNum() {
            return this.versionNumber;
        }

        abstract void migrate(TaskRepository var1, TaskData var2, BugzillaRepositoryConnector var3);

        public String toString() {
            return "" + this.getVersionNum();
        }

        private static void updateAttribute(TaskData data, BugzillaAttribute bugAttribute) {
            TaskAttribute attribute = data.getRoot().getMappedAttribute(bugAttribute.getKey());
            if (attribute != null) {
                attribute.getMetaData().setType(bugAttribute.getType());
                attribute.getMetaData().setReadOnly(bugAttribute.isReadOnly());
                attribute.getMetaData().setKind(bugAttribute.getKind());
            }
        }
    }
}

