/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;

public class ReferenceDescriptor
implements IReferenceDescriptor {
    private final IMemberDescriptor origin;
    private final IMemberDescriptor target;
    private final IComponentDescriptor from;
    private final IComponentDescriptor to;
    private final int line;
    private final int kind;
    private final int flags;
    private final int visibility;
    private String[] messages = null;

    public ReferenceDescriptor(IComponentDescriptor from, IMemberDescriptor origin, int line, IComponentDescriptor to, IMemberDescriptor target, int kind, int flags, int vis, String[] messages) {
        this.origin = origin;
        this.target = target;
        this.from = from;
        this.to = to;
        this.line = line;
        this.kind = kind;
        this.flags = flags;
        this.visibility = vis;
        this.messages = messages;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof ReferenceDescriptor) {
            void rd;
            ReferenceDescriptor referenceDescriptor = (ReferenceDescriptor)object;
            ReferenceDescriptor cfr_ignored_0 = (ReferenceDescriptor)object;
            return this.origin.equals(rd.origin) && this.target.equals(rd.target) && this.from.equals(rd.from) && this.to.equals(rd.to) && this.line == rd.line && this.kind == rd.kind && this.visibility == rd.visibility;
        }
        return false;
    }

    public int hashCode() {
        return this.origin.hashCode() + this.target.hashCode() + this.from.hashCode() + this.to.hashCode() + this.line + this.kind + this.visibility;
    }

    @Override
    public IComponentDescriptor getComponent() {
        return this.from;
    }

    @Override
    public int getLineNumber() {
        return this.line;
    }

    @Override
    public IMemberDescriptor getMember() {
        return this.origin;
    }

    @Override
    public int getReferenceKind() {
        return this.kind;
    }

    @Override
    public int getReferenceFlags() {
        return this.flags;
    }

    @Override
    public int getReferenceType() {
        return switch (this.getReferencedMember().getElementType()) {
            case 2 -> 1;
            case 6 -> 3;
            case 5 -> 2;
            default -> -1;
        };
    }

    @Override
    public IComponentDescriptor getReferencedComponent() {
        return this.to;
    }

    @Override
    public IMemberDescriptor getReferencedMember() {
        return this.target;
    }

    @Override
    public int getVisibility() {
        return this.visibility;
    }

    @Override
    public String[] getProblemMessages() {
        return this.messages;
    }
}

