/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation;

import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class SourceFormatOperation
implements Consumer<EclipseProgress> {
    private final IJavaProject m_project;
    private final Document m_document;
    private final ISourceRange m_range;

    public SourceFormatOperation(ICompilationUnit icu) throws JavaModelException {
        this(icu.getJavaProject(), new Document(icu.getSource()), icu.getSourceRange());
    }

    public SourceFormatOperation(IJavaProject project, Document document) {
        this(project, document, (ISourceRange)new SourceRange(0, document.getLength()));
    }

    public SourceFormatOperation(IJavaProject project, Document document, ISourceRange range) {
        this.m_project = project;
        this.m_document = document;
        this.m_range = range;
    }

    @Override
    public void accept(EclipseProgress progress) {
        Ensure.notNull((Object)this.getProject());
        Ensure.notNull((Object)this.getDocument());
        try {
            TextEdit te;
            Document document = this.getDocument();
            ISourceRange range = this.getRange();
            if (range == null) {
                range = new SourceRange(0, document.getLength());
            }
            CodeFormatter formatter = ToolFactory.createCodeFormatter((Map)this.getProject().getOptions(true));
            String defaultLineDelimiter = document.getDefaultLineDelimiter();
            if (defaultLineDelimiter == null) {
                defaultLineDelimiter = Util.getLineSeparator(null, (IJavaProject)this.getProject());
            }
            if ((te = formatter.format(4096, document.get(), range.getOffset(), range.getLength(), 0, defaultLineDelimiter)) != null) {
                te.apply((IDocument)document);
            }
        }
        catch (BadLocationException | MalformedTreeException e) {
            throw new SdkException(e);
        }
    }

    public ISourceRange getRange() {
        return this.m_range;
    }

    public Document getDocument() {
        return this.m_document;
    }

    public IJavaProject getProject() {
        return this.m_project;
    }

    public String toString() {
        return "Format source";
    }
}

