/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.core.cdt.elf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.utils.elf.Elf;

public final class ElfUtils {
    public static int getELFType(File file) throws IOException {
        int type = -1;
        if (file != null) {
            Elf elfFile = null;
            try {
                elfFile = new Elf(file.getAbsolutePath());
                type = elfFile.getAttributes().getType();
            }
            finally {
                if (elfFile != null) {
                    elfFile.dispose();
                }
                Object var2_2 = null;
            }
        }
        return type;
    }

    public static int getELFClass(File file) throws IOException {
        int elfclass = 0;
        if (file != null) {
            Elf elfFile = null;
            try {
                elfFile = new Elf(file.getAbsolutePath());
                elfclass = elfFile.getELFhdr().e_ident[4];
            }
            finally {
                if (elfFile != null) {
                    elfFile.dispose();
                }
                Object var2_2 = null;
            }
        }
        return elfclass;
    }

    public static int getELFMachine(File file) throws IOException {
        int elfclass = 0;
        if (file != null) {
            Elf elfFile = null;
            try {
                elfFile = new Elf(file.getAbsolutePath());
                elfclass = elfFile.getELFhdr().e_machine;
            }
            finally {
                if (elfFile != null) {
                    elfFile.dispose();
                }
                Object var2_2 = null;
            }
        }
        return elfclass;
    }

    public static String[] getEntryPoints(File file) throws IOException {
        String[] entryPoints = null;
        if (file != null) {
            Elf elfFile = null;
            try {
                elfFile = new Elf(file.getAbsolutePath());
                elfFile.loadSymbols();
                Elf.Symbol[] symbols = elfFile.getSymbols();
                if (symbols != null) {
                    ArrayList<String> entryPointList = new ArrayList<String>();
                    Elf.Symbol[] symbolArray = symbols;
                    int n = symbols.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Elf.Symbol s = symbolArray[n2];
                        if (s.st_type() == 2) {
                            entryPointList.add(s.toString());
                        }
                        ++n2;
                    }
                    entryPoints = entryPointList.toArray(new String[entryPointList.size()]);
                }
            }
            finally {
                if (elfFile != null) {
                    elfFile.dispose();
                }
                Object var2_2 = null;
            }
        }
        return entryPoints;
    }
}

