/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette;

import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.model.description.CreationDescription;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.jdt.ui.JdtUiUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public class TypeParameterComposite
extends Composite {
    private final CreationDescription.TypeParameterDescription m_typeParameter;
    private final IJavaProject m_javaProject;
    private final Label m_label;
    private final Text m_text;
    private final Button m_button;

    public TypeParameterComposite(Composite parent, int style, IJavaProject javaProject, CreationDescription.TypeParameterDescription typeParameter) {
        super(parent, style);
        GridLayoutFactory.create((Composite)this).columns(3);
        this.m_typeParameter = typeParameter;
        this.m_javaProject = javaProject;
        this.m_label = new Label((Composite)this, 0);
        GridDataFactory.create((Control)this.m_label).alignHR();
        this.m_label.setText(this.m_typeParameter.getTitle() + ":");
        this.m_text = new Text((Composite)this, 2048);
        GridDataFactory.create((Control)this.m_text).grabH().fillH();
        this.m_text.setText(this.m_typeParameter.getTypeName());
        this.m_button = new Button((Composite)this, 0);
        this.m_button.setText("...");
        this.m_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        TypeParameterComposite.this.chooseType();
                    }
                });
            }
        });
    }

    public String getArgument() {
        String argumentText = this.m_text.getText();
        return StringUtils.isEmpty((String)argumentText) ? this.m_typeParameter.getTypeName() : argumentText;
    }

    private void chooseType() throws Exception {
        IType selectedType = JdtUiUtils.selectType(this.getShell(), this.m_javaProject);
        if (selectedType == null) {
            return;
        }
        String parameterTypeName = this.m_typeParameter.getTypeName();
        IType parameterType = this.m_javaProject.findType(parameterTypeName);
        ITypeHierarchy hierarchy = selectedType.newSupertypeHierarchy(null);
        if (!hierarchy.contains(parameterType)) {
            String message = MessageFormat.format(Messages.TypeParameterComposite_subTypeMessage, selectedType.getFullyQualifiedName(), parameterTypeName);
            UiUtils.openError((Shell)this.getShell(), (String)Messages.TypeParameterComposite_subTypeTitle, (String)message);
            return;
        }
        this.m_text.setText(selectedType.getFullyQualifiedName());
    }
}

