/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.event;

import com.google.common.collect.HashMultimap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.model.property.event.ListenerMethodInfo;
import org.eclipse.wb.internal.core.utils.GenericTypeResolver;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

final class ListenerInfo {
    private final Class<?> m_componentClass;
    private final Method m_method;
    private final String m_methodSignature;
    private final boolean m_deprecated;
    private String m_name;
    private final String m_simpleName;
    private final Class<?> m_interfaceType;
    private boolean m_adapterTypeReady;
    private Class<?> m_adapterType;
    private final GenericTypeResolver m_externalResolver;
    private List<ListenerMethodInfo> m_methods;

    public ListenerInfo(Method method, Class<?> componentClass, GenericTypeResolver externalResolver) {
        this.m_method = method;
        this.m_componentClass = componentClass;
        this.m_externalResolver = externalResolver;
        this.m_methodSignature = ReflectionUtils.getMethodSignature((Method)this.m_method);
        this.m_deprecated = this.m_method.getAnnotation(Deprecated.class) != null;
        this.m_name = ListenerInfo._getListenerName(this.m_method);
        this.m_simpleName = ListenerInfo._getListenerSimpleName(this.m_method);
        this.m_interfaceType = this.m_method.getParameterTypes()[0];
    }

    static boolean isAddListenerMethod(Method method) {
        String methodName = method.getName();
        return methodName.startsWith("add") && (methodName.endsWith("Listener") || methodName.endsWith("Handler")) && method.getParameterTypes().length == 1;
    }

    private static String _getListenerName(Method addListenerMethod) {
        String name = ListenerInfo._getListenerSimpleName(addListenerMethod);
        String parameterName = "(" + addListenerMethod.getParameterTypes()[0].getName() + ")";
        return name + parameterName;
    }

    private static String _getListenerSimpleName(Method addListenerMethod) {
        String name = addListenerMethod.getName();
        name = StringUtils.removeStart((String)name, (String)"add");
        name = StringUtils.removeEnd((String)name, (String)"Listener");
        name = StringUtils.removeEnd((String)name, (String)"Handler");
        if ((name = StringUtils.uncapitalize((String)name)).length() == 0) {
            name = addListenerMethod.getName();
        }
        return name;
    }

    private static Class<?> _getAdapterType(Class<?> listenerType) {
        Class<?> adapterType = null;
        Object adapterClassName = listenerType.getName();
        adapterClassName = StringUtils.removeEnd((String)adapterClassName, (String)"Listener");
        adapterClassName = StringUtils.removeEnd((String)adapterClassName, (String)"Handler");
        adapterType = ListenerInfo._getExistingType(listenerType, (String)(adapterClassName = (String)adapterClassName + "Adapter"));
        if (adapterType == null) {
            adapterClassName = listenerType.getName();
            adapterClassName = (String)adapterClassName + "Adapter";
            adapterType = ListenerInfo._getExistingType(listenerType, (String)adapterClassName);
        }
        return adapterType;
    }

    private static Class<?> _getExistingType(Class<?> someType, String typeNameToLoad) {
        try {
            ClassLoader classLoader = ReflectionUtils.getClassLoader(someType);
            return classLoader.loadClass(typeNameToLoad);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public Method getMethod() {
        return this.m_method;
    }

    public String getMethodSignature() {
        return this.m_methodSignature;
    }

    public boolean isDeprecated() {
        return this.m_deprecated;
    }

    public String getName() {
        return this.m_name;
    }

    public String getSimpleName() {
        return this.m_simpleName;
    }

    public Class<?> getInterface() {
        return this.m_interfaceType;
    }

    public Class<?> getAdapter() {
        if (!this.m_adapterTypeReady) {
            this.m_adapterTypeReady = true;
            this.m_adapterType = ListenerInfo._getAdapterType(this.m_interfaceType);
        }
        return this.m_adapterType;
    }

    public boolean hasAdapter() {
        return this.getAdapter() != null;
    }

    public Class<?> getListenerType() {
        Class<?> adapterType = this.getAdapter();
        return adapterType != null ? adapterType : this.m_interfaceType;
    }

    public GenericTypeResolver getResolver() {
        GenericTypeResolver resolver_1 = GenericTypeResolver.superClass((GenericTypeResolver)this.m_externalResolver, this.m_componentClass, this.m_method.getDeclaringClass());
        GenericTypeResolver resolver_2 = GenericTypeResolver.argumentOfMethod((GenericTypeResolver)resolver_1, (Method)this.m_method, (int)0);
        return resolver_2;
    }

    public List<ListenerMethodInfo> getMethods() {
        if (this.m_methods == null) {
            this.m_methods = new ArrayList<ListenerMethodInfo>();
            Method[] methodArray = this.m_interfaceType.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (this.isListenerMethod(method)) {
                    this.m_methods.add(new ListenerMethodInfo(this, method));
                }
                ++n2;
            }
            Collections.sort(this.m_methods, new Comparator<ListenerMethodInfo>(){

                @Override
                public int compare(ListenerMethodInfo method_1, ListenerMethodInfo method_2) {
                    return method_1.getName().compareTo(method_2.getName());
                }
            });
        }
        return this.m_methods;
    }

    private boolean isListenerMethod(Method method) {
        if (method.isBridge()) {
            return false;
        }
        if (ReflectionUtils.isAbstract((Method)method)) {
            return true;
        }
        return method.getDeclaringClass() == this.m_interfaceType;
    }

    static void useSimpleNamesWherePossible(List<ListenerInfo> listeners) {
        String simpleName;
        String qualifiedName;
        HashMultimap simplePropertyNames = HashMultimap.create();
        for (ListenerInfo listener : listeners) {
            qualifiedName = listener.getName();
            simpleName = ListenerInfo.getSimpleName(qualifiedName);
            simplePropertyNames.put((Object)simpleName, (Object)qualifiedName);
        }
        for (ListenerInfo listener : listeners) {
            qualifiedName = listener.getName();
            simpleName = ListenerInfo.getSimpleName(qualifiedName);
            if (simplePropertyNames.get((Object)simpleName).size() != 1) continue;
            listener.m_name = simpleName;
        }
    }

    private static String getSimpleName(String qualifiedName) {
        return StringUtils.substringBefore((String)qualifiedName, (String)"(");
    }
}

